/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.elasticsearch.gradle.precommit.PrecommitTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;

public class PomValidationTask
extends PrecommitTask {
    private final RegularFileProperty pomFile = this.getProject().getObjects().fileProperty();
    private boolean foundError;

    @InputFile
    public RegularFileProperty getPomFile() {
        return this.pomFile;
    }

    @TaskAction
    public void checkPom() throws Exception {
        try (FileReader fileReader = new FileReader((File)this.pomFile.getAsFile().get());){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)fileReader);
            this.validateString("groupId", model.getGroupId());
            this.validateString("artifactId", model.getArtifactId());
            this.validateString("version", model.getVersion());
            this.validateString("name", model.getName());
            this.validateString("description", model.getDescription());
            this.validateString("url", model.getUrl());
            this.validateCollection("licenses", model.getLicenses(), v -> {
                this.validateString("licenses.name", v.getName());
                this.validateString("licenses.url", v.getUrl());
            });
            this.validateCollection("developers", model.getDevelopers(), v -> {
                this.validateString("developers.name", v.getName());
                this.validateString("developers.url", v.getUrl());
            });
            this.validateNonNull("scm", model.getScm(), () -> this.validateString("scm.url", model.getScm().getUrl()));
        }
        if (this.foundError) {
            throw new GradleException("Check failed for task '" + this.getPath() + "', see console log for details");
        }
    }

    private void logError(String element, String message) {
        this.foundError = true;
        this.getLogger().error("{} {} in [{}]", new Object[]{element, message, this.pomFile.getAsFile().get()});
    }

    private <T> void validateNonEmpty(String element, T value, Predicate<T> isEmpty) {
        if (isEmpty.test(value)) {
            this.logError(element, "is empty");
        }
    }

    private <T> void validateNonNull(String element, T value, Runnable validator) {
        if (value == null) {
            this.logError(element, "is missing");
        } else {
            validator.run();
        }
    }

    private void validateString(String element, String value) {
        this.validateNonNull(element, value, () -> this.validateNonEmpty(element, value, s -> s.trim().isEmpty()));
    }

    private <T> void validateCollection(String element, Collection<T> value, Consumer<T> validator) {
        this.validateNonNull(element, value, () -> {
            this.validateNonEmpty(element, value, Collection::isEmpty);
            value.forEach(validator);
        });
    }
}

