/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.File;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.precommit.PrecommitTask;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

@CacheableTask
public class LoggerUsageTask
extends PrecommitTask {
    private FileCollection classpath;

    public LoggerUsageTask() {
        this.setDescription("Runs LoggerUsageCheck on output directories of all source sets");
    }

    @TaskAction
    public void runLoggerUsageTask() {
        LoggedExec.javaexec(this.getProject(), (Action<JavaExecSpec>)((Action)spec -> {
            spec.setMain("org.elasticsearch.test.loggerusage.ESLoggerUsageChecker");
            spec.classpath(new Object[]{this.getClasspath()});
            this.getClassDirectories().forEach(xva$0 -> spec.args(new Object[]{xva$0}));
        }));
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getClassDirectories() {
        return ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().stream().filter(sourceSet -> sourceSet.getName().equals("main") || sourceSet.getName().equals("test")).map(sourceSet -> sourceSet.getOutput().getClassesDirs()).reduce(FileCollection::plus).orElse((FileCollection)this.getProject().files(new Object[0])).filter(File::exists);
    }
}

