/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.File;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.precommit.PrecommitTask;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

@CacheableTask
public class JarHellTask
extends PrecommitTask {
    private FileCollection classpath;

    public JarHellTask() {
        this.setDescription("Runs CheckJarHell on the configured classpath");
    }

    @TaskAction
    public void runJarHellCheck() {
        LoggedExec.javaexec(this.getProject(), (Action<JavaExecSpec>)((Action)spec -> {
            spec.environment("CLASSPATH", (Object)this.getClasspath().getAsPath());
            spec.setMain("org.elasticsearch.bootstrap.JarHell");
        }));
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.classpath.filter(File::exists);
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }
}

