/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.elasticsearch.gradle.LazyFileOutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Internal;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;

public class LoggedExec
extends Exec {
    private static final Logger LOGGER = Logging.getLogger(LoggedExec.class);
    private Consumer<Logger> outputLogger;
    private static final Pattern NEWLINE = Pattern.compile(System.lineSeparator());

    public LoggedExec() {
        if (!this.getLogger().isInfoEnabled()) {
            this.setIgnoreExitValue(true);
            this.setSpoolOutput(false);
            this.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    if (LoggedExec.this.getExecResult().getExitValue() != 0) {
                        try {
                            LoggedExec.this.getLogger().error("Output for " + LoggedExec.this.getExecutable() + ":");
                            LoggedExec.this.outputLogger.accept(LoggedExec.this.getLogger());
                        }
                        catch (Exception e) {
                            throw new GradleException("Failed to read exec output", (Throwable)e);
                        }
                        throw new GradleException(String.format("Process '%s %s' finished with non-zero exit value %d", LoggedExec.this.getExecutable(), LoggedExec.this.getArgs(), LoggedExec.this.getExecResult().getExitValue()));
                    }
                }
            });
        }
    }

    @Internal
    public void setSpoolOutput(boolean spoolOutput) {
        OutputStream out;
        if (spoolOutput) {
            File spoolFile = new File(this.getProject().getBuildDir() + "/buffered-output/" + this.getName());
            out = new LazyFileOutputStream(spoolFile);
            this.outputLogger = logger -> {
                try {
                    if (Files.exists(spoolFile.toPath(), new LinkOption[0])) {
                        Files.lines(spoolFile.toPath()).forEach(arg_0 -> ((Logger)logger).error(arg_0));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("could not log", e);
                }
            };
        } else {
            out = new ByteArrayOutputStream();
            this.outputLogger = logger -> {
                try {
                    logger.error(((ByteArrayOutputStream)out).toString("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        this.setStandardOutput(out);
        this.setErrorOutput(out);
    }

    public static ExecResult exec(Project project, Action<ExecSpec> action) {
        return LoggedExec.genericExec(arg_0 -> ((Project)project).exec(arg_0), action);
    }

    public static ExecResult exec(ExecOperations execOperations, Action<ExecSpec> action) {
        return LoggedExec.genericExec(arg_0 -> ((ExecOperations)execOperations).exec(arg_0), action);
    }

    public static ExecResult javaexec(Project project, Action<JavaExecSpec> action) {
        return LoggedExec.genericExec(arg_0 -> ((Project)project).javaexec(arg_0), action);
    }

    private static <T extends BaseExecSpec> ExecResult genericExec(Function<Action<T>, ExecResult> function, Action<T> action) {
        if (LOGGER.isInfoEnabled()) {
            return function.apply(action);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            return function.apply(spec -> {
                spec.setStandardOutput((OutputStream)output);
                spec.setErrorOutput((OutputStream)output);
                action.execute(spec);
                try {
                    output.write(("Output for " + spec.getExecutable() + ":").getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (Exception e) {
            try {
                if (output.size() != 0) {
                    LOGGER.error("Exec output and error:");
                    NEWLINE.splitAsStream(output.toString("UTF-8")).forEach(s -> LOGGER.error("| " + s));
                }
            }
            catch (UnsupportedEncodingException ue) {
                throw new GradleException("Failed to read exec output", (Throwable)ue);
            }
            throw e;
        }
    }
}

