/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;

public class ExportElasticsearchBuildResourcesTask
extends DefaultTask {
    private final Logger logger = Logging.getLogger(ExportElasticsearchBuildResourcesTask.class);
    private final Set<String> resources = new HashSet<String>();
    private DirectoryProperty outputDir = this.getProject().getObjects().directoryProperty();

    public ExportElasticsearchBuildResourcesTask() {
        this.outputDir.set(new File(this.getProject().getBuildDir(), "build-tools-exported"));
    }

    @OutputDirectory
    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @Input
    public Set<String> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    @Classpath
    public String getResourcesClasspath() {
        this.logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
        return System.getProperty("java.class.path");
    }

    public void setOutputDir(File outputDir) {
        this.outputDir.set(outputDir);
    }

    public File copy(String resource) {
        if (this.getState().getExecuted() || this.getState().getExecuting()) {
            throw new GradleException("buildResources can't be configured after the task ran. Make sure task is not used after configuration time");
        }
        this.resources.add(resource);
        return ((RegularFile)this.outputDir.file(resource).get()).getAsFile();
    }

    @TaskAction
    public void doExport() {
        if (this.resources.isEmpty()) {
            this.setDidWork(false);
            throw new StopExecutionException();
        }
        ((Stream)this.resources.stream().parallel()).forEach(resourcePath -> {
            Path destination = ((Directory)this.outputDir.get()).file(resourcePath).getAsFile().toPath();
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)resourcePath);){
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                if (is == null) {
                    throw new GradleException("Can't export `" + resourcePath + "` from build-tools: not found");
                }
                Files.copy(is, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new GradleException("Can't write resource `" + resourcePath + "` to " + destination, (Throwable)e);
            }
        });
    }
}

