/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.BwcVersions;
import org.elasticsearch.gradle.ElasticsearchDistribution;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.docker.DockerSupportPlugin;
import org.elasticsearch.gradle.docker.DockerSupportService;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.info.GlobalBuildInfoPlugin;
import org.elasticsearch.gradle.util.GradleUtils;
import org.elasticsearch.gradle.util.Util;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.authentication.http.HttpHeaderAuthentication;

public class DistributionDownloadPlugin
implements Plugin<Project> {
    private static final String CONTAINER_NAME = "elasticsearch_distributions";
    private static final String FAKE_IVY_GROUP = "elasticsearch-distribution";
    private static final String FAKE_SNAPSHOT_IVY_GROUP = "elasticsearch-distribution-snapshot";
    private static final String DOWNLOAD_REPO_NAME = "elasticsearch-downloads";
    private static final String SNAPSHOT_REPO_NAME = "elasticsearch-snapshots";
    private BwcVersions bwcVersions;
    private NamedDomainObjectContainer<ElasticsearchDistribution> distributionsContainer;

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        project.getRootProject().getPluginManager().apply(DockerSupportPlugin.class);
        Provider dockerSupport = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "dockerSupportService");
        this.distributionsContainer = project.container(ElasticsearchDistribution.class, name -> {
            Configuration fileConfiguration = (Configuration)project.getConfigurations().create("es_distro_file_" + name);
            Configuration extractedConfiguration = (Configuration)project.getConfigurations().create("es_distro_extracted_" + name);
            return new ElasticsearchDistribution(name, project.getObjects(), (Provider<DockerSupportService>)dockerSupport, fileConfiguration, extractedConfiguration);
        });
        project.getExtensions().add(CONTAINER_NAME, this.distributionsContainer);
        DistributionDownloadPlugin.setupDownloadServiceRepo(project);
        if (BuildParams.isInternal().booleanValue()) {
            ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
            this.bwcVersions = (BwcVersions)extraProperties.get("bwcVersions");
        }
        project.afterEvaluate(this::setupDistributions);
    }

    public static NamedDomainObjectContainer<ElasticsearchDistribution> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(CONTAINER_NAME);
    }

    void setupDistributions(Project project) {
        for (ElasticsearchDistribution distribution : this.distributionsContainer) {
            distribution.finalizeValues();
            DependencyHandler dependencies = project.getDependencies();
            dependencies.add(distribution.configuration.getName(), this.dependencyNotation(project, distribution));
            if (!distribution.getType().shouldExtract()) continue;
            dependencies.add(distribution.getExtracted().configuration.getName(), (Object)DistributionDownloadPlugin.projectDependency(project, ":", DistributionDownloadPlugin.configName("extracted_elasticsearch", distribution)));
            this.setupRootDownload(project.getRootProject(), distribution);
        }
    }

    private void setupRootDownload(Project rootProject, ElasticsearchDistribution distribution) {
        String extractTaskName = DistributionDownloadPlugin.extractTaskName(distribution);
        try {
            rootProject.getTasks().named(extractTaskName);
            return;
        }
        catch (UnknownTaskException unknownTaskException) {
            block5: {
                Configuration downloadConfig;
                String extractedConfigName;
                block4: {
                    DistributionDownloadPlugin.setupDownloadServiceRepo(rootProject);
                    ConfigurationContainer configurations = rootProject.getConfigurations();
                    String downloadConfigName = DistributionDownloadPlugin.configName("elasticsearch", distribution);
                    extractedConfigName = "extracted_" + downloadConfigName;
                    downloadConfig = (Configuration)configurations.create(downloadConfigName);
                    configurations.create(extractedConfigName);
                    rootProject.getDependencies().add(downloadConfigName, this.dependencyNotation(rootProject, distribution));
                    if (distribution.getType() == ElasticsearchDistribution.Type.ARCHIVE) break block4;
                    if (distribution.getType() != ElasticsearchDistribution.Type.INTEG_TEST_ZIP) break block5;
                }
                Supplier<File> archiveGetter = () -> ((Configuration)downloadConfig).getSingleFile();
                String extractDir = rootProject.getBuildDir().toPath().resolve("elasticsearch-distros").resolve(extractedConfigName).toString();
                TaskProvider extractTask = rootProject.getTasks().register(extractTaskName, Sync.class, syncTask -> {
                    syncTask.dependsOn(new Object[]{downloadConfig});
                    syncTask.into((Object)extractDir);
                    syncTask.from(new Object[]{() -> DistributionDownloadPlugin.lambda$setupRootDownload$1((Supplier)archiveGetter, rootProject)});
                    syncTask.eachFile(details -> {
                        String[] segments = details.getRelativePath().getSegments();
                        if (segments[0].equals(".")) {
                            details.setRelativePath(new RelativePath(true, Arrays.copyOfRange(segments, 1, segments.length)));
                        }
                    });
                });
                rootProject.getArtifacts().add(extractedConfigName, (Object)rootProject.getLayout().getProjectDirectory().dir(extractDir), artifact -> artifact.builtBy(new Object[]{extractTask}));
            }
            return;
        }
    }

    private static void addIvyRepo(Project project, String name, String url, String group) {
        IvyArtifactRepository ivyRepo = project.getRepositories().ivy(repo -> {
            repo.setName(name);
            repo.setUrl((Object)url);
            repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
            repo.credentials(HttpHeaderCredentials.class, creds -> {
                creds.setName("X-Elastic-No-KPI");
                creds.setValue("1");
            });
            repo.getAuthentication().create("header", HttpHeaderAuthentication.class);
            repo.patternLayout(layout -> layout.artifact("/downloads/elasticsearch/[module]-[revision](-[classifier]).[ext]"));
        });
        project.getRepositories().exclusiveContent(exclusiveContentRepository -> {
            exclusiveContentRepository.filter(config -> config.includeGroup(group));
            exclusiveContentRepository.forRepositories(new ArtifactRepository[]{ivyRepo});
        });
    }

    private static void setupDownloadServiceRepo(Project project) {
        if (project.getRepositories().findByName(DOWNLOAD_REPO_NAME) != null) {
            return;
        }
        DistributionDownloadPlugin.addIvyRepo(project, DOWNLOAD_REPO_NAME, "https://artifacts.elastic.co", FAKE_IVY_GROUP);
        if (!BuildParams.isInternal().booleanValue()) {
            DistributionDownloadPlugin.addIvyRepo(project, SNAPSHOT_REPO_NAME, "https://snapshots.elastic.co", FAKE_SNAPSHOT_IVY_GROUP);
        }
    }

    private Object dependencyNotation(Project project, ElasticsearchDistribution distribution) {
        if (BuildParams.isInternal().booleanValue()) {
            if (VersionProperties.getElasticsearch().equals(distribution.getVersion())) {
                return DistributionDownloadPlugin.projectDependency(project, DistributionDownloadPlugin.distributionProjectPath(distribution), "default");
            }
            BwcVersions.UnreleasedVersionInfo unreleasedInfo = this.bwcVersions.unreleasedInfo(Version.fromString(distribution.getVersion()));
            if (unreleasedInfo != null) {
                assert (distribution.getBundledJdk());
                return DistributionDownloadPlugin.projectDependency(project, unreleasedInfo.gradleProjectPath, DistributionDownloadPlugin.distributionProjectName(distribution));
            }
        }
        if (distribution.getType() == ElasticsearchDistribution.Type.INTEG_TEST_ZIP) {
            return "org.elasticsearch.distribution.integ-test-zip:elasticsearch:" + distribution.getVersion() + "@zip";
        }
        Version distroVersion = Version.fromString(distribution.getVersion());
        String extension = distribution.getType().toString();
        Object classifier = ":x86_64";
        if (distribution.getType() == ElasticsearchDistribution.Type.ARCHIVE) {
            String string = extension = distribution.getPlatform() == ElasticsearchDistribution.Platform.WINDOWS ? "zip" : "tar.gz";
            classifier = distroVersion.onOrAfter("7.0.0") ? ":" + distribution.getPlatform() + "-x86_64" : "";
        } else if (distribution.getType() == ElasticsearchDistribution.Type.DEB) {
            classifier = distroVersion.onOrAfter("7.0.0") ? ":amd64" : "";
        } else if (distribution.getType() == ElasticsearchDistribution.Type.RPM && distroVersion.before("7.0.0")) {
            classifier = "";
        }
        String flavor = "";
        if (distribution.getFlavor() == ElasticsearchDistribution.Flavor.OSS && distroVersion.onOrAfter("6.3.0")) {
            flavor = "-oss";
        }
        String group = distribution.getVersion().endsWith("-SNAPSHOT") ? FAKE_SNAPSHOT_IVY_GROUP : FAKE_IVY_GROUP;
        return group + ":elasticsearch" + flavor + ":" + distribution.getVersion() + (String)classifier + "@" + extension;
    }

    private static Dependency projectDependency(Project project, String projectPath, String projectConfig) {
        if (project.findProject(projectPath) == null) {
            throw new GradleException("no project [" + projectPath + "], project names: " + project.getRootProject().getAllprojects());
        }
        HashMap<String, String> depConfig = new HashMap<String, String>();
        depConfig.put("path", projectPath);
        depConfig.put("configuration", projectConfig);
        return project.getDependencies().project(depConfig);
    }

    private static String distributionProjectPath(ElasticsearchDistribution distribution) {
        Object projectPath = ":distribution";
        switch (distribution.getType()) {
            case INTEG_TEST_ZIP: {
                projectPath = (String)projectPath + ":archives:integ-test-zip";
                break;
            }
            case DOCKER: {
                projectPath = (String)projectPath + ":docker:";
                projectPath = (String)projectPath + DistributionDownloadPlugin.distributionProjectName(distribution);
                break;
            }
            default: {
                projectPath = (String)projectPath + (distribution.getType() == ElasticsearchDistribution.Type.ARCHIVE ? ":archives:" : ":packages:");
                projectPath = (String)projectPath + DistributionDownloadPlugin.distributionProjectName(distribution);
            }
        }
        return projectPath;
    }

    private static String distributionProjectName(ElasticsearchDistribution distribution) {
        String archString;
        ElasticsearchDistribution.Platform platform = distribution.getPlatform();
        Architecture architecture = distribution.getArchitecture();
        Object projectName = "";
        String string = archString = platform == ElasticsearchDistribution.Platform.WINDOWS || architecture == Architecture.X64 ? "" : "-" + architecture.toString().toLowerCase();
        if (distribution.getFlavor() == ElasticsearchDistribution.Flavor.OSS) {
            projectName = (String)projectName + "oss-";
        }
        if (!distribution.getBundledJdk()) {
            projectName = (String)projectName + "no-jdk-";
        }
        switch (distribution.getType()) {
            case ARCHIVE: {
                if (Version.fromString(distribution.getVersion()).onOrAfter("7.0.0")) {
                    projectName = (String)projectName + platform.toString() + archString + (platform == ElasticsearchDistribution.Platform.WINDOWS ? "-zip" : "-tar");
                    break;
                }
                projectName = distribution.getFlavor().equals((Object)ElasticsearchDistribution.Flavor.DEFAULT) ? "zip" : "oss-zip";
                break;
            }
            case DOCKER: {
                projectName = (String)projectName + "docker" + archString + "-export";
                break;
            }
            default: {
                projectName = (String)projectName + distribution.getType();
            }
        }
        return projectName;
    }

    private static String configName(String prefix, ElasticsearchDistribution distribution) {
        return String.format("%s_%s_%s_%s%s%s", new Object[]{prefix, distribution.getVersion(), distribution.getType(), distribution.getPlatform() == null ? "" : distribution.getPlatform() + "_", distribution.getFlavor(), distribution.getBundledJdk() ? "" : "_nojdk"});
    }

    private static String extractTaskName(ElasticsearchDistribution distribution) {
        Object taskName = "extractElasticsearch";
        if (distribution.getType() != ElasticsearchDistribution.Type.INTEG_TEST_ZIP) {
            if (distribution.getFlavor() == ElasticsearchDistribution.Flavor.OSS) {
                taskName = (String)taskName + "Oss";
            }
            if (!distribution.getBundledJdk()) {
                taskName = (String)taskName + "NoJdk";
            }
        }
        if (distribution.getType() == ElasticsearchDistribution.Type.ARCHIVE) {
            taskName = (String)taskName + Util.capitalize(distribution.getPlatform().toString());
        } else if (distribution.getType() != ElasticsearchDistribution.Type.INTEG_TEST_ZIP) {
            taskName = (String)taskName + Util.capitalize(distribution.getType().toString());
        }
        taskName = (String)taskName + distribution.getVersion();
        return taskName;
    }

    private static /* synthetic */ FileTree lambda$setupRootDownload$1(Supplier archiveGetter, Project rootProject) throws Exception {
        File archiveFile = (File)archiveGetter.get();
        String archivePath = archiveFile.toString();
        if (archivePath.endsWith(".zip")) {
            return rootProject.zipTree((Object)archiveFile);
        }
        if (archivePath.endsWith(".tar.gz")) {
            return rootProject.tarTree((Object)rootProject.getResources().gzip((Object)archiveFile));
        }
        throw new IllegalStateException("unexpected file extension on [" + archivePath + "]");
    }
}

