/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ConcatFilesTask
extends DefaultTask {
    private FileTree files;
    private String headerLine;
    private File target;

    public ConcatFilesTask() {
        this.setDescription("Concat a list of files into one.");
    }

    public void setFiles(FileTree files) {
        this.files = files;
    }

    @InputFiles
    public FileTree getFiles() {
        return this.files;
    }

    public void setHeaderLine(String headerLine) {
        this.headerLine = headerLine;
    }

    @Input
    @Optional
    public String getHeaderLine() {
        return this.headerLine;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    @OutputFile
    public File getTarget() {
        return this.target;
    }

    @TaskAction
    public void concatFiles() throws IOException {
        if (this.getHeaderLine() != null) {
            Files.write(this.getTarget().toPath(), (this.getHeaderLine() + "\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        LinkedHashSet<String> uniqueLines = new LinkedHashSet<String>();
        for (File f : this.getFiles()) {
            uniqueLines.addAll(Files.readAllLines(f.toPath(), StandardCharsets.UTF_8));
        }
        Files.write(this.getTarget().toPath(), uniqueLines, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
    }
}

