/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import com.github.jengelman.gradle.plugins.shadow.ShadowBasePlugin;
import com.github.jengelman.gradle.plugins.shadow.ShadowExtension;
import com.github.jengelman.gradle.plugins.shadow.ShadowJavaPlugin;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import nebula.plugin.info.InfoBrokerPlugin;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.elasticsearch.gradle.DependenciesInfoTask;
import org.elasticsearch.gradle.ExportElasticsearchBuildResourcesTask;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.info.GlobalBuildInfoPlugin;
import org.elasticsearch.gradle.plugin.PluginBuildPlugin;
import org.elasticsearch.gradle.precommit.DependencyLicensesTask;
import org.elasticsearch.gradle.precommit.PrecommitTasks;
import org.elasticsearch.gradle.test.ErrorReportingTestListener;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.testclusters.TestDistribution;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.ExclusiveContentRepository;
import org.gradle.api.artifacts.repositories.InclusiveRepositoryContentDescriptor;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.authentication.http.HttpHeaderAuthentication;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.internal.jvm.Jvm;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.util.GradleVersion;

public class BuildPlugin
implements Plugin<Project>,
GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public BuildPlugin() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        if (project.getPluginManager().hasPlugin("elasticsearch.standalone-rest-test")) {
            throw (Throwable)new InvalidUserDataException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"elasticsearch.standalone-test, ", (CharSequence)"elasticsearch.standalone-rest-test, and elasticsearch.build "), (CharSequence)"are mutually exclusive"));
        }
        String minimumGradleVersion = null;
        try (InputStream is = this.getClass().getResourceAsStream("/minimumGradleVersion");){
            String string;
            minimumGradleVersion = string = IOUtils.toString((InputStream)is, (String)StandardCharsets.UTF_8.toString());
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)GradleVersion.current(), (Object)GradleVersion.version((String)minimumGradleVersion.trim()))) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{minimumGradleVersion}, new String[]{"Gradle ", "+ is required to use elasticsearch.build plugin"})));
        }
        project.getPluginManager().apply("elasticsearch.java");
        BuildPlugin.configureJars(project);
        BuildPlugin.configureJarManifest(project);
        project.getRootProject().getPluginManager().apply(TestFailureReportingPlugin.class);
        project.getTasks().register("buildResources", ExportElasticsearchBuildResourcesTask.class);
        BuildPlugin.configureRepositories(project);
        ((ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class)).set("versions", VersionProperties.getVersions());
        BuildPlugin.configureJavadoc(project);
        BuildPlugin.configureSourcesJar(project);
        BuildPlugin.configurePomGeneration(project);
        BuildPlugin.configurePrecommit(project);
        BuildPlugin.configureDependenciesInfo(project);
        BuildPlugin.configureFips140(project);
    }

    public static void configureFips140(Project project) {
        Reference project2 = new Reference((Object)project);
        if (DefaultTypeTransformation.booleanUnbox((Object)BuildPlugin.inFipsJvm())) {
            public final class _configureFips140_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _configureFips140_closure1(Object _outerInstance, Object _thisObject, Reference project) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.project = reference = project;
                }

                public Object doCall(Object it) {
                    ((Project)this.project.get()).getDependencies().add("extraJars", (Object)"org.bouncycastle:bc-fips:1.0.1");
                    return ((Project)this.project.get()).getDependencies().add("extraJars", (Object)"org.bouncycastle:bctls-fips:1.0.9");
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _configureFips140_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            GradleUtils.maybeCreate(((Project)project2.get()).getConfigurations(), "extraJars", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureFips140_closure1(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
            Reference buildResources = new Reference((Object)((ExportElasticsearchBuildResourcesTask)((Object)ScriptBytecodeAdapter.asType((Object)((Project)project2.get()).getTasks().getByName("buildResources"), ExportElasticsearchBuildResourcesTask.class))));
            Reference securityProperties = new Reference((Object)((ExportElasticsearchBuildResourcesTask)((Object)buildResources.get())).copy("fips_java.security"));
            Reference security8Properties = new Reference((Object)((ExportElasticsearchBuildResourcesTask)((Object)buildResources.get())).copy("fips_java8.security"));
            Reference securityPolicy = new Reference((Object)((ExportElasticsearchBuildResourcesTask)((Object)buildResources.get())).copy("fips_java.policy"));
            Reference security8Policy = new Reference((Object)((ExportElasticsearchBuildResourcesTask)((Object)buildResources.get())).copy("fips_java8.policy"));
            Reference bcfksKeystore = new Reference((Object)((ExportElasticsearchBuildResourcesTask)((Object)buildResources.get())).copy("cacerts.bcfks"));
            public final class _configureFips140_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference securityProperties;
                private /* synthetic */ Reference securityPolicy;
                private /* synthetic */ Reference security8Properties;
                private /* synthetic */ Reference security8Policy;
                private /* synthetic */ Reference bcfksKeystore;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _configureFips140_closure2(Object _outerInstance, Object _thisObject, Reference project, Reference securityProperties, Reference securityPolicy, Reference security8Properties, Reference security8Policy, Reference bcfksKeystore) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    this.project = reference6 = project;
                    this.securityProperties = reference5 = securityProperties;
                    this.securityPolicy = reference4 = securityPolicy;
                    this.security8Properties = reference3 = security8Properties;
                    this.security8Policy = reference2 = security8Policy;
                    this.bcfksKeystore = reference = bcfksKeystore;
                }

                public Object doCall(Object it) {
                    NamedDomainObjectContainer testClusters = (NamedDomainObjectContainer)ScriptBytecodeAdapter.asType((Object)((Project)this.project.get()).getExtensions().findByName(TestClustersPlugin.EXTENSION_NAME), NamedDomainObjectContainer.class);
                    if (testClusters != null) {
                        public final class _closure29
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference project;
                            private /* synthetic */ Reference securityProperties;
                            private /* synthetic */ Reference securityPolicy;
                            private /* synthetic */ Reference security8Properties;
                            private /* synthetic */ Reference security8Policy;
                            private /* synthetic */ Reference bcfksKeystore;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure29(Object _outerInstance, Object _thisObject, Reference project, Reference securityProperties, Reference securityPolicy, Reference security8Properties, Reference security8Policy, Reference bcfksKeystore) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                this.project = reference6 = project;
                                this.securityProperties = reference5 = securityProperties;
                                this.securityPolicy = reference4 = securityPolicy;
                                this.security8Properties = reference3 = security8Properties;
                                this.security8Policy = reference2 = security8Policy;
                                this.bcfksKeystore = reference = bcfksKeystore;
                            }

                            public Object doCall(ElasticsearchCluster cluster) {
                                cluster.setTestDistribution(TestDistribution.DEFAULT);
                                File dep = null;
                                Iterator iterator = ((Project)this.project.get()).getConfigurations().getByName("extraJars").getFiles().iterator();
                                while (iterator.hasNext()) {
                                    dep = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                                    cluster.extraJarFile(dep);
                                }
                                if (ScriptBytecodeAdapter.compareGreaterThan((Object)BuildParams.getRuntimeJavaVersion(), (Object)JavaVersion.VERSION_1_8)) {
                                    cluster.extraConfigFile("fips_java.security", (File)ScriptBytecodeAdapter.castToType((Object)this.securityProperties.get(), File.class));
                                    cluster.extraConfigFile("fips_java.policy", (File)ScriptBytecodeAdapter.castToType((Object)this.securityPolicy.get(), File.class));
                                } else {
                                    cluster.extraConfigFile("fips_java.security", (File)ScriptBytecodeAdapter.castToType((Object)this.security8Properties.get(), File.class));
                                    cluster.extraConfigFile("fips_java.policy", (File)ScriptBytecodeAdapter.castToType((Object)this.security8Policy.get(), File.class));
                                }
                                cluster.extraConfigFile("cacerts.bcfks", (File)ScriptBytecodeAdapter.castToType((Object)this.bcfksKeystore.get(), File.class));
                                cluster.systemProperty("java.security.properties", "=${ES_PATH_CONF}/fips_java.security");
                                cluster.systemProperty("java.security.policy", "=${ES_PATH_CONF}/fips_java.policy");
                                cluster.systemProperty("javax.net.ssl.trustStore", "${ES_PATH_CONF}/cacerts.bcfks");
                                cluster.systemProperty("javax.net.ssl.trustStorePassword", "password");
                                cluster.systemProperty("javax.net.ssl.keyStorePassword", "password");
                                cluster.systemProperty("javax.net.ssl.keyStoreType", "BCFKS");
                                cluster.setting("xpack.security.ssl.diagnose.trust", "false");
                                return null;
                            }

                            public Object call(ElasticsearchCluster cluster) {
                                return this.doCall(cluster);
                            }

                            @Generated
                            public Project getProject() {
                                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                            }

                            @Generated
                            public File getSecurityProperties() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.securityProperties.get(), File.class);
                            }

                            @Generated
                            public File getSecurityPolicy() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.securityPolicy.get(), File.class);
                            }

                            @Generated
                            public File getSecurity8Properties() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.security8Properties.get(), File.class);
                            }

                            @Generated
                            public File getSecurity8Policy() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.security8Policy.get(), File.class);
                            }

                            @Generated
                            public File getBcfksKeystore() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.bcfksKeystore.get(), File.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure29.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        testClusters.all((Closure)new _closure29((Object)this, this.getThisObject(), this.project, this.securityProperties, this.securityPolicy, this.security8Properties, this.security8Policy, this.bcfksKeystore));
                        return null;
                    }
                    return null;
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                @Generated
                public File getSecurityProperties() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.securityProperties.get(), File.class);
                }

                @Generated
                public File getSecurityPolicy() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.securityPolicy.get(), File.class);
                }

                @Generated
                public File getSecurity8Properties() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.security8Properties.get(), File.class);
                }

                @Generated
                public File getSecurity8Policy() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.security8Policy.get(), File.class);
                }

                @Generated
                public File getBcfksKeystore() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.bcfksKeystore.get(), File.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _configureFips140_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Project)project2.get()).getPluginManager().withPlugin("elasticsearch.testclusters", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureFips140_closure2(BuildPlugin.class, BuildPlugin.class, project2, securityProperties, securityPolicy, security8Properties, security8Policy, bcfksKeystore)), Action.class));
            public final class _configureFips140_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference buildResources;
                private /* synthetic */ Reference securityProperties;
                private /* synthetic */ Reference securityPolicy;
                private /* synthetic */ Reference security8Properties;
                private /* synthetic */ Reference security8Policy;
                private /* synthetic */ Reference bcfksKeystore;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _configureFips140_closure3(Object _outerInstance, Object _thisObject, Reference buildResources, Reference securityProperties, Reference securityPolicy, Reference security8Properties, Reference security8Policy, Reference bcfksKeystore) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    this.buildResources = reference6 = buildResources;
                    this.securityProperties = reference5 = securityProperties;
                    this.securityPolicy = reference4 = securityPolicy;
                    this.security8Properties = reference3 = security8Properties;
                    this.security8Policy = reference2 = security8Policy;
                    this.bcfksKeystore = reference = bcfksKeystore;
                }

                public Object doCall(Test task) {
                    task.dependsOn(new Object[]{this.buildResources.get()});
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)BuildParams.getRuntimeJavaVersion(), (Object)JavaVersion.VERSION_1_8)) {
                        task.systemProperty("java.security.properties", (Object)String.format(Locale.ROOT, "=%s", ((File)this.securityProperties.get()).toString()));
                        task.systemProperty("java.security.policy", (Object)String.format(Locale.ROOT, "=%s", ((File)this.securityPolicy.get()).toString()));
                    } else {
                        task.systemProperty("java.security.properties", (Object)String.format(Locale.ROOT, "=%s", ((File)this.security8Properties.get()).toString()));
                        task.systemProperty("java.security.policy", (Object)String.format(Locale.ROOT, "=%s", ((File)this.security8Policy.get()).toString()));
                    }
                    task.systemProperty("javax.net.ssl.trustStorePassword", (Object)"password");
                    task.systemProperty("javax.net.ssl.keyStorePassword", (Object)"password");
                    task.systemProperty("javax.net.ssl.trustStoreType", (Object)"BCFKS");
                    return task.systemProperty("javax.net.ssl.trustStore", (Object)((File)this.bcfksKeystore.get()).toString());
                }

                public Object call(Test task) {
                    return this.doCall(task);
                }

                @Generated
                public ExportElasticsearchBuildResourcesTask getBuildResources() {
                    return (ExportElasticsearchBuildResourcesTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.buildResources.get(), ExportElasticsearchBuildResourcesTask.class));
                }

                @Generated
                public File getSecurityProperties() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.securityProperties.get(), File.class);
                }

                @Generated
                public File getSecurityPolicy() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.securityPolicy.get(), File.class);
                }

                @Generated
                public File getSecurity8Properties() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.security8Properties.get(), File.class);
                }

                @Generated
                public File getSecurity8Policy() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.security8Policy.get(), File.class);
                }

                @Generated
                public File getBcfksKeystore() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.bcfksKeystore.get(), File.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _configureFips140_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Project)project2.get()).getTasks().withType(Test.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureFips140_closure3(BuildPlugin.class, BuildPlugin.class, buildResources, securityProperties, securityPolicy, security8Properties, security8Policy, bcfksKeystore)), Action.class));
        }
    }

    public static void configureConfigurations(Project project) {
        project.getConfigurations().getByName(JavaPlugin.TEST_COMPILE_CONFIGURATION_NAME).extendsFrom(new Configuration[]{project.getConfigurations().getByName(JavaPlugin.COMPILE_ONLY_CONFIGURATION_NAME)});
        if (project.getPath().startsWith(":test:fixtures") || ScriptBytecodeAdapter.compareEqual((Object)project.getPath(), (Object)":build-tools")) {
            return;
        }
        public final class _configureConfigurations_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureConfigurations_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Configuration configuration) {
                if (configuration.getName().endsWith("Fixture")) {
                    return null;
                }
                public final class _closure30
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure30(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((ResolutionStrategy)this.getDelegate()).failOnVersionConflict();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return configuration.resolutionStrategy((Closure)new _closure30((Object)this, this.getThisObject()));
            }

            public Object call(Configuration configuration) {
                return this.doCall(configuration);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureConfigurations_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        project.getConfigurations().all((Closure)new _configureConfigurations_closure4(BuildPlugin.class, BuildPlugin.class));
        public final class _configureConfigurations_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureConfigurations_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Dependency dep) {
                if (dep instanceof ModuleDependency && !(dep instanceof ProjectDependency) && ScriptBytecodeAdapter.compareEqual((Object)dep.getGroup().startsWith("org.elasticsearch"), (Object)false)) {
                    boolean bl = false;
                    ((ModuleDependency)ScriptBytecodeAdapter.castToType((Object)dep, ModuleDependency.class)).setTransitive(bl);
                    return false;
                }
                return null;
            }

            public Object call(Dependency dep) {
                return this.doCall(dep);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureConfigurations_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        _configureConfigurations_closure5 disableTransitiveDeps = new _configureConfigurations_closure5(BuildPlugin.class, BuildPlugin.class);
        project.getConfigurations().getByName(JavaPlugin.COMPILE_CONFIGURATION_NAME).getDependencies().all((Closure)disableTransitiveDeps);
        project.getConfigurations().getByName(JavaPlugin.TEST_COMPILE_CONFIGURATION_NAME).getDependencies().all((Closure)disableTransitiveDeps);
        project.getConfigurations().getByName(JavaPlugin.COMPILE_ONLY_CONFIGURATION_NAME).getDependencies().all((Closure)disableTransitiveDeps);
    }

    public static void configureRepositories(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _configureRepositories_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureRepositories_closure6(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object repository) {
                if (repository instanceof MavenArtifactRepository) {
                    Reference maven = new Reference((Object)((MavenArtifactRepository)ScriptBytecodeAdapter.castToType((Object)repository, MavenArtifactRepository.class)));
                    BuildPlugin.assertRepositoryURIIsSecure(((MavenArtifactRepository)maven.get()).getName(), ((Project)this.project.get()).getPath(), ((MavenArtifactRepository)maven.get()).getUrl());
                    public final class _closure31
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference maven;
                        private /* synthetic */ Reference project;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure31(Object _outerInstance, Object _thisObject, Reference maven, Reference project) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.maven = reference2 = maven;
                            this.project = reference = project;
                        }

                        public Object doCall(Object uri) {
                            BuildPlugin.assertRepositoryURIIsSecure(((MavenArtifactRepository)this.maven.get()).getName(), ((Project)this.project.get()).getPath(), (URI)ScriptBytecodeAdapter.castToType((Object)uri, URI.class));
                            return null;
                        }

                        @Generated
                        public MavenArtifactRepository getMaven() {
                            return (MavenArtifactRepository)ScriptBytecodeAdapter.castToType((Object)this.maven.get(), MavenArtifactRepository.class);
                        }

                        @Generated
                        public Project getProject() {
                            return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure31.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.each((Set)((MavenArtifactRepository)repository).getArtifactUrls(), (Closure)new _closure31((Object)this, this.getThisObject(), maven, this.project));
                }
                if (repository instanceof IvyArtifactRepository) {
                    IvyArtifactRepository ivy = (IvyArtifactRepository)ScriptBytecodeAdapter.castToType((Object)repository, IvyArtifactRepository.class);
                    BuildPlugin.assertRepositoryURIIsSecure(ivy.getName(), ((Project)this.project.get()).getPath(), ivy.getUrl());
                    return null;
                }
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureRepositories_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getRepositories().all((Closure)new _configureRepositories_closure6(BuildPlugin.class, BuildPlugin.class, project2));
        RepositoryHandler repos = ((Project)project2.get()).getRepositories();
        if (System.getProperty("repos.mavenLocal") != null) {
            repos.mavenLocal();
        }
        repos.jcenter();
        public final class _configureRepositories_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureRepositories_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(IvyArtifactRepository repo) {
                String string = "elasticsearch";
                repo.setName(string);
                String string2 = "https://artifacts.elastic.co/downloads";
                repo.setUrl((Object)string2);
                public final class _closure32
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure32(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(IvyPatternRepositoryLayout layout) {
                        layout.artifact("elasticsearch/[module]-[revision](-[classifier]).[ext]");
                        return null;
                    }

                    public Object call(IvyPatternRepositoryLayout layout) {
                        return this.doCall(layout);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                repo.patternLayout((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure32((Object)this, this.getThisObject())), Action.class));
                public final class _closure33
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure33(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(HttpHeaderCredentials creds) {
                        String string = "X-Elastic-No-KPI";
                        creds.setName(string);
                        String string2 = "1";
                        creds.setValue(string2);
                        return "1";
                    }

                    public Object call(HttpHeaderCredentials creds) {
                        return this.doCall(creds);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure33.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                repo.credentials(HttpHeaderCredentials.class, (Action)ScriptBytecodeAdapter.asType((Object)((Object)new _closure33((Object)this, this.getThisObject())), Action.class));
                return repo.getAuthentication().create("header", HttpHeaderAuthentication.class);
            }

            public Object call(IvyArtifactRepository repo) {
                return this.doCall(repo);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureRepositories_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        repos.ivy((Closure)new _configureRepositories_closure7(BuildPlugin.class, BuildPlugin.class));
        public final class _configureRepositories_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureRepositories_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(MavenArtifactRepository repo) {
                String string = "elastic";
                repo.setName(string);
                String string2 = "https://artifacts.elastic.co/maven";
                repo.setUrl((Object)string2);
                return "https://artifacts.elastic.co/maven";
            }

            public Object call(MavenArtifactRepository repo) {
                return this.doCall(repo);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureRepositories_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        repos.maven((Closure)new _configureRepositories_closure8(BuildPlugin.class, BuildPlugin.class));
        String luceneVersion = VersionProperties.getLucene();
        if (luceneVersion.contains("-snapshot")) {
            List matches = (List)ScriptBytecodeAdapter.asType((Object)StringGroovyMethods.getAt((Matcher)((Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)luceneVersion, (Object)"\\w+-snapshot-([a-z0-9]+)"), Matcher.class)), (int)0), List.class);
            Reference revision = new Reference((Object)ShortTypeHandling.castToString(matches.get(1)));
            public final class _configureRepositories_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference revision;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _configureRepositories_closure9(Object _outerInstance, Object _thisObject, Reference revision) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.revision = reference = revision;
                }

                public Object doCall(MavenArtifactRepository repo) {
                    String string = "lucene-snapshots";
                    repo.setName(string);
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{this.revision.get()}, new String[]{"https://s3.amazonaws.com/download.elasticsearch.org/lucenesnapshots/", ""});
                    repo.setUrl((Object)gStringImpl);
                    return gStringImpl;
                }

                public Object call(MavenArtifactRepository repo) {
                    return this.doCall(repo);
                }

                @Generated
                public String getRevision() {
                    return ShortTypeHandling.castToString((Object)this.revision.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _configureRepositories_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Reference luceneRepo = new Reference((Object)repos.maven((Closure)new _configureRepositories_closure9(BuildPlugin.class, BuildPlugin.class, revision)));
            public final class _configureRepositories_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference revision;
                private /* synthetic */ Reference luceneRepo;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _configureRepositories_closure10(Object _outerInstance, Object _thisObject, Reference revision, Reference luceneRepo) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.revision = reference2 = revision;
                    this.luceneRepo = reference = luceneRepo;
                }

                public Object doCall(ExclusiveContentRepository exclusiveRepo) {
                    public final class _closure34
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference revision;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure34(Object _outerInstance, Object _thisObject, Reference revision) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.revision = reference = revision;
                        }

                        public Object doCall(Object it) {
                            ((InclusiveRepositoryContentDescriptor)it).includeVersionByRegex("org\\.apache\\.lucene", ".*", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.revision.get()}, new String[]{".*-snapshot-", ""})));
                            return null;
                        }

                        @Generated
                        public String getRevision() {
                            return ShortTypeHandling.castToString((Object)this.revision.get());
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure34.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    exclusiveRepo.filter((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure34((Object)this, this.getThisObject(), this.revision)), Action.class));
                    return exclusiveRepo.forRepositories(new ArtifactRepository[]{(ArtifactRepository)ScriptBytecodeAdapter.castToType((Object)this.luceneRepo.get(), ArtifactRepository.class)});
                }

                public Object call(ExclusiveContentRepository exclusiveRepo) {
                    return this.doCall(exclusiveRepo);
                }

                @Generated
                public String getRevision() {
                    return ShortTypeHandling.castToString((Object)this.revision.get());
                }

                @Generated
                public MavenArtifactRepository getLuceneRepo() {
                    return (MavenArtifactRepository)ScriptBytecodeAdapter.castToType((Object)this.luceneRepo.get(), MavenArtifactRepository.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _configureRepositories_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            repos.exclusiveContent((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureRepositories_closure10(BuildPlugin.class, BuildPlugin.class, revision, luceneRepo)), Action.class));
        }
    }

    public static void assertRepositoryURIIsSecure(String repositoryName, String projectPath, URI uri) {
        if (uri != null && ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"file", "https", "s3"}).contains(uri.getScheme()), (Object)false)) {
            String message = String.format(Locale.ROOT, "repository [%s] on project with path [%s] is not using a secure protocol for artifacts on [%s]", repositoryName, projectPath, uri.toURL());
            throw (Throwable)new GradleException(message);
        }
    }

    public static void configurePomGeneration(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _configurePomGeneration_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configurePomGeneration_closure11(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure35(Object _outerInstance, Object _thisObject, Reference project) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.project = reference = project;
                    }

                    public Object doCall(Object it) {
                        PublishingExtension publishing = (PublishingExtension)ScriptBytecodeAdapter.castToType((Object)((Project)this.project.get()).getExtensions().getByType(PublishingExtension.class), PublishingExtension.class);
                        public final class _closure36
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference project;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure36(Object _outerInstance, Object _thisObject, Reference project) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.project = reference = project;
                            }

                            public Object doCall(MavenPublication publication) {
                                String string = ((BasePluginConvention)((Project)this.project.get()).getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName();
                                publication.setArtifactId(string);
                                return string;
                            }

                            public Object call(MavenPublication publication) {
                                return this.doCall(publication);
                            }

                            @Generated
                            public Project getProject() {
                                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure36.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return publishing.getPublications().withType(MavenPublication.class, (Closure)new _closure36((Object)this, this.getThisObject(), this.project));
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getPluginManager().withPlugin("maven-publish", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure35((Object)this, this.getThisObject(), this.project)), Action.class));
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configurePomGeneration_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).afterEvaluate((Closure)new _configurePomGeneration_closure11(BuildPlugin.class, BuildPlugin.class, project2));
        public final class _configurePomGeneration_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configurePomGeneration_closure12(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                public final class _closure37
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure37(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Task task) {
                        return task.dependsOn(new Object[]{"generatePomFileForNebulaPublication"});
                    }

                    public Object call(Task task) {
                        return this.doCall(task);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure37.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Reference generatePomTask = new Reference((Object)((Project)this.project.get()).getTasks().register("generatePom", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure37((Object)this, this.getThisObject())), Action.class)));
                public final class _closure38
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference generatePomTask;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure38(Object _outerInstance, Object _thisObject, Reference generatePomTask) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.generatePomTask = reference = generatePomTask;
                    }

                    public Object doCall(Object assemble) {
                        return ((Task)assemble).dependsOn(new Object[]{this.generatePomTask.get()});
                    }

                    @Generated
                    public TaskProvider getGeneratePomTask() {
                        return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.generatePomTask.get(), TaskProvider.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure38.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                GradleUtils.maybeConfigure(((Project)this.project.get()).getTasks(), LifecycleBasePlugin.ASSEMBLE_TASK_NAME, (Action<? super Task>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure38((Object)this, this.getThisObject(), generatePomTask)), Action.class)));
                public final class _closure39
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure39(Object _outerInstance, Object _thisObject, Reference project) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.project = reference = project;
                    }

                    public Object doCall(GenerateMavenPom pomTask) {
                        public final class _closure41
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference project;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure41(Object _outerInstance, Object _thisObject, Reference project) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.project = reference = project;
                            }

                            public Object doCall(Object it) {
                                return new GStringImpl(new Object[]{((Project)this.project.get()).getBuildDir(), ((BasePluginConvention)((Project)this.project.get()).getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName(), ((Project)this.project.get()).getVersion()}, new String[]{"", "/distributions/", "-", ".pom"});
                            }

                            @Generated
                            public Project getProject() {
                                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure41.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        _closure41 _closure412 = new _closure41((Object)this, this.getThisObject(), this.project);
                        pomTask.setDestination((Object)_closure412);
                        return _closure412;
                    }

                    public Object call(GenerateMavenPom pomTask) {
                        return this.doCall(pomTask);
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure39.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getTasks().withType(GenerateMavenPom.class).configureEach((Action)ScriptBytecodeAdapter.asType((Object)((Object)new _closure39((Object)this, this.getThisObject(), this.project)), Action.class));
                Reference publishing = new Reference((Object)((PublishingExtension)ScriptBytecodeAdapter.castToType((Object)((Project)this.project.get()).getExtensions().getByType(PublishingExtension.class), PublishingExtension.class)));
                public final class _closure40
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference publishing;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference generatePomTask;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure40(Object _outerInstance, Object _thisObject, Reference publishing, Reference project, Reference generatePomTask) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.publishing = reference3 = publishing;
                        this.project = reference2 = project;
                        this.generatePomTask = reference = generatePomTask;
                    }

                    public Object doCall(Object it) {
                        MavenPublication publication = (MavenPublication)ScriptBytecodeAdapter.castToType((Object)((PublishingExtension)this.publishing.get()).getPublications().maybeCreate("shadow", MavenPublication.class), MavenPublication.class);
                        ShadowExtension shadow = (ShadowExtension)ScriptBytecodeAdapter.castToType((Object)((Project)this.project.get()).getExtensions().getByType(ShadowExtension.class), ShadowExtension.class);
                        shadow.component(publication);
                        publication.getPom().withXml((Action)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getMethodPointer(BuildPlugin.class, (String)"addScmInfo"), Action.class));
                        public final class _closure42
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference project;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure42(Object _outerInstance, Object _thisObject, Reference project) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.project = reference = project;
                            }

                            public Object doCall(Object xml) {
                                Node root = ((XmlProvider)xml).asNode();
                                root.appendNode((Object)"name", (Object)((Project)this.project.get()).getName());
                                root.appendNode((Object)"description", (Object)((Project)this.project.get()).getDescription());
                                Reference dependenciesNode = new Reference((Object)((Node)ScriptBytecodeAdapter.asType((Object)((NodeList)ScriptBytecodeAdapter.asType((Object)root.get("dependencies"), NodeList.class)).get(0), Node.class)));
                                public final class _closure44
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference dependenciesNode;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure44(Object _outerInstance, Object _thisObject, Reference dependenciesNode) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        this.dependenciesNode = reference = dependenciesNode;
                                    }

                                    public Object doCall(Object dependency) {
                                        if (dependency instanceof ProjectDependency) {
                                            Node dependencyNode = ((Node)this.dependenciesNode.get()).appendNode((Object)"dependency");
                                            dependencyNode.appendNode((Object)"groupId", (Object)((Dependency)dependency).getGroup());
                                            dependencyNode.appendNode((Object)"artifactId", (Object)((BasePluginConvention)((ProjectDependency)dependency).getDependencyProject().getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName());
                                            dependencyNode.appendNode((Object)"version", (Object)((Dependency)dependency).getVersion());
                                            return dependencyNode.appendNode((Object)"scope", (Object)"compile");
                                        }
                                        return null;
                                    }

                                    @Generated
                                    public Node getDependenciesNode() {
                                        return (Node)ScriptBytecodeAdapter.castToType((Object)this.dependenciesNode.get(), Node.class);
                                    }

                                    public Object call(Object args) {
                                        return this.doCall(args);
                                    }

                                    public Object call() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure44.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }
                                }
                                return DefaultGroovyMethods.each((Set)((Project)this.project.get()).getConfigurations().getByName(ShadowBasePlugin.getCONFIGURATION_NAME()).getAllDependencies(), (Closure)new _closure44((Object)this, this.getThisObject(), dependenciesNode));
                            }

                            @Generated
                            public Project getProject() {
                                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure42.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        publication.getPom().withXml((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure42((Object)this, this.getThisObject(), this.project)), Action.class));
                        public final class _closure43
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure43(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Task t) {
                                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"generatePomFileForShadowPublication"});
                                t.setDependsOn((Iterable)list);
                                return list;
                            }

                            public Object call(Task t) {
                                return this.doCall(t);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure43.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        ((TaskProvider)this.generatePomTask.get()).configure((Action)ScriptBytecodeAdapter.asType((Object)((Object)new _closure43((Object)this, this.getThisObject())), Action.class));
                        return null;
                    }

                    @Generated
                    public PublishingExtension getPublishing() {
                        return (PublishingExtension)ScriptBytecodeAdapter.castToType((Object)this.publishing.get(), PublishingExtension.class);
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    @Generated
                    public TaskProvider getGeneratePomTask() {
                        return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.generatePomTask.get(), TaskProvider.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure40.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getPluginManager().withPlugin("com.github.johnrengelman.shadow", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure40((Object)this, this.getThisObject(), publishing, this.project, generatePomTask)), Action.class));
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configurePomGeneration_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getPlugins().withType(MavenPublishPlugin.class).whenPluginAdded((Closure)new _configurePomGeneration_closure12(BuildPlugin.class, BuildPlugin.class, project2));
        public final class _configurePomGeneration_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configurePomGeneration_closure13(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                PublishingExtension publishing = (PublishingExtension)ScriptBytecodeAdapter.castToType((Object)((Project)this.project.get()).getExtensions().getByType(PublishingExtension.class), PublishingExtension.class);
                MavenPublication nebulaPublication = (MavenPublication)ScriptBytecodeAdapter.castToType((Object)publishing.getPublications().getByName("nebula"), MavenPublication.class);
                nebulaPublication.getPom().withXml((Action)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getMethodPointer(BuildPlugin.class, (String)"addScmInfo"), Action.class));
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configurePomGeneration_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getPluginManager().withPlugin("nebula.maven-base-publish", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configurePomGeneration_closure13(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
    }

    private static void addScmInfo(XmlProvider xml) {
        Node root = xml.asNode();
        root.appendNode((Object)"url", (Object)PluginBuildPlugin.urlFromOrigin(BuildParams.getGitOrigin()));
        Node scmNode = root.appendNode((Object)"scm");
        scmNode.appendNode((Object)"url", (Object)BuildParams.getGitOrigin());
    }

    public static void configureJavadoc(Project project) {
        Reference project2 = new Reference((Object)project);
        Reference classes = new Reference(new ArrayList());
        public final class _configureJavadoc_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference classes;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJavadoc_closure14(Object _outerInstance, Object _thisObject, Reference classes) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.classes = reference = classes;
            }

            public Object doCall(JavaCompile javaCompile) {
                return ((ArrayList)this.classes.get()).add(javaCompile.getDestinationDir());
            }

            public Object call(JavaCompile javaCompile) {
                return this.doCall(javaCompile);
            }

            @Generated
            public List getClasses() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.classes.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJavadoc_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getTasks().withType(JavaCompile.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJavadoc_closure14(BuildPlugin.class, BuildPlugin.class, classes)), Action.class));
        public final class _configureJavadoc_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference classes;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJavadoc_closure15(Object _outerInstance, Object _thisObject, Reference classes) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.classes = reference = classes;
            }

            public Object doCall(Javadoc javadoc) {
                if (ScriptBytecodeAdapter.compareEqual((Object)Files.isSameFile(BuildParams.getCompilerJavaHome().toPath(), Jvm.current().getJavaHome().toPath()), (Object)false)) {
                    File file = new File(BuildParams.getCompilerJavaHome(), "bin/javadoc");
                    javadoc.setExecutable(ShortTypeHandling.castToString((Object)file));
                }
                public final class _closure45
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference classes;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure45(Object _outerInstance, Object _thisObject, Reference classes) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.classes = reference = classes;
                    }

                    public Object doCall(Object f) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((ArrayList)this.classes.get()).contains(f), (Object)false);
                    }

                    @Generated
                    public List getClasses() {
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.classes.get(), List.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure45.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                FileCollection fileCollection = javadoc.getClasspath().filter((Closure)new _closure45((Object)this, this.getThisObject(), this.classes));
                javadoc.setClasspath(fileCollection);
                return ((CoreJavadocOptions)ScriptBytecodeAdapter.asType((Object)javadoc.getOptions(), CoreJavadocOptions.class)).addBooleanOption("html5", true);
            }

            public Object call(Javadoc javadoc) {
                return this.doCall(javadoc);
            }

            @Generated
            public List getClasses() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.classes.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJavadoc_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getTasks().withType(Javadoc.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJavadoc_closure15(BuildPlugin.class, BuildPlugin.class, classes)), Action.class));
        public final class _configureJavadoc_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJavadoc_closure16(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                public final class _closure46
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure46(Object _outerInstance, Object _thisObject, Reference project) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.project = reference = project;
                    }

                    public Object doCall(Object it) {
                        return ((Task)it).dependsOn(new Object[]{((Project)this.project.get()).getTasks().withType(Javadoc.class)});
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure46.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getTasks().named(LifecycleBasePlugin.CHECK_TASK_NAME).configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure46((Object)this, this.getThisObject(), this.project)), Action.class));
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJavadoc_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getPluginManager().withPlugin("lifecycle-base", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJavadoc_closure16(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
        BuildPlugin.configureJavadocJar((Project)project2.get());
    }

    public static void configureJavadocJar(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _configureJavadocJar_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJavadocJar_closure17(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Jar jar) {
                jar.getArchiveClassifier().set((Object)"javadoc");
                String string = "build";
                jar.setGroup(string);
                String string2 = "Assembles a jar containing javadocs.";
                jar.setDescription(string2);
                return jar.from(new Object[]{((Project)this.project.get()).getTasks().named(JavaPlugin.JAVADOC_TASK_NAME)});
            }

            public Object call(Jar jar) {
                return this.doCall(jar);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJavadocJar_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference javadocJarTask = new Reference((Object)((Project)project2.get()).getTasks().register("javadocJar", Jar.class, (Action)ScriptBytecodeAdapter.asType((Object)((Object)new _configureJavadocJar_closure17(BuildPlugin.class, BuildPlugin.class, project2)), Action.class)));
        public final class _configureJavadocJar_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference javadocJarTask;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJavadocJar_closure18(Object _outerInstance, Object _thisObject, Reference javadocJarTask) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.javadocJarTask = reference = javadocJarTask;
            }

            public Object doCall(Task t) {
                return t.dependsOn(new Object[]{this.javadocJarTask.get()});
            }

            public Object call(Task t) {
                return this.doCall(t);
            }

            @Generated
            public TaskProvider getJavadocJarTask() {
                return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.javadocJarTask.get(), TaskProvider.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJavadocJar_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GradleUtils.maybeConfigure(((Project)project2.get()).getTasks(), BasePlugin.ASSEMBLE_TASK_NAME, (Action<? super Task>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJavadocJar_closure18(BuildPlugin.class, BuildPlugin.class, javadocJarTask)), Action.class)));
    }

    public static void configureSourcesJar(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _configureSourcesJar_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureSourcesJar_closure19(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Jar jar) {
                jar.getArchiveClassifier().set((Object)"sources");
                String string = "build";
                jar.setGroup(string);
                String string2 = "Assembles a jar containing source files.";
                jar.setDescription(string2);
                return jar.from(new Object[]{((SourceSet)((SourceSetContainer)((Project)this.project.get()).getExtensions().getByType(SourceSetContainer.class)).getByName(SourceSet.MAIN_SOURCE_SET_NAME)).getAllSource()});
            }

            public Object call(Jar jar) {
                return this.doCall(jar);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureSourcesJar_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference sourcesJarTask = new Reference((Object)((Project)project2.get()).getTasks().register("sourcesJar", Jar.class, (Action)ScriptBytecodeAdapter.asType((Object)((Object)new _configureSourcesJar_closure19(BuildPlugin.class, BuildPlugin.class, project2)), Action.class)));
        public final class _configureSourcesJar_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sourcesJarTask;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureSourcesJar_closure20(Object _outerInstance, Object _thisObject, Reference sourcesJarTask) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sourcesJarTask = reference = sourcesJarTask;
            }

            public Object doCall(Task t) {
                return t.dependsOn(new Object[]{this.sourcesJarTask.get()});
            }

            public Object call(Task t) {
                return this.doCall(t);
            }

            @Generated
            public TaskProvider getSourcesJarTask() {
                return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.sourcesJarTask.get(), TaskProvider.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureSourcesJar_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GradleUtils.maybeConfigure(((Project)project2.get()).getTasks(), BasePlugin.ASSEMBLE_TASK_NAME, (Action<? super Task>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureSourcesJar_closure20(BuildPlugin.class, BuildPlugin.class, sourcesJarTask)), Action.class)));
    }

    public static void configureJars(Project project) {
        Reference project2 = new Reference((Object)project);
        Reference ext = new Reference((Object)((ExtraPropertiesExtension)ScriptBytecodeAdapter.castToType((Object)((Project)project2.get()).getExtensions().getByType(ExtraPropertiesExtension.class), ExtraPropertiesExtension.class)));
        ((ExtraPropertiesExtension)ext.get()).set("licenseFile", null);
        ((ExtraPropertiesExtension)ext.get()).set("noticeFile", null);
        public final class _configureJars_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJars_closure21(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Jar jarTask) {
                Reference jarTask2 = new Reference((Object)jarTask);
                ((Jar)jarTask2.get()).getDestinationDirectory().set(new File(((Project)this.project.get()).getBuildDir(), "distributions"));
                public final class _closure47
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference jarTask;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure47(Object _outerInstance, Object _thisObject, Reference jarTask) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.jarTask = reference = jarTask;
                    }

                    public Object doCall(Object it) {
                        JavaVersion compilerJavaVersion = BuildParams.getCompilerJavaVersion();
                        return ((Jar)this.jarTask.get()).getManifest().attributes(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Build-Date", BuildParams.getBuildDate(), "Build-Java-Version", BuildParams.getCompilerJavaVersion()}));
                    }

                    @Generated
                    public Jar getJarTask() {
                        return (Jar)ScriptBytecodeAdapter.castToType((Object)this.jarTask.get(), Jar.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure47.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return ((Jar)jarTask2.get()).doFirst((Closure)new _closure47((Object)this, this.getThisObject(), jarTask2));
            }

            public Object call(Jar jarTask) {
                Reference jarTask2 = new Reference((Object)jarTask);
                return this.doCall((Jar)jarTask2.get());
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJars_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getTasks().withType(Jar.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJars_closure21(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
        public final class _configureJars_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference ext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJars_closure22(Object _outerInstance, Object _thisObject, Reference project, Reference ext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.project = reference2 = project;
                this.ext = reference = ext;
            }

            public Object doCall(Object it) {
                public final class _closure48
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ext;
                    private /* synthetic */ Reference project;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure48(Object _outerInstance, Object _thisObject, Reference ext, Reference project) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.ext = reference2 = ext;
                        this.project = reference = project;
                    }

                    public Object doCall(Jar jarTask) {
                        if (ScriptBytecodeAdapter.compareEqual((Object)((ExtraPropertiesExtension)this.ext.get()).has("licenseFile"), (Object)false) || ((ExtraPropertiesExtension)this.ext.get()).get("licenseFile") == null || ScriptBytecodeAdapter.compareEqual((Object)((ExtraPropertiesExtension)this.ext.get()).has("noticeFile"), (Object)false) || ((ExtraPropertiesExtension)this.ext.get()).get("noticeFile") == null) {
                            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Project)this.project.get()).getPath()}, new String[]{"Must specify license and notice file for project ", ""})));
                        }
                        Reference licenseFile = new Reference((Object)((File)ScriptBytecodeAdapter.asType((Object)((ExtraPropertiesExtension)this.ext.get()).get("licenseFile"), File.class)));
                        Reference noticeFile = new Reference((Object)((File)ScriptBytecodeAdapter.asType((Object)((ExtraPropertiesExtension)this.ext.get()).get("noticeFile"), File.class)));
                        public final class _closure49
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference licenseFile;
                            private /* synthetic */ Reference noticeFile;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure49(Object _outerInstance, Object _thisObject, Reference licenseFile, Reference noticeFile) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.licenseFile = reference2 = licenseFile;
                                this.noticeFile = reference = noticeFile;
                            }

                            public Object doCall(CopySpec spec) {
                                public final class _closure50
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference licenseFile;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure50(Object _outerInstance, Object _thisObject, Reference licenseFile) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        this.licenseFile = reference = licenseFile;
                                    }

                                    public Object doCall(CopySpec from) {
                                        from.include(new String[]{((File)this.licenseFile.get()).getName()});
                                        public final class _closure52
                                        extends Closure
                                        implements GeneratedClosure {
                                            private static /* synthetic */ ClassInfo $staticClassInfo;
                                            public static transient /* synthetic */ boolean __$stMC;

                                            public _closure52(Object _outerInstance, Object _thisObject) {
                                                super(_outerInstance, _thisObject);
                                            }

                                            public Object doCall(Object it) {
                                                return "LICENSE.txt";
                                            }

                                            public Object call(Object args) {
                                                return this.doCall(args);
                                            }

                                            public Object call() {
                                                return this.doCall(null);
                                            }

                                            @Generated
                                            public Object doCall() {
                                                return this.doCall(null);
                                            }

                                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                if (((Object)((Object)this)).getClass() != _closure52.class) {
                                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                }
                                                ClassInfo classInfo = $staticClassInfo;
                                                if (classInfo == null) {
                                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                }
                                                return classInfo.getMetaClass();
                                            }
                                        }
                                        return from.rename((Closure)new _closure52((Object)this, this.getThisObject()));
                                    }

                                    public Object call(CopySpec from) {
                                        return this.doCall(from);
                                    }

                                    @Generated
                                    public File getLicenseFile() {
                                        return (File)ScriptBytecodeAdapter.castToType((Object)this.licenseFile.get(), File.class);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure50.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }
                                }
                                spec.from((Object)((File)this.licenseFile.get()).getParent(), (Closure)new _closure50((Object)this, this.getThisObject(), this.licenseFile));
                                public final class _closure51
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference noticeFile;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure51(Object _outerInstance, Object _thisObject, Reference noticeFile) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        this.noticeFile = reference = noticeFile;
                                    }

                                    public Object doCall(CopySpec from) {
                                        from.include(new String[]{((File)this.noticeFile.get()).getName()});
                                        public final class _closure53
                                        extends Closure
                                        implements GeneratedClosure {
                                            private static /* synthetic */ ClassInfo $staticClassInfo;
                                            public static transient /* synthetic */ boolean __$stMC;

                                            public _closure53(Object _outerInstance, Object _thisObject) {
                                                super(_outerInstance, _thisObject);
                                            }

                                            public Object doCall(Object it) {
                                                return "NOTICE.txt";
                                            }

                                            public Object call(Object args) {
                                                return this.doCall(args);
                                            }

                                            public Object call() {
                                                return this.doCall(null);
                                            }

                                            @Generated
                                            public Object doCall() {
                                                return this.doCall(null);
                                            }

                                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                if (((Object)((Object)this)).getClass() != _closure53.class) {
                                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                }
                                                ClassInfo classInfo = $staticClassInfo;
                                                if (classInfo == null) {
                                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                }
                                                return classInfo.getMetaClass();
                                            }
                                        }
                                        return from.rename((Closure)new _closure53((Object)this, this.getThisObject()));
                                    }

                                    public Object call(CopySpec from) {
                                        return this.doCall(from);
                                    }

                                    @Generated
                                    public File getNoticeFile() {
                                        return (File)ScriptBytecodeAdapter.castToType((Object)this.noticeFile.get(), File.class);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure51.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }
                                }
                                return spec.from((Object)((File)this.noticeFile.get()).getParent(), (Closure)new _closure51((Object)this, this.getThisObject(), this.noticeFile));
                            }

                            public Object call(CopySpec spec) {
                                return this.doCall(spec);
                            }

                            @Generated
                            public File getLicenseFile() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.licenseFile.get(), File.class);
                            }

                            @Generated
                            public File getNoticeFile() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.noticeFile.get(), File.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure49.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return jarTask.metaInf((Closure)new _closure49((Object)this, this.getThisObject(), licenseFile, noticeFile));
                    }

                    public Object call(Jar jarTask) {
                        return this.doCall(jarTask);
                    }

                    @Generated
                    public ExtraPropertiesExtension getExt() {
                        return (ExtraPropertiesExtension)ScriptBytecodeAdapter.castToType((Object)this.ext.get(), ExtraPropertiesExtension.class);
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure48.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getTasks().withType(Jar.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure48((Object)this, this.getThisObject(), this.ext, this.project)), Action.class));
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            @Generated
            public ExtraPropertiesExtension getExt() {
                return (ExtraPropertiesExtension)ScriptBytecodeAdapter.castToType((Object)this.ext.get(), ExtraPropertiesExtension.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJars_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).afterEvaluate((Closure)new _configureJars_closure22(BuildPlugin.class, BuildPlugin.class, project2, ext));
        public final class _configureJars_closure23
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJars_closure23(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                public final class _closure54
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure54(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(ShadowJar shadowJar) {
                        shadowJar.getArchiveClassifier().set(null);
                        return shadowJar.mergeServiceFiles();
                    }

                    public Object call(ShadowJar shadowJar) {
                        return this.doCall(shadowJar);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure54.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getTasks().getByName(ShadowJavaPlugin.getSHADOW_JAR_TASK_NAME()).configure((Closure)new _closure54((Object)this, this.getThisObject()));
                public final class _closure55
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure55(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Jar jar) {
                        jar.getArchiveClassifier().set((Object)"original");
                        return null;
                    }

                    public Object call(Jar jar) {
                        return this.doCall(jar);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure55.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getTasks().getByName(JavaPlugin.JAR_TASK_NAME).configure((Closure)new _closure55((Object)this, this.getThisObject()));
                public final class _closure56
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure56(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Task task) {
                        return task.dependsOn(new Object[]{"shadowJar"});
                    }

                    public Object call(Task task) {
                        return this.doCall(task);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure56.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)this.project.get()).getTasks().named(BasePlugin.ASSEMBLE_TASK_NAME).configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure56((Object)this, this.getThisObject())), Action.class));
                return null;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJars_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getPluginManager().withPlugin("com.github.johnrengelman.shadow", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJars_closure23(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
    }

    public static void configureJarManifest(Project project) {
        project.getPluginManager().apply("nebula.info-broker");
        project.getPluginManager().apply("nebula.info-basic");
        project.getPluginManager().apply("nebula.info-java");
        project.getPluginManager().apply("nebula.info-jar");
        public final class _configureJarManifest_closure24
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureJarManifest_closure24(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(InfoBrokerPlugin manifestPlugin) {
                public final class _closure57
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure57(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return BuildParams.getGitOrigin();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure57.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                manifestPlugin.add("Module-Origin", (Closure)new _closure57((Object)this, this.getThisObject()));
                public final class _closure58
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure58(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return BuildParams.getGitRevision();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure58.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                manifestPlugin.add("Change", (Closure)new _closure58((Object)this, this.getThisObject()));
                public final class _closure59
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure59(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return VersionProperties.getElasticsearch();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure59.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                manifestPlugin.add("X-Compile-Elasticsearch-Version", (Closure)new _closure59((Object)this, this.getThisObject()));
                public final class _closure60
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure60(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return VersionProperties.getLucene();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure60.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                manifestPlugin.add("X-Compile-Lucene-Version", (Closure)new _closure60((Object)this, this.getThisObject()));
                public final class _closure61
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure61(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return VersionProperties.isElasticsearchSnapshot();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure61.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return manifestPlugin.add("X-Compile-Elasticsearch-Snapshot", (Closure)new _closure61((Object)this, this.getThisObject()));
            }

            public Object call(InfoBrokerPlugin manifestPlugin) {
                return this.doCall(manifestPlugin);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureJarManifest_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        project.getPlugins().withId("nebula.info-broker", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configureJarManifest_closure24(BuildPlugin.class, BuildPlugin.class)), Action.class));
    }

    private static Object configurePrecommit(Project project) {
        Reference project2 = new Reference((Object)project);
        Reference precommit = new Reference((Object)PrecommitTasks.create((Project)project2.get(), true));
        public final class _configurePrecommit_closure25
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference precommit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configurePrecommit_closure25(Object _outerInstance, Object _thisObject, Reference precommit) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.precommit = reference = precommit;
            }

            public Object doCall(Object it) {
                return ((Task)it).dependsOn(new Object[]{this.precommit.get()});
            }

            @Generated
            public TaskProvider getPrecommit() {
                return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.precommit.get(), TaskProvider.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configurePrecommit_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getTasks().named(LifecycleBasePlugin.CHECK_TASK_NAME).configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configurePrecommit_closure25(BuildPlugin.class, BuildPlugin.class, precommit)), Action.class));
        public final class _configurePrecommit_closure26
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference precommit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configurePrecommit_closure26(Object _outerInstance, Object _thisObject, Reference precommit) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.precommit = reference = precommit;
            }

            public Object doCall(Object it) {
                return ((Task)it).mustRunAfter(new Object[]{this.precommit.get()});
            }

            @Generated
            public TaskProvider getPrecommit() {
                return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.precommit.get(), TaskProvider.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configurePrecommit_closure26.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getTasks().named(JavaPlugin.TEST_TASK_NAME).configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configurePrecommit_closure26(BuildPlugin.class, BuildPlugin.class, precommit)), Action.class));
        public final class _configurePrecommit_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configurePrecommit_closure27(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                public final class _closure62
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure62(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Dependency dependency) {
                        return ScriptBytecodeAdapter.compareEqual((Object)dependency.getGroup().startsWith("org.elasticsearch"), (Object)false);
                    }

                    public Object call(Dependency dependency) {
                        return this.doCall(dependency);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure62.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                FileCollection fileCollection = ((Project)this.project.get()).getConfigurations().getByName(JavaPlugin.RUNTIME_CLASSPATH_CONFIGURATION_NAME).fileCollection((Closure)new _closure62((Object)this, this.getThisObject())).minus((FileCollection)((Project)this.project.get()).getConfigurations().getByName(JavaPlugin.COMPILE_ONLY_CONFIGURATION_NAME));
                ((DependencyLicensesTask)((Object)it)).setDependencies(fileCollection);
                return fileCollection;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configurePrecommit_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getTasks().withType(DependencyLicensesTask.class).named("dependencyLicenses").configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _configurePrecommit_closure27(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
        return null;
    }

    private static Object configureDependenciesInfo(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _configureDependenciesInfo_closure28
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _configureDependenciesInfo_closure28(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(DependenciesInfoTask task) {
                Configuration configuration = ((Project)this.project.get()).getConfigurations().getByName(JavaPlugin.RUNTIME_CLASSPATH_CONFIGURATION_NAME);
                task.setRuntimeConfiguration(configuration);
                Configuration configuration2 = ((Project)this.project.get()).getConfigurations().getByName(JavaPlugin.COMPILE_ONLY_CONFIGURATION_NAME);
                task.setCompileOnlyConfiguration(configuration2);
                public final class _closure63
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure63(Object _outerInstance, Object _thisObject, Reference project) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.project = reference = project;
                    }

                    public Object doCall(Object it) {
                        return ((DependencyLicensesTask)((Object)ScriptBytecodeAdapter.asType((Object)((Project)this.project.get()).getTasks().getByName("dependencyLicenses"), DependencyLicensesTask.class))).getMappings();
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure63.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return task.getConventionMapping().map("mappings", (Closure)new _closure63((Object)this, this.getThisObject(), this.project));
            }

            public Object call(DependenciesInfoTask task) {
                return this.doCall(task);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureDependenciesInfo_closure28.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ((Project)project2.get()).getTasks().register("dependenciesInfo", DependenciesInfoTask.class, (Action)ScriptBytecodeAdapter.asType((Object)((Object)new _configureDependenciesInfo_closure28(BuildPlugin.class, BuildPlugin.class, project2)), Action.class));
    }

    private static Object inFipsJvm() {
        return Boolean.parseBoolean(System.getProperty("tests.fips.enabled"));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BuildPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BuildPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BuildPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BuildPlugin.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static class TestFailureReportingPlugin
    implements Plugin<Project>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public TestFailureReportingPlugin() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void apply(Project project) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)project, (Object)project.getRootProject())) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getClass().getName()}, new String[]{"", " can only be applied to the root project."})));
            }
            project.getGradle().addListener((Object)new TaskActionListener(this){
                public /* synthetic */ TestFailureReportingPlugin this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    TestFailureReportingPlugin testFailureReportingPlugin;
                    this.this$0 = testFailureReportingPlugin = p0;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void beforeActions(Task task) {
                }

                public void afterActions(Task task) {
                    Reference task2 = new Reference((Object)task);
                    if ((Task)task2.get() instanceof Test) {
                        ErrorReportingTestListener listener = (ErrorReportingTestListener)ScriptBytecodeAdapter.castToType((Object)((Task)task2.get()).getExtensions().findByType(ErrorReportingTestListener.class), ErrorReportingTestListener.class);
                        if (listener != null && listener.getFailedTests().size() > 0) {
                            ((Task)task2.get()).getLogger().lifecycle("\nTests with failures:");
                            public final class _afterActions_closure1
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference task;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _afterActions_closure1(Object _outerInstance, Object _thisObject, Reference task) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.task = reference = task;
                                }

                                public Object doCall(Object it) {
                                    ((Task)this.task.get()).getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((ErrorReportingTestListener.Descriptor)it).getFullName()}, new String[]{" - ", ""})));
                                    return null;
                                }

                                @Generated
                                public Task getTask() {
                                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _afterActions_closure1.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            DefaultGroovyMethods.each(listener.getFailedTests(), (Closure)new _afterActions_closure1(this, this, task2));
                        }
                    }
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$1(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, TestFailureReportingPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$1(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, TestFailureReportingPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$1(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, TestFailureReportingPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            });
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TestFailureReportingPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, TestFailureReportingPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(TestFailureReportingPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(TestFailureReportingPlugin.class, BuildPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(TestFailureReportingPlugin.class, BuildPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BuildPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BuildPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TestFailureReportingPlugin.class, BuildPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TestFailureReportingPlugin.class, BuildPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TestFailureReportingPlugin.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

