/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.Test;

public class NamingConventionsCheck {
    private final Set<Class<?>> notImplementing = new HashSet();
    private final Set<Class<?>> pureUnitTest = new HashSet();
    private final Set<Class<?>> missingSuffix = new HashSet();
    private final Set<Class<?>> integTestsInDisguise = new HashSet();
    private final Set<Class<?>> notRunnable = new HashSet();
    private final Set<Class<?>> innerClasses = new HashSet();
    private final Set<Class<?>> testsInMain = new HashSet();
    private final Class<?> testClass;
    private final Class<?> integTestClass;

    public static void main(String[] args) throws IOException {
        Class<?> testClass = null;
        Class<?> integTestClass = null;
        String rootPathList = null;
        boolean skipIntegTestsInDisguise = false;
        boolean checkMainClasses = false;
        block14: for (int i = 0; i < args.length; ++i) {
            String[] arg;
            switch (arg = args[i]) {
                case "--test-class": {
                    testClass = NamingConventionsCheck.loadClassWithoutInitializing(args[++i]);
                    continue block14;
                }
                case "--integ-test-class": {
                    integTestClass = NamingConventionsCheck.loadClassWithoutInitializing(args[++i]);
                    continue block14;
                }
                case "--skip-integ-tests-in-disguise": {
                    skipIntegTestsInDisguise = true;
                    continue block14;
                }
                case "--main": {
                    checkMainClasses = true;
                    continue block14;
                }
                case "--": {
                    rootPathList = args[++i];
                    continue block14;
                }
                default: {
                    NamingConventionsCheck.fail("unsupported argument '" + (String)arg + "'");
                }
            }
        }
        if (rootPathList == null) {
            NamingConventionsCheck.fail("No paths provided");
            return;
        }
        NamingConventionsCheck check = new NamingConventionsCheck(testClass, integTestClass);
        for (String rootDir : rootPathList.split(Pattern.quote(File.pathSeparator))) {
            Path rootPath = Paths.get(rootDir, new String[0]);
            if (checkMainClasses) {
                check.checkMain(rootPath);
                continue;
            }
            check.checkTests(rootPath, skipIntegTestsInDisguise);
        }
        int exitCode = 0;
        exitCode += NamingConventionsCheck.countAndPrintViolations("Not all subclasses of " + check.testClass.getSimpleName() + " match the naming convention. Concrete classes must end with [Tests]", check.missingSuffix);
        exitCode += NamingConventionsCheck.countAndPrintViolations("Classes ending with [Tests] are abstract or interfaces", check.notRunnable);
        exitCode += NamingConventionsCheck.countAndPrintViolations("Found inner classes that are tests, which are excluded from the test runner", check.innerClasses);
        exitCode += NamingConventionsCheck.countAndPrintViolations("Pure Unit-Test found must subclass [" + check.testClass.getSimpleName() + "]", check.pureUnitTest);
        exitCode += NamingConventionsCheck.countAndPrintViolations("Classes ending with [Tests] must subclass [" + check.testClass.getSimpleName() + "]", check.notImplementing);
        exitCode += NamingConventionsCheck.countAndPrintViolations("Classes ending with [Tests] or [IT] or extending [" + check.testClass.getSimpleName() + "] must be in src/test/java", check.testsInMain);
        if (!skipIntegTestsInDisguise) {
            exitCode += NamingConventionsCheck.countAndPrintViolations("Subclasses of " + check.integTestClass.getSimpleName() + " should end with IT as they are integration tests", check.integTestsInDisguise);
        }
        System.exit(exitCode);
    }

    public NamingConventionsCheck(Class<?> testClass, Class<?> integTestClass) {
        this.testClass = Objects.requireNonNull(testClass, "--test-class is required");
        this.integTestClass = integTestClass;
    }

    public void checkTests(Path rootPath, final boolean skipTestsInDisguised) throws IOException {
        Files.walkFileTree(rootPath, new TestClassVisitor(){

            @Override
            protected void visitTestClass(Class<?> clazz) {
                if (!skipTestsInDisguised && NamingConventionsCheck.this.integTestClass.isAssignableFrom(clazz) && clazz != NamingConventionsCheck.this.integTestClass) {
                    NamingConventionsCheck.this.integTestsInDisguise.add(clazz);
                }
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
                    NamingConventionsCheck.this.notRunnable.add(clazz);
                } else if (!this.isTestCase(clazz)) {
                    NamingConventionsCheck.this.notImplementing.add(clazz);
                } else if (Modifier.isStatic(clazz.getModifiers())) {
                    NamingConventionsCheck.this.innerClasses.add(clazz);
                }
            }

            @Override
            protected void visitIntegrationTestClass(Class<?> clazz) {
                if (!this.isTestCase(clazz)) {
                    NamingConventionsCheck.this.notImplementing.add(clazz);
                }
            }

            @Override
            protected void visitOtherClass(Class<?> clazz) {
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
                    return;
                }
                if (this.isTestCase(clazz)) {
                    NamingConventionsCheck.this.missingSuffix.add(clazz);
                } else if (Test.class.isAssignableFrom(clazz)) {
                    NamingConventionsCheck.this.pureUnitTest.add(clazz);
                }
            }
        });
    }

    public void checkMain(Path rootPath) throws IOException {
        Files.walkFileTree(rootPath, new TestClassVisitor(){

            @Override
            protected void visitTestClass(Class<?> clazz) {
                NamingConventionsCheck.this.testsInMain.add(clazz);
            }

            @Override
            protected void visitIntegrationTestClass(Class<?> clazz) {
                NamingConventionsCheck.this.testsInMain.add(clazz);
            }

            @Override
            protected void visitOtherClass(Class<?> clazz) {
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
                    return;
                }
                if (this.isTestCase(clazz)) {
                    NamingConventionsCheck.this.testsInMain.add(clazz);
                }
            }
        });
    }

    private static int countAndPrintViolations(String message, Set<Class<?>> set) {
        if (!set.isEmpty()) {
            System.err.println(message + ":");
            for (Class<?> bad : set) {
                System.err.println(" * " + bad.getName());
            }
            return 1;
        }
        return 0;
    }

    private static void assertViolation(String className, Set<Class<?>> set) {
        String string = className = className.startsWith("org") ? className : "org.elasticsearch.test.NamingConventionsCheckBadClasses$" + className;
        if (!set.remove(NamingConventionsCheck.loadClassWithoutInitializing(className))) {
            System.err.println("Error in NamingConventionsCheck! Expected [" + className + "] to be a violation but wasn't.");
            System.exit(1);
        }
    }

    private static void fail(String reason) {
        System.err.println(reason);
        System.exit(1);
    }

    static Class<?> loadClassWithoutInitializing(String name) {
        try {
            return Class.forName(name, false, NamingConventionsCheck.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    abstract class TestClassVisitor
    implements FileVisitor<Path> {
        private String packageName;

        TestClassVisitor() {
        }

        protected abstract void visitTestClass(Class<?> var1);

        protected abstract void visitIntegrationTestClass(Class<?> var1);

        protected abstract void visitOtherClass(Class<?> var1);

        @Override
        public final FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.packageName = this.packageName == null ? "" : this.packageName + dir.getFileName() + ".";
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.packageName = this.packageName.substring(0, 1 + this.packageName.lastIndexOf(46, this.packageName.length() - 2));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String filename = file.getFileName().toString();
            if (filename.endsWith(".class")) {
                String className = filename.substring(0, filename.length() - ".class".length());
                Class<?> clazz = NamingConventionsCheck.loadClassWithoutInitializing(this.packageName + className);
                if (clazz.getName().endsWith("Tests")) {
                    this.visitTestClass(clazz);
                } else if (clazz.getName().endsWith("IT")) {
                    this.visitIntegrationTestClass(clazz);
                } else {
                    this.visitOtherClass(clazz);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        protected boolean isTestCase(Class<?> clazz) {
            return NamingConventionsCheck.this.testClass.isAssignableFrom(clazz);
        }

        @Override
        public final FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }
    }
}

