/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.GradleServicesAdapter;
import org.elasticsearch.gradle.testclusters.ElasticsearchNode;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.TaskState;

public class TestClustersPlugin
implements Plugin<Project> {
    private static final String LIST_TASK_NAME = "listTestClusters";
    private static final String NODE_EXTENSION_NAME = "testClusters";
    private final Logger logger = Logging.getLogger(TestClustersPlugin.class);

    public void apply(Project project) {
        NamedDomainObjectContainer container = project.container(ElasticsearchNode.class, name -> new ElasticsearchNode(name, GradleServicesAdapter.getInstance(project)));
        project.getExtensions().add(NODE_EXTENSION_NAME, (Object)container);
        Task listTask = project.getTasks().create(LIST_TASK_NAME);
        listTask.setGroup("ES cluster formation");
        listTask.setDescription("Lists all ES clusters configured for this project");
        listTask.doLast(task -> container.forEach(cluster -> this.logger.lifecycle("   * {}: {}", new Object[]{cluster.getName(), cluster.getDistribution()})));
        final HashMap taskToCluster = new HashMap();
        project.getTasks().all(task -> ((ExtraPropertiesExtension)task.getExtensions().findByType(ExtraPropertiesExtension.class)).set("useCluster", (Object)new Closure<Void>((Object)this, (Object)this){

            public void doCall(ElasticsearchNode conf) {
                taskToCluster.computeIfAbsent(task, k -> new ArrayList()).add(conf);
            }
        }));
        project.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> taskExecutionGraph.getAllTasks().forEach(task -> taskToCluster.getOrDefault(task, Collections.emptyList()).forEach(ElasticsearchNode::claim)));
        project.getGradle().addListener((Object)new TaskActionListener(){

            public void beforeActions(Task task) {
                ((List)taskToCluster.getOrDefault(task, new ArrayList())).forEach(ElasticsearchNode::start);
            }

            public void afterActions(Task task) {
            }
        });
        project.getGradle().addListener((Object)new TaskExecutionListener(){

            public void afterExecute(Task task, TaskState state) {
                ((List)taskToCluster.getOrDefault(task, new ArrayList())).forEach(ElasticsearchNode::unClaimAndStop);
            }

            public void beforeExecute(Task task) {
            }
        });
    }
}

