/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.GradleServicesAdapter;
import org.elasticsearch.gradle.Distribution;
import org.elasticsearch.gradle.Version;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ElasticsearchNode {
    private final String name;
    private final GradleServicesAdapter services;
    private final AtomicInteger noOfClaims = new AtomicInteger();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Logger logger = Logging.getLogger(ElasticsearchNode.class);
    private Distribution distribution;
    private Version version;

    public ElasticsearchNode(String name, GradleServicesAdapter services) {
        this.name = name;
        this.services = services;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.checkNotRunning();
        this.version = version;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.checkNotRunning();
        this.distribution = distribution;
    }

    public void claim() {
        this.noOfClaims.incrementAndGet();
    }

    public Future<Void> start() {
        if (this.started.getAndSet(true)) {
            this.logger.lifecycle("Already started cluster: {}", new Object[]{this.name});
        } else {
            this.logger.lifecycle("Starting cluster: {}", new Object[]{this.name});
        }
        return null;
    }

    public void unClaimAndStop() {
        int decrementedClaims = this.noOfClaims.decrementAndGet();
        if (decrementedClaims > 0) {
            this.logger.lifecycle("Not stopping {}, since cluster still has {} claim(s)", new Object[]{this.name, decrementedClaims});
            return;
        }
        if (!this.started.get()) {
            this.logger.lifecycle("Asked to unClaimAndStop, but cluster was not running: {}", new Object[]{this.name});
            return;
        }
        this.logger.lifecycle("Stopping {}, number of claims is {}", new Object[]{this.name, decrementedClaims});
    }

    private void checkNotRunning() {
        if (this.started.get()) {
            throw new IllegalStateException("Configuration can not be altered while running ");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchNode that = (ElasticsearchNode)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

