/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.output.NullOutputStream;
import org.elasticsearch.gradle.JdkJarHellCheck;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;

public class ThirdPartyAuditTask
extends DefaultTask {
    private static final Pattern MISSING_CLASS_PATTERN = Pattern.compile("WARNING: Class '(.*)' cannot be loaded \\(.*\\)\\. Please fix the classpath!");
    private static final Pattern VIOLATION_PATTERN = Pattern.compile("\\s\\sin ([a-zA-Z0-9$.]+) \\(.*\\)");
    private Set<String> excludes = new TreeSet<String>();
    private File signatureFile;
    private String javaHome;
    private JavaVersion targetCompatibility;

    @Input
    public JavaVersion getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(JavaVersion targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    @InputFiles
    public Configuration getForbiddenAPIsConfiguration() {
        return this.getProject().getConfigurations().getByName("forbiddenApisCliJar");
    }

    @InputFile
    public File getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(File signatureFile) {
        this.signatureFile = signatureFile;
    }

    @InputFiles
    public Configuration getRuntimeConfiguration() {
        Configuration runtime = (Configuration)this.getProject().getConfigurations().findByName("runtime");
        if (runtime == null) {
            return this.getProject().getConfigurations().getByName("testCompile");
        }
        return runtime;
    }

    @Input
    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    @InputFiles
    public Configuration getCompileOnlyConfiguration() {
        return this.getProject().getConfigurations().getByName("compileOnly");
    }

    @OutputDirectory
    public File getJarExpandDir() {
        return new File(new File(this.getProject().getBuildDir(), "precommit/thirdPartyAudit"), this.getName());
    }

    public void setExcludes(String ... classes) {
        this.excludes.clear();
        for (String each : classes) {
            if (each.indexOf(42) != -1) {
                throw new IllegalArgumentException("illegal third party audit exclusion: '" + each + "', wildcards are not permitted!");
            }
            this.excludes.add(each);
        }
    }

    @Input
    public Set<String> getExcludes() {
        return Collections.unmodifiableSet(this.excludes);
    }

    @TaskAction
    public void runThirdPartyAudit() throws IOException {
        FileCollection jars = this.getJarsToScan();
        this.extractJars(jars);
        String forbiddenApisOutput = this.runForbiddenAPIsCli();
        TreeSet<String> missingClasses = new TreeSet<String>();
        Matcher missingMatcher = MISSING_CLASS_PATTERN.matcher(forbiddenApisOutput);
        while (missingMatcher.find()) {
            missingClasses.add(missingMatcher.group(1));
        }
        TreeSet<String> violationsClasses = new TreeSet<String>();
        Matcher violationMatcher = VIOLATION_PATTERN.matcher(forbiddenApisOutput);
        while (violationMatcher.find()) {
            violationsClasses.add(violationMatcher.group(1));
        }
        Set<String> jdkJarHellClasses = this.runJdkJarHellCheck();
        this.assertNoPointlessExclusions(missingClasses, violationsClasses, jdkJarHellClasses);
        this.assertNoMissingAndViolations(missingClasses, violationsClasses);
        this.assertNoJarHell(jdkJarHellClasses);
    }

    private void extractJars(FileCollection jars) {
        File jarExpandDir = this.getJarExpandDir();
        this.getProject().delete(new Object[]{jarExpandDir});
        jars.forEach(jar -> {
            FileTree jarFiles = this.getProject().zipTree(jar);
            this.getProject().copy(spec -> {
                spec.from(new Object[]{jarFiles});
                spec.into((Object)jarExpandDir);
                spec.exclude(new String[]{"META-INF/versions/**"});
            });
            IntStream.rangeClosed(Integer.parseInt(JavaVersion.VERSION_1_9.getMajorVersion()), Integer.parseInt(this.targetCompatibility.getMajorVersion())).forEach(majorVersion -> this.getProject().copy(spec -> {
                spec.from(new Object[]{this.getProject().zipTree(jar)});
                spec.into((Object)jarExpandDir);
                String metaInfPrefix = "META-INF/versions/" + majorVersion;
                spec.include(new String[]{metaInfPrefix + "/**"});
                spec.eachFile(details -> details.setPath(details.getPath().replace(metaInfPrefix, "")));
                spec.setIncludeEmptyDirs(false);
            }));
        });
    }

    private void assertNoJarHell(Set<String> jdkJarHellClasses) {
        jdkJarHellClasses.removeAll(this.excludes);
        if (!jdkJarHellClasses.isEmpty()) {
            throw new IllegalStateException("Jar Hell with the JDK:" + this.formatClassList(jdkJarHellClasses));
        }
    }

    private void assertNoMissingAndViolations(Set<String> missingClasses, Set<String> violationsClasses) {
        missingClasses.removeAll(this.excludes);
        violationsClasses.removeAll(this.excludes);
        String missingText = this.formatClassList(missingClasses);
        String violationsText = this.formatClassList(violationsClasses);
        if (!missingText.isEmpty() || !violationsText.isEmpty()) {
            throw new IllegalStateException("Audit of third party dependencies failed:\n" + (missingText.isEmpty() ? "" : "Missing classes:\n" + missingText) + (violationsText.isEmpty() ? "" : "Classes with violations:\n" + violationsText));
        }
        this.getLogger().info("Third party audit passed successfully");
    }

    private void assertNoPointlessExclusions(Set<String> missingClasses, Set<String> violationsClasses, Set<String> jdkJarHellClasses) {
        TreeSet<String> bogusExclusions = new TreeSet<String>(this.excludes);
        bogusExclusions.removeAll(missingClasses);
        bogusExclusions.removeAll(jdkJarHellClasses);
        bogusExclusions.removeAll(violationsClasses);
        if (!bogusExclusions.isEmpty()) {
            throw new IllegalStateException("Invalid exclusions, nothing is wrong with these classes: " + this.formatClassList(bogusExclusions));
        }
    }

    private String runForbiddenAPIsCli() throws IOException {
        String forbiddenApisOutput;
        ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
        this.getProject().javaexec(spec -> {
            spec.setExecutable(this.javaHome + "/bin/java");
            spec.classpath(new Object[]{this.getForbiddenAPIsConfiguration(), this.getRuntimeConfiguration(), this.getCompileOnlyConfiguration()});
            spec.setMain("de.thetaphi.forbiddenapis.cli.CliMain");
            spec.args(new Object[]{"-f", this.getSignatureFile().getAbsolutePath(), "-d", this.getJarExpandDir(), "--allowmissingclasses"});
            spec.setErrorOutput((OutputStream)errorOut);
            if (!this.getLogger().isInfoEnabled()) {
                spec.setStandardOutput((OutputStream)new NullOutputStream());
            }
            spec.setIgnoreExitValue(true);
        });
        try (ByteArrayOutputStream outputStream = errorOut;){
            forbiddenApisOutput = outputStream.toString(StandardCharsets.UTF_8.name());
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(forbiddenApisOutput);
        }
        return forbiddenApisOutput;
    }

    private FileCollection getJarsToScan() {
        FileCollection jars = this.getRuntimeConfiguration().fileCollection(dep -> !dep.getGroup().startsWith("org.elasticsearch"));
        Configuration compileOnlyConfiguration = this.getCompileOnlyConfiguration();
        if (compileOnlyConfiguration != null) {
            jars.minus((FileCollection)compileOnlyConfiguration);
        }
        if (jars.isEmpty()) {
            throw new StopExecutionException("No jars to scan");
        }
        return jars;
    }

    private String formatClassList(Set<String> classList) {
        return classList.stream().map(name -> "  * " + name).collect(Collectors.joining("\n"));
    }

    private Set<String> runJdkJarHellCheck() throws IOException {
        String jdkJarHellCheckList;
        ByteArrayOutputStream standardOut = new ByteArrayOutputStream();
        ExecResult execResult = this.getProject().javaexec(spec -> {
            URL location = JdkJarHellCheck.class.getProtectionDomain().getCodeSource().getLocation();
            if (!location.getProtocol().equals("file")) {
                throw new GradleException("Unexpected location for JdkJarHellCheck class: " + location);
            }
            try {
                spec.classpath(new Object[]{location.toURI().getPath(), this.getRuntimeConfiguration(), this.getCompileOnlyConfiguration()});
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
            spec.setMain(JdkJarHellCheck.class.getName());
            spec.args(new Object[]{this.getJarExpandDir()});
            spec.setIgnoreExitValue(true);
            spec.setExecutable(this.javaHome + "/bin/java");
            spec.setStandardOutput((OutputStream)standardOut);
        });
        if (execResult.getExitValue() == 0) {
            return Collections.emptySet();
        }
        try (ByteArrayOutputStream outputStream = standardOut;){
            jdkJarHellCheckList = outputStream.toString(StandardCharsets.UTF_8.name());
        }
        return new TreeSet<String>(Arrays.asList(jdkJarHellCheckList.split("\\r?\\n")));
    }
}

