/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.precommit.PrecommitTask;
import org.elasticsearch.test.NamingConventionsCheck;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class NamingConventionsTask
extends PrecommitTask {
    private Object javaHome;
    private boolean skipIntegTestInDisguise = false;
    private String testClass = "org.apache.lucene.util.LuceneTestCase";
    private String integTestClass = "org.elasticsearch.test.ESIntegTestCase";
    private boolean checkForTestsInMain = false;

    public NamingConventionsTask() {
        this.setDescription("Tests that test classes aren't misnamed or misplaced");
        this.dependsOn(new Object[]{((SourceSet)this.getJavaSourceSets().getByName(this.checkForTestsInMain ? "main" : "test")).getClassesTaskName()});
    }

    @TaskAction
    public void runNamingConventions() {
        LoggedExec.javaexec(this.getProject(), (Action<JavaExecSpec>)((Action)spec -> {
            spec.classpath(new Object[]{this.getNamingConventionsCheckClassFiles(), this.getSourceSetClassPath()});
            spec.executable((Object)(this.getJavaHome() + "/bin/java"));
            spec.jvmArgs(new Object[]{"-Djna.nosys=true"});
            spec.setMain(NamingConventionsCheck.class.getName());
            spec.args(new Object[]{"--test-class", this.getTestClass()});
            if (this.isSkipIntegTestInDisguise()) {
                spec.args(new Object[]{"--skip-integ-tests-in-disguise"});
            } else {
                spec.args(new Object[]{"--integ-test-class", this.getIntegTestClass()});
            }
            if (this.isCheckForTestsInMain()) {
                spec.args(new Object[]{"--main"});
                spec.args(new Object[]{"--"});
            } else {
                spec.args(new Object[]{"--"});
            }
            spec.args(new Object[]{this.getExistingClassesDirs().getAsPath()});
        }));
    }

    @Input
    public Object getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(Object javaHome) {
        this.javaHome = javaHome;
    }

    @Classpath
    public FileCollection getSourceSetClassPath() {
        SourceSetContainer sourceSets = this.getJavaSourceSets();
        return this.getProject().files(new Object[]{((SourceSet)sourceSets.getByName("test")).getCompileClasspath(), ((SourceSet)sourceSets.getByName("test")).getOutput(), this.checkForTestsInMain ? ((SourceSet)sourceSets.getByName("main")).getRuntimeClasspath() : this.getProject().files(new Object[0])});
    }

    @InputFiles
    public File getNamingConventionsCheckClassFiles() {
        URL location = NamingConventionsCheck.class.getProtectionDomain().getCodeSource().getLocation();
        if (!location.getProtocol().equals("file")) {
            throw new GradleException("Unexpected location for NamingConventionCheck class: " + location);
        }
        try {
            return new File(location.toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getExistingClassesDirs() {
        FileCollection classesDirs = ((SourceSet)this.getJavaSourceSets().getByName(this.checkForTestsInMain ? "main" : "test")).getOutput().getClassesDirs();
        return classesDirs.filter(it -> it.exists());
    }

    @Input
    public boolean isSkipIntegTestInDisguise() {
        return this.skipIntegTestInDisguise;
    }

    public void setSkipIntegTestInDisguise(boolean skipIntegTestInDisguise) {
        this.skipIntegTestInDisguise = skipIntegTestInDisguise;
    }

    @Input
    public String getTestClass() {
        return this.testClass;
    }

    public void setTestClass(String testClass) {
        this.testClass = testClass;
    }

    @Input
    public String getIntegTestClass() {
        return this.integTestClass;
    }

    public void setIntegTestClass(String integTestClass) {
        this.integTestClass = integTestClass;
    }

    @Input
    public boolean isCheckForTestsInMain() {
        return this.checkForTestsInMain;
    }

    public void setCheckForTestsInMain(boolean checkForTestsInMain) {
        this.checkForTestsInMain = checkForTestsInMain;
    }

    private SourceSetContainer getJavaSourceSets() {
        return ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
    }
}

