/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.File;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.precommit.PrecommitTask;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class LoggerUsageTask
extends PrecommitTask {
    private FileCollection classpath;
    private Object javaHome;

    public LoggerUsageTask() {
        this.setDescription("Runs LoggerUsageCheck on output directories of all source sets");
        ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> this.dependsOn(new Object[]{sourceSet.getClassesTaskName()}));
    }

    @TaskAction
    public void runLoggerUsageTask() {
        LoggedExec.javaexec(this.getProject(), (Action<JavaExecSpec>)((Action)spec -> {
            spec.setMain("org.elasticsearch.test.loggerusage.ESLoggerUsageChecker");
            spec.classpath(new Object[]{this.getClasspath()});
            spec.executable((Object)(this.getJavaHome() + "/bin/java"));
            this.getClassDirectories().forEach(xva$0 -> spec.args(new Object[]{xva$0}));
        }));
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getClassDirectories() {
        return ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().stream().filter(sourceSet -> sourceSet.getName().equals("main") || sourceSet.getName().equals("test")).map(sourceSet -> sourceSet.getOutput().getClassesDirs()).reduce(FileCollection::plus).orElse((FileCollection)this.getProject().files(new Object[0])).filter(File::exists);
    }

    @Input
    public Object getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(Object javaHome) {
        this.javaHome = javaHome;
    }
}

