/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.precommit.PrecommitTask;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class JarHellTask
extends PrecommitTask {
    private FileCollection classpath;
    private Object javaHome;

    public JarHellTask() {
        this.setDescription("Runs CheckJarHell on the configured classpath");
    }

    @TaskAction
    public void runJarHellCheck() {
        LoggedExec.javaexec(this.getProject(), (Action<JavaExecSpec>)((Action)spec -> {
            spec.classpath(new Object[]{this.getClasspath()});
            spec.executable((Object)(this.getJavaHome() + "/bin/java"));
            spec.setMain("org.elasticsearch.bootstrap.JarHell");
        }));
    }

    @Input
    public Object getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(Object javaHome) {
        this.javaHome = javaHome;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath.filter(file -> file.exists());
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }
}

