/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int revision;
    private final int id;
    private final boolean snapshot;
    private final String suffix;
    private static final Pattern pattern = Pattern.compile("(\\d)+\\.(\\d+)\\.(\\d+)(-alpha\\d+|-beta\\d+|-rc\\d+)?(-SNAPSHOT)?");

    public Version(int major, int minor, int revision, String suffix, boolean snapshot) {
        Objects.requireNonNull(Integer.valueOf(major), "major version can't be null");
        Objects.requireNonNull(Integer.valueOf(minor), "minor version can't be null");
        Objects.requireNonNull(Integer.valueOf(revision), "revision version can't be null");
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.snapshot = snapshot;
        this.suffix = suffix == null ? "" : suffix;
        int suffixOffset = 0;
        if (!this.suffix.isEmpty()) {
            if (this.suffix.contains("alpha")) {
                suffixOffset += Version.parseSuffixNumber(this.suffix.substring(6));
            } else if (this.suffix.contains("beta")) {
                suffixOffset += 25 + Version.parseSuffixNumber(this.suffix.substring(5));
            } else if (this.suffix.contains("rc")) {
                suffixOffset += 50 + Version.parseSuffixNumber(this.suffix.substring(3));
            } else {
                throw new IllegalArgumentException("Suffix must contain one of: alpha, beta or rc");
            }
        }
        this.id = major * 10000000 + minor * 100000 + revision * 1000 + suffixOffset * 10;
    }

    private static int parseSuffixNumber(String substring) {
        if (substring.isEmpty()) {
            throw new IllegalArgumentException("Invalid suffix, must contain a number e.x. alpha2");
        }
        return Integer.parseInt(substring);
    }

    public static Version fromString(String s) {
        Objects.requireNonNull(s);
        Matcher matcher = pattern.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version format: '" + s + "'. Should be major.minor.revision[-(alpha|beta|rc)Number][-SNAPSHOT]");
        }
        return new Version(Integer.parseInt(matcher.group(1)), Version.parseSuffixNumber(matcher.group(2)), Version.parseSuffixNumber(matcher.group(3)), matcher.group(4), matcher.group(5) != null);
    }

    public String toString() {
        String snapshotStr = this.snapshot ? "-SNAPSHOT" : "";
        return String.valueOf(this.getMajor()) + "." + String.valueOf(this.getMinor()) + "." + String.valueOf(this.getRevision()) + (this.suffix == null ? "" : this.suffix) + snapshotStr;
    }

    public boolean before(Version compareTo) {
        return this.id < compareTo.getId();
    }

    public boolean before(String compareTo) {
        return this.before(Version.fromString(compareTo));
    }

    public boolean onOrBefore(Version compareTo) {
        return this.id <= compareTo.getId();
    }

    public boolean onOrBefore(String compareTo) {
        return this.onOrBefore(Version.fromString(compareTo));
    }

    public boolean onOrAfter(Version compareTo) {
        return this.id >= compareTo.getId();
    }

    public boolean onOrAfter(String compareTo) {
        return this.onOrAfter(Version.fromString(compareTo));
    }

    public boolean after(Version compareTo) {
        return this.id > compareTo.getId();
    }

    public boolean after(String compareTo) {
        return this.after(Version.fromString(compareTo));
    }

    public boolean onOrBeforeIncludingSuffix(Version otherVersion) {
        if (this.id != otherVersion.getId()) {
            return this.id < otherVersion.getId();
        }
        if (this.suffix.equals("")) {
            return otherVersion.getSuffix().equals("");
        }
        return otherVersion.getSuffix().equals("") || this.suffix.compareTo(otherVersion.getSuffix()) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.revision == version.revision && this.id == version.id && this.snapshot == version.snapshot && Objects.equals(this.suffix, version.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.id, this.snapshot, this.suffix);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    protected int getId() {
        return this.id;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.getId(), other.getId());
    }

    public boolean isVersionBrokenIfCgroupsV2Enabled() {
        return this.onOrAfter("5.1.1") && this.onOrBefore("5.3.0");
    }
}

