/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramMerger;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.exponentialhistogram.MergingBucketIterator;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class ExponentialHistogramUtils {
    public static double estimateSum(BucketIterator negativeBuckets, BucketIterator positiveBuckets) {
        assert (negativeBuckets.scale() == positiveBuckets.scale());
        MergingBucketIterator it = new MergingBucketIterator(positiveBuckets, negativeBuckets, positiveBuckets.scale(), (positiveCount, negativeCount) -> positiveCount - negativeCount);
        double sum = 0.0;
        while (it.hasNext()) {
            long countWithSign = it.peekCount();
            double bucketMidPoint = ExponentialScaleUtils.getPointOfLeastRelativeError(it.peekIndex(), it.scale());
            if (countWithSign != 0L) {
                double toAdd = bucketMidPoint * (double)countWithSign;
                sum = Double.isFinite(toAdd) ? (sum += toAdd) : toAdd;
            }
            it.advance();
        }
        return sum;
    }

    public static OptionalDouble estimateMin(ZeroBucket zeroBucket, ExponentialHistogram.Buckets negativeBuckets, ExponentialHistogram.Buckets positiveBuckets) {
        int scale = negativeBuckets.iterator().scale();
        assert (scale == positiveBuckets.iterator().scale());
        OptionalLong negativeMaxIndex = negativeBuckets.maxBucketIndex();
        if (negativeMaxIndex.isPresent()) {
            return OptionalDouble.of(-ExponentialScaleUtils.getUpperBucketBoundary(negativeMaxIndex.getAsLong(), scale));
        }
        if (zeroBucket.count() > 0L) {
            if (zeroBucket.zeroThreshold() == 0.0) {
                return OptionalDouble.of(0.0);
            }
            return OptionalDouble.of(-zeroBucket.zeroThreshold());
        }
        CopyableBucketIterator positiveBucketsIt = positiveBuckets.iterator();
        if (positiveBucketsIt.hasNext()) {
            return OptionalDouble.of(ExponentialScaleUtils.getLowerBucketBoundary(positiveBucketsIt.peekIndex(), scale));
        }
        return OptionalDouble.empty();
    }

    public static OptionalDouble estimateMax(ZeroBucket zeroBucket, ExponentialHistogram.Buckets negativeBuckets, ExponentialHistogram.Buckets positiveBuckets) {
        int scale = negativeBuckets.iterator().scale();
        assert (scale == positiveBuckets.iterator().scale());
        OptionalLong positiveMaxIndex = positiveBuckets.maxBucketIndex();
        if (positiveMaxIndex.isPresent()) {
            return OptionalDouble.of(ExponentialScaleUtils.getUpperBucketBoundary(positiveMaxIndex.getAsLong(), scale));
        }
        if (zeroBucket.count() > 0L) {
            return OptionalDouble.of(zeroBucket.zeroThreshold());
        }
        CopyableBucketIterator negativeBucketsIt = negativeBuckets.iterator();
        if (negativeBucketsIt.hasNext()) {
            return OptionalDouble.of(-ExponentialScaleUtils.getLowerBucketBoundary(negativeBucketsIt.peekIndex(), scale));
        }
        return OptionalDouble.empty();
    }

    public static HistogramPair removeMergeNoise(ExponentialHistogram first, ExponentialHistogram second) {
        int targetScale = Math.min(first.scale(), second.scale());
        ExponentialHistogram a = ExponentialHistogramUtils.downscaleTo(first, targetScale);
        ExponentialHistogram b = ExponentialHistogramUtils.downscaleTo(second, targetScale);
        double sumError = Math.abs(b.sum()) < 1.0E-4 ? Math.abs(a.sum() - b.sum()) : Math.abs(1.0 - a.sum() / b.sum());
        if (sumError < 0.01) {
            double averageSum = (a.sum() + b.sum()) / 2.0;
            a = ExponentialHistogram.builder(a, ExponentialHistogramCircuitBreaker.noop()).sum(averageSum).build();
            b = ExponentialHistogram.builder(b, ExponentialHistogramCircuitBreaker.noop()).sum(averageSum).build();
        }
        if (a.zeroBucket().count() > 0L && b.zeroBucket().count() > 0L) {
            ZeroBucket targetZeroBucket = a.zeroBucket().compareZeroThreshold(b.zeroBucket()) >= 0 ? a.zeroBucket() : b.zeroBucket();
            a = ExponentialHistogramUtils.increaseZeroThreshold(a, targetZeroBucket);
            b = ExponentialHistogramUtils.increaseZeroThreshold(b, targetZeroBucket);
        }
        return new HistogramPair(a, b);
    }

    private static ExponentialHistogram downscaleTo(ExponentialHistogram histogram, int targetScale) {
        assert (histogram.scale() >= targetScale);
        int bucketCount = Math.max(4, histogram.positiveBuckets().bucketCount() + histogram.negativeBuckets().bucketCount());
        ExponentialHistogramMerger merger = ExponentialHistogramMerger.createWithMaxScale(bucketCount, targetScale, ExponentialHistogramCircuitBreaker.noop());
        merger.addWithoutUpscaling(histogram);
        return merger.get();
    }

    private static ExponentialHistogram increaseZeroThreshold(ExponentialHistogram histo, ZeroBucket targetZeroBucket) {
        int bucketCount = Math.max(4, histo.positiveBuckets().bucketCount() + histo.negativeBuckets().bucketCount());
        ExponentialHistogramMerger merger = ExponentialHistogramMerger.create(bucketCount, ExponentialHistogramCircuitBreaker.noop());
        merger.addWithoutUpscaling(histo);
        merger.add(ExponentialHistogram.builder(38, ExponentialHistogramCircuitBreaker.noop()).zeroBucket(ExponentialHistogramUtils.copyWithNewCount(targetZeroBucket, 1L)).build());
        ExponentialHistogram mergeResult = merger.get();
        return ExponentialHistogram.builder(mergeResult, ExponentialHistogramCircuitBreaker.noop()).zeroBucket(ExponentialHistogramUtils.copyWithNewCount(mergeResult.zeroBucket(), mergeResult.zeroBucket().count() - 1L)).build();
    }

    private static ZeroBucket copyWithNewCount(ZeroBucket zb, long newCount) {
        if (zb.isIndexBased()) {
            return ZeroBucket.create(zb.index(), zb.scale(), newCount);
        }
        return ZeroBucket.create(zb.zeroThreshold(), newCount);
    }

    public record HistogramPair(ExponentialHistogram first, ExponentialHistogram second) {
    }
}

