/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.nio.charset.StandardCharsets;
import java.util.function.IntConsumer;
import org.elasticsearch.nativeaccess.WindowsNativeAccess;
import org.elasticsearch.nativeaccess.jdk.ArenaUtil;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.MemorySegmentUtil;
import org.elasticsearch.nativeaccess.lib.Kernel32Library;

class JdkKernel32Library
implements Kernel32Library {
    private static final StructLayout CAPTURE_GETLASTERROR_LAYOUT;
    private static final Linker.Option CAPTURE_GETLASTERROR_OPTION;
    private static final VarHandle GetLastError$vh;
    private static final MethodHandle GetCurrentProcess$mh;
    private static final MethodHandle CloseHandle$mh;
    private static final MethodHandle VirtualLock$mh;
    private static final MethodHandle VirtualQueryEx$mh;
    private static final MethodHandle SetProcessWorkingSetSize$mh;
    private static final MethodHandle GetCompressedFileSizeW$mh;
    private static final MethodHandle GetShortPathNameW$mh;
    private static final MethodHandle SetConsoleCtrlHandler$mh;
    private static final FunctionDescriptor ConsoleCtrlHandler_handle$fd;
    private static final MethodHandle ConsoleCtrlHandler_handle$mh;
    private static final MethodHandle CreateJobObjectW$mh;
    private static final MethodHandle AssignProcessToJobObject$mh;
    private static final MethodHandle QueryInformationJobObject$mh;
    private static final MethodHandle SetInformationJobObject$mh;
    private final MemorySegment lastErrorState;

    private static MethodHandle downcallHandleWithError(String function, FunctionDescriptor functionDescriptor) {
        return LinkerHelper.downcallHandle(function, functionDescriptor, CAPTURE_GETLASTERROR_OPTION);
    }

    JdkKernel32Library() {
        Arena arena = Arena.ofAuto();
        this.lastErrorState = arena.allocate(CAPTURE_GETLASTERROR_LAYOUT);
    }

    @Override
    public Kernel32Library.Handle GetCurrentProcess() {
        try {
            return new JdkHandle(GetCurrentProcess$mh.invokeExact());
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public boolean CloseHandle(Kernel32Library.Handle handle) {
        assert (handle instanceof JdkHandle);
        JdkHandle jdkHandle = (JdkHandle)handle;
        try {
            return CloseHandle$mh.invokeExact(this.lastErrorState, jdkHandle.address);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int GetLastError() {
        return GetLastError$vh.get(this.lastErrorState);
    }

    @Override
    public Kernel32Library.MemoryBasicInformation newMemoryBasicInformation() {
        return new JdkMemoryBasicInformation();
    }

    @Override
    public boolean VirtualLock(Kernel32Library.Address address, long size) {
        assert (address instanceof JdkAddress);
        JdkAddress jdkAddress = (JdkAddress)address;
        try {
            return VirtualLock$mh.invokeExact(this.lastErrorState, jdkAddress.address, size);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int VirtualQueryEx(Kernel32Library.Handle process, Kernel32Library.Address address, Kernel32Library.MemoryBasicInformation memoryInfo) {
        assert (process instanceof JdkHandle);
        assert (address instanceof JdkAddress);
        assert (memoryInfo instanceof JdkMemoryBasicInformation);
        JdkHandle jdkProcess = (JdkHandle)process;
        JdkAddress jdkAddress = (JdkAddress)address;
        JdkMemoryBasicInformation jdkMemoryInfo = (JdkMemoryBasicInformation)memoryInfo;
        try {
            return VirtualQueryEx$mh.invokeExact(this.lastErrorState, jdkProcess.address, jdkAddress.address, jdkMemoryInfo.segment, jdkMemoryInfo.segment.byteSize());
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public boolean SetProcessWorkingSetSize(Kernel32Library.Handle process, long minSize, long maxSize) {
        assert (process instanceof JdkHandle);
        JdkHandle jdkProcess = (JdkHandle)process;
        try {
            return SetProcessWorkingSetSize$mh.invokeExact(this.lastErrorState, jdkProcess.address, minSize, maxSize);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int GetCompressedFileSizeW(String lpFileName, IntConsumer lpFileSizeHigh) {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment wideFileName = ArenaUtil.allocateFrom(arena, lpFileName + "\u0000", StandardCharsets.UTF_16LE);
            MemorySegment fileSizeHigh = arena.allocate(ValueLayout.JAVA_INT);
            int ret = GetCompressedFileSizeW$mh.invokeExact(this.lastErrorState, wideFileName, fileSizeHigh);
            lpFileSizeHigh.accept(fileSizeHigh.get(ValueLayout.JAVA_INT, 0L));
            int n = ret;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    @Override
    public int GetShortPathNameW(String lpszLongPath, char[] lpszShortPath, int cchBuffer) {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment wideFileName = ArenaUtil.allocateFrom(arena, lpszLongPath + "\u0000", StandardCharsets.UTF_16LE);
            MemorySegment shortPath = lpszShortPath != null ? ArenaUtil.allocate(arena, ValueLayout.JAVA_CHAR, cchBuffer) : MemorySegment.NULL;
            int ret = GetShortPathNameW$mh.invokeExact(this.lastErrorState, wideFileName, shortPath, cchBuffer);
            if (shortPath != MemorySegment.NULL) {
                for (int i = 0; i < cchBuffer; ++i) {
                    lpszShortPath[i] = shortPath.getAtIndex(ValueLayout.JAVA_CHAR, (long)i);
                }
            }
            int n = ret;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    @Override
    public boolean SetConsoleCtrlHandler(WindowsNativeAccess.ConsoleCtrlHandler handler, boolean add) {
        MemorySegment nativeHandler = LinkerHelper.upcallStub(ConsoleCtrlHandler_handle$mh, handler, ConsoleCtrlHandler_handle$fd, Arena.global());
        try {
            return SetConsoleCtrlHandler$mh.invokeExact(this.lastErrorState, nativeHandler, add);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public Kernel32Library.Handle CreateJobObjectW() {
        try {
            return new JdkHandle(CreateJobObjectW$mh.invokeExact(this.lastErrorState, MemorySegment.NULL, MemorySegment.NULL));
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public boolean AssignProcessToJobObject(Kernel32Library.Handle job, Kernel32Library.Handle process) {
        assert (job instanceof JdkHandle);
        assert (process instanceof JdkHandle);
        JdkHandle jdkJob = (JdkHandle)job;
        JdkHandle jdkProcess = (JdkHandle)process;
        try {
            return AssignProcessToJobObject$mh.invokeExact(this.lastErrorState, jdkJob.address, jdkProcess.address);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public Kernel32Library.JobObjectBasicLimitInformation newJobObjectBasicLimitInformation() {
        return new JdkJobObjectBasicLimitInformation();
    }

    @Override
    public boolean QueryInformationJobObject(Kernel32Library.Handle job, int infoClass, Kernel32Library.JobObjectBasicLimitInformation info) {
        assert (job instanceof JdkHandle);
        assert (info instanceof JdkJobObjectBasicLimitInformation);
        JdkHandle jdkJob = (JdkHandle)job;
        JdkJobObjectBasicLimitInformation jdkInfo = (JdkJobObjectBasicLimitInformation)info;
        try {
            return QueryInformationJobObject$mh.invokeExact(this.lastErrorState, jdkJob.address, infoClass, jdkInfo.segment, (int)jdkInfo.segment.byteSize(), MemorySegment.NULL);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public boolean SetInformationJobObject(Kernel32Library.Handle job, int infoClass, Kernel32Library.JobObjectBasicLimitInformation info) {
        assert (job instanceof JdkHandle);
        assert (info instanceof JdkJobObjectBasicLimitInformation);
        JdkHandle jdkJob = (JdkHandle)job;
        JdkJobObjectBasicLimitInformation jdkInfo = (JdkJobObjectBasicLimitInformation)info;
        try {
            return SetInformationJobObject$mh.invokeExact(this.lastErrorState, jdkJob.address, infoClass, jdkInfo.segment, (int)jdkInfo.segment.byteSize());
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static {
        System.loadLibrary("kernel32");
        CAPTURE_GETLASTERROR_LAYOUT = Linker.Option.captureStateLayout();
        CAPTURE_GETLASTERROR_OPTION = Linker.Option.captureCallState("GetLastError");
        GetLastError$vh = MemorySegmentUtil.varHandleWithoutOffset(CAPTURE_GETLASTERROR_LAYOUT, MemoryLayout.PathElement.groupElement("GetLastError"));
        GetCurrentProcess$mh = LinkerHelper.downcallHandle("GetCurrentProcess", FunctionDescriptor.of(ValueLayout.ADDRESS, new MemoryLayout[0]), new Linker.Option[0]);
        CloseHandle$mh = JdkKernel32Library.downcallHandleWithError("CloseHandle", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS));
        VirtualLock$mh = JdkKernel32Library.downcallHandleWithError("VirtualLock", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG));
        VirtualQueryEx$mh = JdkKernel32Library.downcallHandleWithError("VirtualQueryEx", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG));
        SetProcessWorkingSetSize$mh = JdkKernel32Library.downcallHandleWithError("SetProcessWorkingSetSize", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG));
        GetCompressedFileSizeW$mh = JdkKernel32Library.downcallHandleWithError("GetCompressedFileSizeW", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        GetShortPathNameW$mh = JdkKernel32Library.downcallHandleWithError("GetShortPathNameW", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        SetConsoleCtrlHandler$mh = JdkKernel32Library.downcallHandleWithError("SetConsoleCtrlHandler", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_BOOLEAN));
        ConsoleCtrlHandler_handle$fd = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_INT);
        ConsoleCtrlHandler_handle$mh = LinkerHelper.upcallHandle(WindowsNativeAccess.ConsoleCtrlHandler.class, "handle", ConsoleCtrlHandler_handle$fd);
        CreateJobObjectW$mh = JdkKernel32Library.downcallHandleWithError("CreateJobObjectW", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        AssignProcessToJobObject$mh = JdkKernel32Library.downcallHandleWithError("AssignProcessToJobObject", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        QueryInformationJobObject$mh = JdkKernel32Library.downcallHandleWithError("QueryInformationJobObject", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        SetInformationJobObject$mh = JdkKernel32Library.downcallHandleWithError("SetInformationJobObject", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
    }

    static class JdkHandle
    implements Kernel32Library.Handle {
        MemorySegment address;

        JdkHandle(MemorySegment address) {
            this.address = address;
        }
    }

    static class JdkMemoryBasicInformation
    implements Kernel32Library.MemoryBasicInformation {
        private static final MemoryLayout layout = MemoryLayout.structLayout(ValueLayout.ADDRESS, MemoryLayout.paddingLayout(16L), ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG);
        private static final VarHandle BaseAddress$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(0L));
        private static final VarHandle RegionSize$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(2L));
        private static final VarHandle State$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(3L));
        private static final VarHandle Protect$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(4L));
        private static final VarHandle Type$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(5L));
        private final MemorySegment segment = Arena.ofAuto().allocate(layout);

        JdkMemoryBasicInformation() {
            this.segment.fill((byte)0);
        }

        @Override
        public Kernel32Library.Address BaseAddress() {
            return new JdkAddress(BaseAddress$vh.get(this.segment));
        }

        @Override
        public long RegionSize() {
            return RegionSize$vh.get(this.segment);
        }

        @Override
        public long State() {
            return State$vh.get(this.segment);
        }

        @Override
        public long Protect() {
            return Protect$vh.get(this.segment);
        }

        @Override
        public long Type() {
            return Type$vh.get(this.segment);
        }
    }

    static class JdkAddress
    implements Kernel32Library.Address {
        MemorySegment address;

        JdkAddress(MemorySegment address) {
            this.address = address;
        }

        @Override
        public Kernel32Library.Address add(long offset) {
            return new JdkAddress(MemorySegment.ofAddress(this.address.address() + offset));
        }
    }

    static class JdkJobObjectBasicLimitInformation
    implements Kernel32Library.JobObjectBasicLimitInformation {
        private static final MemoryLayout layout = MemoryLayout.structLayout(MemoryLayout.paddingLayout(16L), ValueLayout.JAVA_INT, MemoryLayout.paddingLayout(20L), ValueLayout.JAVA_INT, MemoryLayout.paddingLayout(20L)).withByteAlignment(8L);
        private static final VarHandle LimitFlags$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(1L));
        private static final VarHandle ActiveProcessLimit$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(3L));
        private final MemorySegment segment;

        JdkJobObjectBasicLimitInformation() {
            Arena arena = Arena.ofAuto();
            this.segment = arena.allocate(layout);
            this.segment.fill((byte)0);
        }

        @Override
        public void setLimitFlags(int v) {
            LimitFlags$vh.set(this.segment, v);
        }

        @Override
        public void setActiveProcessLimit(int v) {
            ActiveProcessLimit$vh.set(this.segment, v);
        }
    }
}

