/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.LinuxNativeAccess;
import org.elasticsearch.nativeaccess.MacNativeAccess;
import org.elasticsearch.nativeaccess.NativeAccessHolder;
import org.elasticsearch.nativeaccess.PosixNativeAccess;
import org.elasticsearch.nativeaccess.ProcessLimits;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.WindowsNativeAccess;
import org.elasticsearch.nativeaccess.Zstd;

public interface NativeAccess {
    public static NativeAccess instance() {
        return NativeAccessHolder.INSTANCE;
    }

    public static void onPosix(Consumer<PosixNativeAccess> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof PosixNativeAccess) {
            PosixNativeAccess posixNativeAccess = (PosixNativeAccess)nativeAccess;
            callback.accept(posixNativeAccess);
        }
    }

    public static <T> Optional<T> onPosixReturn(Function<PosixNativeAccess, T> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof PosixNativeAccess) {
            PosixNativeAccess posixNativeAccess = (PosixNativeAccess)nativeAccess;
            return Optional.of(callback.apply(posixNativeAccess));
        }
        return Optional.empty();
    }

    public static void onWindows(Consumer<WindowsNativeAccess> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof WindowsNativeAccess) {
            WindowsNativeAccess windowsNativeAccess = (WindowsNativeAccess)nativeAccess;
            callback.accept(windowsNativeAccess);
        }
    }

    public static <T> Optional<T> onWindowsReturn(Function<WindowsNativeAccess, T> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof WindowsNativeAccess) {
            WindowsNativeAccess windowsNativeAccess = (WindowsNativeAccess)nativeAccess;
            return Optional.of(callback.apply(windowsNativeAccess));
        }
        return Optional.empty();
    }

    public static void onMac(Consumer<MacNativeAccess> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof MacNativeAccess) {
            MacNativeAccess macNativeAccess = (MacNativeAccess)nativeAccess;
            callback.accept(macNativeAccess);
        }
    }

    public static <T> Optional<T> onMacReturn(Function<MacNativeAccess, T> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof MacNativeAccess) {
            MacNativeAccess macNativeAccess = (MacNativeAccess)nativeAccess;
            return Optional.of(callback.apply(macNativeAccess));
        }
        return Optional.empty();
    }

    public static void onLinux(Consumer<LinuxNativeAccess> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof LinuxNativeAccess) {
            LinuxNativeAccess linuxNativeAccess = (LinuxNativeAccess)nativeAccess;
            callback.accept(linuxNativeAccess);
        }
    }

    public static <T> Optional<T> onLinuxReturn(Function<LinuxNativeAccess, T> callback) {
        NativeAccess nativeAccess = NativeAccessHolder.INSTANCE;
        if (nativeAccess instanceof LinuxNativeAccess) {
            LinuxNativeAccess linuxNativeAccess = (LinuxNativeAccess)nativeAccess;
            return Optional.of(callback.apply(linuxNativeAccess));
        }
        return Optional.empty();
    }

    public boolean definitelyRunningAsRoot();

    public ProcessLimits getProcessLimits();

    public void tryLockMemory();

    public boolean isMemoryLocked();

    public void tryInstallExecSandbox();

    public ExecSandboxState getExecSandboxState();

    public Systemd systemd();

    public Zstd getZstd();

    public OptionalLong allocatedSizeInBytes(Path var1);

    public void tryPreallocate(Path var1, long var2);

    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions();

    public CloseableByteBuffer newSharedBuffer(int var1);

    public CloseableByteBuffer newConfinedBuffer(int var1);

    public static enum ExecSandboxState {
        NONE,
        EXISTING_THREADS,
        ALL_THREADS;

    }
}

