/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.lib;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.core.internal.provider.ProviderLocator;
import org.elasticsearch.nativeaccess.lib.NativeLibrary;

public abstract class NativeLibraryProvider {
    private final String name;
    private final Map<Class<? extends NativeLibrary>, Supplier<NativeLibrary>> libraries;

    protected NativeLibraryProvider(String name, Map<Class<? extends NativeLibrary>, Supplier<NativeLibrary>> libraries) {
        this.name = name;
        this.libraries = libraries;
        for (Class<?> libClass : NativeLibrary.class.getPermittedSubclasses()) {
            if (libraries.containsKey(libClass)) continue;
            throw new IllegalStateException(this.getClass().getSimpleName() + " missing implementation for " + libClass.getSimpleName());
        }
    }

    public static NativeLibraryProvider instance() {
        return Holder.INSTANCE;
    }

    public String getName() {
        return this.name;
    }

    public <T extends NativeLibrary> T getLibrary(Class<T> cls) {
        Supplier<NativeLibrary> libraryCtor = this.libraries.get(cls);
        NativeLibrary library = libraryCtor.get();
        assert (library != null);
        assert (cls.isAssignableFrom(library.getClass()));
        return (T)((NativeLibrary)cls.cast(library));
    }

    private static NativeLibraryProvider loadProvider() {
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 21) {
            return NativeLibraryProvider.loadJdkImpl(runtimeVersion);
        }
        return NativeLibraryProvider.loadJnaImpl();
    }

    private static NativeLibraryProvider loadJdkImpl(int runtimeVersion) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = lookup.findClass("org.elasticsearch.nativeaccess.jdk.JdkNativeLibraryProvider");
            MethodHandle constructor = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
            try {
                return constructor.invoke();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("NativeLibraryProvider for Java " + runtimeVersion + " has a bad constructor", e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new LinkageError("NativeLibraryProvider is missing for Java " + runtimeVersion, cnfe);
        }
    }

    private static NativeLibraryProvider loadJnaImpl() {
        return (NativeLibraryProvider)new ProviderLocator("native-access-jna", NativeLibraryProvider.class, "org.elasticsearch.nativeaccess.jna", Set.of()).get();
    }

    private static final class Holder {
        static final NativeLibraryProvider INSTANCE = NativeLibraryProvider.loadProvider();

        private Holder() {
        }
    }
}

