/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.KeyValuePair;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.internal.io.IOUtils;

public class MultiCommand
extends Command {
    protected final Map<String, Command> subcommands = new LinkedHashMap<String, Command>();
    private final NonOptionArgumentSpec<String> arguments = this.parser.nonOptions("command");
    private final OptionSpec<KeyValuePair> settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);

    public MultiCommand(String description, Runnable beforeMain) {
        super(description, beforeMain);
        this.parser.posixlyCorrect(true);
    }

    @Override
    protected void printAdditionalHelp(Terminal terminal) {
        this.printSubCommandList(terminal::println);
    }

    @Override
    protected void printUserException(Terminal terminal, UserException e) {
        super.printUserException(terminal, e);
        if (e instanceof MissingCommandException) {
            terminal.errorPrintln("");
            this.printSubCommandList(terminal::errorPrintln);
        }
    }

    private void printSubCommandList(Consumer<String> println) {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        println.accept("Commands");
        println.accept("--------");
        for (Map.Entry<String, Command> subcommand : this.subcommands.entrySet()) {
            println.accept(subcommand.getKey() + " - " + subcommand.getValue().description);
        }
        println.accept("");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        ArrayList<CallSite> args = new ArrayList<CallSite>(this.arguments.values(options));
        if (args.isEmpty()) {
            throw new MissingCommandException();
        }
        String subcommandName = (String)args.remove(0);
        Command subcommand = this.subcommands.get(subcommandName);
        if (subcommand == null) {
            throw new UserException(64, "Unknown command [" + subcommandName + "]");
        }
        for (KeyValuePair pair : this.settingOption.values(options)) {
            args.add((CallSite)((Object)("-E" + pair)));
        }
        subcommand.mainWithoutErrorHandling(args.toArray(new String[0]), terminal);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.subcommands.values());
    }

    static final class MissingCommandException
    extends UserException {
        MissingCommandException() {
            super(64, "Missing required command");
        }
    }
}

