/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition;

import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class UtilDecompositons_FDRM {
    public static FMatrixRMaj checkIdentity(FMatrixRMaj A, int numRows, int numCols) {
        if (A == null) {
            return CommonOps_FDRM.identity(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        CommonOps_FDRM.setIdentity((FMatrix1Row)A);
        return A;
    }

    public static FMatrixRMaj checkZeros(FMatrixRMaj A, int numRows, int numCols) {
        if (A == null) {
            return new FMatrixRMaj(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        A.zero();
        return A;
    }

    public static FMatrixRMaj checkZerosLT(FMatrixRMaj A, int numRows, int numCols) {
        if (A == null) {
            return new FMatrixRMaj(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        for (int i = 0; i < A.numRows; ++i) {
            int index = i * A.numCols;
            int end = index + Math.min(i, A.numCols);
            while (index < end) {
                A.data[index++] = 0.0f;
            }
        }
        return A;
    }

    public static FMatrixRMaj checkZerosUT(FMatrixRMaj A, int numRows, int numCols) {
        if (A == null) {
            return new FMatrixRMaj(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        int maxRows = Math.min(A.numRows, A.numCols);
        for (int i = 0; i < maxRows; ++i) {
            int index = i * A.numCols + i + 1;
            int end = i * A.numCols + A.numCols;
            while (index < end) {
                A.data[index++] = 0.0f;
            }
        }
        return A;
    }
}

