/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.chol;

import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.SpecializedOps_FDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_FDRM;
import org.ejml.dense.row.decomposition.chol.CholeskyDecompositionCommon_FDRM;
import org.ejml.dense.row.linsol.LinearSolverAbstract_FDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition_F32;

public class LinearSolverChol_FDRM
extends LinearSolverAbstract_FDRM {
    CholeskyDecompositionCommon_FDRM decomposer;
    int n;
    float[] vv;
    float[] t;

    public LinearSolverChol_FDRM(CholeskyDecompositionCommon_FDRM decomposer) {
        this.decomposer = decomposer;
    }

    public boolean setA(FMatrixRMaj A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        this._setA(A);
        if (this.decomposer.decompose(A)) {
            this.n = A.numCols;
            this.vv = this.decomposer._getVV();
            this.t = this.decomposer.getT().data;
            return true;
        }
        return false;
    }

    public double quality() {
        return SpecializedOps_FDRM.qualityTriangular((FMatrixD1)this.decomposer.getT());
    }

    public void solve(FMatrixRMaj B, FMatrixRMaj X) {
        if (B.numCols != X.numCols || B.numRows != this.n || X.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int numCols = B.numCols;
        float[] dataB = B.data;
        float[] dataX = X.data;
        if (this.decomposer.isLower()) {
            for (int j = 0; j < numCols; ++j) {
                int i;
                for (i = 0; i < this.n; ++i) {
                    this.vv[i] = dataB[i * numCols + j];
                }
                this.solveInternalL();
                for (i = 0; i < this.n; ++i) {
                    dataX[i * numCols + j] = this.vv[i];
                }
            }
        } else {
            throw new RuntimeException("Implement");
        }
    }

    private void solveInternalL() {
        TriangularSolver_FDRM.solveL(this.t, this.vv, this.n);
        TriangularSolver_FDRM.solveTranL(this.t, this.vv, this.n);
    }

    @Override
    public void invert(FMatrixRMaj inv) {
        if (inv.numRows != this.n || inv.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        if (inv.data == this.t) {
            throw new IllegalArgumentException("Passing in the same matrix that was decomposed.");
        }
        float[] a = inv.data;
        if (!this.decomposer.isLower()) {
            throw new RuntimeException("Implement");
        }
        this.setToInverseL(a);
    }

    public void setToInverseL(float[] a) {
        int k;
        float sum;
        int j;
        float el_ii;
        int i;
        for (i = 0; i < this.n; ++i) {
            el_ii = this.t[i * this.n + i];
            for (j = 0; j <= i; ++j) {
                sum = i == j ? 1.0f : 0.0f;
                for (k = i - 1; k >= j; --k) {
                    sum -= this.t[i * this.n + k] * a[j * this.n + k];
                }
                a[j * this.n + i] = sum / el_ii;
            }
        }
        for (i = this.n - 1; i >= 0; --i) {
            el_ii = this.t[i * this.n + i];
            for (j = 0; j <= i; ++j) {
                sum = i < j ? 0.0f : a[j * this.n + i];
                for (k = i + 1; k < this.n; ++k) {
                    sum -= this.t[k * this.n + i] * a[j * this.n + k];
                }
                float f = sum / el_ii;
                a[j * this.n + i] = f;
                a[i * this.n + j] = f;
            }
        }
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public CholeskyDecomposition_F32<FMatrixRMaj> getDecomposition() {
        return this.decomposer;
    }
}

