/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.linsol.chol;

import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.ComputePermutation;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.decomposition.chol.CholeskyUpLooking_DSCC;
import org.ejml.sparse.csc.misc.ApplyFillReductionPermutation;
import org.ejml.sparse.csc.misc.TriangularSolver_DSCC;

public class LinearSolverCholesky_DSCC
implements LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> {
    CholeskyUpLooking_DSCC cholesky;
    ApplyFillReductionPermutation reduce;
    DGrowArray gb = new DGrowArray();
    DGrowArray gx = new DGrowArray();
    IGrowArray gw = new IGrowArray();
    DMatrixSparseCSC tmp = new DMatrixSparseCSC(1, 1, 1);

    public LinearSolverCholesky_DSCC(CholeskyUpLooking_DSCC cholesky, ComputePermutation<DMatrixSparseCSC> fillReduce) {
        this.cholesky = cholesky;
        this.reduce = new ApplyFillReductionPermutation(fillReduce, true);
    }

    public boolean setA(DMatrixSparseCSC A) {
        DMatrixSparseCSC C = this.reduce.apply(A);
        return this.cholesky.decompose(C);
    }

    public double quality() {
        return TriangularSolver_DSCC.qualityTriangular(this.cholesky.getL());
    }

    public void solveSparse(DMatrixSparseCSC B, DMatrixSparseCSC X) {
        IGrowArray gw1 = this.cholesky.getGw();
        DMatrixSparseCSC L = this.cholesky.getL();
        this.tmp.reshape(L.numRows, B.numCols, 1);
        int[] Pinv = this.reduce.getArrayPinv();
        TriangularSolver_DSCC.solve(L, true, B, this.tmp, Pinv, this.gx, this.gw, gw1);
        TriangularSolver_DSCC.solveTran(L, true, this.tmp, X, null, this.gx, this.gw, gw1);
    }

    public void setStructureLocked(boolean locked) {
        this.cholesky.setStructureLocked(locked);
    }

    public boolean isStructureLocked() {
        return this.cholesky.isStructureLocked();
    }

    public void solve(DMatrixRMaj B, DMatrixRMaj X) {
        DMatrixSparseCSC L = this.cholesky.getL();
        int N = L.numRows;
        double[] b = TriangularSolver_DSCC.adjust(this.gb, N);
        double[] x = TriangularSolver_DSCC.adjust(this.gx, N);
        int[] Pinv = this.reduce.getArrayPinv();
        for (int col = 0; col < B.numCols; ++col) {
            int index = col;
            int i = 0;
            while (i < N) {
                b[i] = B.data[index];
                ++i;
                index += B.numCols;
            }
            if (Pinv != null) {
                CommonOps_DSCC.permuteInv(Pinv, b, x, N);
                TriangularSolver_DSCC.solveL(L, x);
                TriangularSolver_DSCC.solveTranL(L, x);
                CommonOps_DSCC.permute(Pinv, x, b, N);
            } else {
                TriangularSolver_DSCC.solveL(L, b);
                TriangularSolver_DSCC.solveTranL(L, b);
            }
            index = col;
            i = 0;
            while (i < N) {
                X.data[index] = b[i];
                ++i;
                index += X.numCols;
            }
        }
    }

    public boolean modifiesA() {
        return this.cholesky.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public <D extends DecompositionInterface> D getDecomposition() {
        return (D)this.cholesky;
    }
}

