/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.misc;

import java.util.Arrays;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.misc.ImplCommonOps_DSCC;

public class TriangularSolver_DSCC {
    public static void solveL(DMatrixSparseCSC L, double[] x) {
        int N = L.numCols;
        int idx0 = L.col_idx[0];
        for (int col = 0; col < N; ++col) {
            int idx1 = L.col_idx[col + 1];
            int n = col;
            double d = x[n] / L.nz_values[idx0];
            x[n] = d;
            double x_j = d;
            for (int i = idx0 + 1; i < idx1; ++i) {
                int row;
                int n2 = row = L.nz_rows[i];
                x[n2] = x[n2] - L.nz_values[i] * x_j;
            }
            idx0 = idx1;
        }
    }

    public static void solveU(DMatrixSparseCSC U, double[] x) {
        int N = U.numCols;
        int idx1 = U.col_idx[N];
        for (int col = N - 1; col >= 0; --col) {
            int idx0 = U.col_idx[col];
            int n = col;
            double d = x[n] / U.nz_values[idx1 - 1];
            x[n] = d;
            double x_j = d;
            for (int i = idx0; i < idx1 - 1; ++i) {
                int row;
                int n2 = row = U.nz_rows[i];
                x[n2] = x[n2] - U.nz_values[i] * x_j;
            }
            idx1 = idx0;
        }
    }

    public static void solve(DMatrixSparseCSC G, boolean lower, DMatrixSparseCSC B, DMatrixSparseCSC X, double[] x, int[] xi, int[] w) {
        x = ImplCommonOps_DSCC.checkDeclare(G.numRows, x);
        xi = ImplCommonOps_DSCC.checkDeclare(G.numRows, xi, false);
        w = ImplCommonOps_DSCC.checkDeclare(B.numRows * 2, w, B.numRows);
        X.nz_length = 0;
        X.col_idx[0] = 0;
        X.indicesSorted = false;
        for (int colB = 0; colB < B.numCols; ++colB) {
            int top = TriangularSolver_DSCC.solve(G, lower, B, colB, x, xi, w);
            int nz_count = X.numRows - top;
            if (X.nz_values.length < X.nz_length + nz_count) {
                X.growMaxLength(X.nz_length * 2 + nz_count, true);
            }
            int p = top;
            while (p < X.numRows) {
                X.nz_rows[X.nz_length] = xi[p];
                X.nz_values[X.nz_length] = x[xi[p]];
                ++p;
                ++X.nz_length;
            }
            X.col_idx[colB + 1] = X.nz_length;
        }
    }

    public static int solve(DMatrixSparseCSC G, boolean lower, DMatrixSparseCSC B, int colB, double[] x, int[] xi, int[] w) {
        int top;
        xi = ImplCommonOps_DSCC.checkDeclare(G.numRows, xi, false);
        w = ImplCommonOps_DSCC.checkDeclare(B.numRows * 2, w, B.numRows);
        for (int p = top = TriangularSolver_DSCC.searchNzRowsInB(G, B, colB, xi, w); p < G.numRows; ++p) {
            x[xi[p]] = 0.0;
        }
        int idxB0 = B.col_idx[colB];
        int idxB1 = B.col_idx[colB + 1];
        for (int p = idxB0; p < idxB1; ++p) {
            x[B.nz_rows[p]] = B.nz_values[p];
        }
        for (int px = top; px < G.numRows; ++px) {
            int q;
            int p;
            int j = xi[px];
            if (j < 0) continue;
            if (lower) {
                int n = j;
                x[n] = x[n] / G.nz_values[G.col_idx[j]];
                p = G.col_idx[j] + 1;
                q = G.col_idx[j + 1];
            } else {
                int n = j;
                x[n] = x[n] / G.nz_values[G.col_idx[j + 1] - 1];
                p = G.col_idx[j];
                q = G.col_idx[j + 1] - 1;
            }
            while (p < q) {
                int n = G.nz_rows[p];
                x[n] = x[n] - G.nz_values[p] * x[j];
                ++p;
            }
        }
        return top;
    }

    public static int searchNzRowsInB(DMatrixSparseCSC G, DMatrixSparseCSC B, int colB, int[] xi, int[] w) {
        if (xi.length < B.numRows) {
            throw new IllegalArgumentException("xi must be at least this long: " + B.numRows);
        }
        if (w.length < B.numRows * 2) {
            throw new IllegalArgumentException("xi must be at least this long: " + B.numRows * 2);
        }
        Arrays.fill(w, 0, B.numRows, 0);
        int idx0 = B.col_idx[colB];
        int idx1 = B.col_idx[colB + 1];
        int top = G.numRows;
        for (int i = idx0; i < idx1; ++i) {
            int rowB = B.nz_rows[i];
            if (w[rowB] != 0) continue;
            top = TriangularSolver_DSCC.searchNzRowsInB_DFS(rowB, G, top, xi, w);
        }
        return top;
    }

    private static int searchNzRowsInB_DFS(int rowB, DMatrixSparseCSC G, int top, int[] xi, int[] w) {
        int N = G.numRows;
        int head = 0;
        xi[head] = rowB;
        while (head >= 0) {
            int G_col = xi[head];
            if (w[G_col] == 0) {
                w[G_col] = 1;
                w[N + head] = G.col_idx[G_col];
            }
            boolean done = true;
            int idx0 = w[N + head];
            int idx1 = G.col_idx[G_col + 1];
            for (int j = idx0; j < idx1; ++j) {
                int jrow = G.nz_rows[j];
                if (w[jrow] != 0) continue;
                w[N + head] = j + 1;
                xi[++head] = jrow;
                done = false;
                break;
            }
            if (!done) continue;
            --head;
            xi[--top] = G_col;
        }
        return top;
    }

    public static void eliminationTree(DMatrixSparseCSC A, boolean ata, int[] parent, int[] work) {
        int m = A.numRows;
        int n = A.numCols;
        if (parent.length < n) {
            throw new IllegalArgumentException("parent must be of length N");
        }
        if (work == null) {
            work = new int[n + (ata ? m : 0)];
        }
        int ancestor = 0;
        int previous = n;
        if (ata) {
            for (int i = 0; i < m; ++i) {
                work[previous + i] = -1;
            }
        }
        for (int k = 0; k < n; ++k) {
            parent[k] = -1;
            work[ancestor + k] = -1;
            int idx0 = A.col_idx[k];
            int idx1 = A.col_idx[k + 1];
            for (int p = idx0; p < idx1; ++p) {
                int i;
                int nz_row_p = A.nz_rows[p];
                int n2 = i = ata ? work[previous + nz_row_p] : nz_row_p;
                while (i != -1 && i < k) {
                    int inext = work[ancestor + i];
                    work[ancestor + i] = k;
                    if (inext == -1) {
                        parent[i] = k;
                        break;
                    }
                    i = inext;
                }
                if (!ata) continue;
                work[previous + nz_row_p] = k;
            }
        }
    }

    public static int searchNzRowsElim(DMatrixSparseCSC A, int k, int[] parent, int[] s, int[] w) {
        int p;
        int top = A.numCols;
        int idx0 = A.col_idx[k];
        int idx1 = A.col_idx[k + 1];
        w[k] = -w[k] - 2;
        for (p = idx0; p < idx1; ++p) {
            int i = A.nz_rows[p];
            if (i > k) continue;
            int len = 0;
            while (w[i] >= 0) {
                s[len++] = i;
                w[i] = -w[i] - 2;
                i = parent[i];
            }
            while (len > 0) {
                s[--top] = s[--len];
            }
        }
        for (p = top; p < A.numCols; ++p) {
            w[s[p]] = -w[s[p]] - 2;
        }
        w[k] = -w[k] - 2;
        return top;
    }
}

