/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import org.ejml.UtilEjml;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.CommonOps_DSCC;

public class MatrixFeatures_DSCC {
    public static boolean isEquals(DMatrixSparseCSC a, DMatrixSparseCSC b) {
        if (!a.indicesSorted || !b.indicesSorted) {
            throw new IllegalArgumentException("Inputs must have sorted indices");
        }
        if (!MatrixFeatures_DSCC.isSameStructure(a, b)) {
            return false;
        }
        for (int i = 0; i < a.nz_length; ++i) {
            if (a.nz_values[i] == b.nz_values[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(DMatrixSparseCSC a, DMatrixSparseCSC b, double tol) {
        if (!a.indicesSorted || !b.indicesSorted) {
            throw new IllegalArgumentException("Inputs must have sorted indices");
        }
        if (!MatrixFeatures_DSCC.isSameStructure(a, b)) {
            return false;
        }
        for (int i = 0; i < a.nz_length; ++i) {
            if (!(Math.abs(a.nz_values[i] - b.nz_values[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualsSort(DMatrixSparseCSC a, DMatrixSparseCSC b, double tol) {
        if (!a.indicesSorted) {
            a.sortIndices(null);
        }
        if (!b.indicesSorted) {
            b.sortIndices(null);
        }
        if (!MatrixFeatures_DSCC.isSameStructure(a, b)) {
            return false;
        }
        for (int i = 0; i < a.nz_length; ++i) {
            if (!(Math.abs(a.nz_values[i] - b.nz_values[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameStructure(DMatrixSparseCSC a, DMatrixSparseCSC b) {
        if (a.numRows == b.numRows && a.numCols == b.numCols && a.nz_length == b.nz_length) {
            int i;
            for (i = 0; i <= a.numCols; ++i) {
                if (a.col_idx[i] == b.col_idx[i]) continue;
                return false;
            }
            for (i = 0; i < a.nz_length; ++i) {
                if (a.nz_rows[i] == b.nz_rows[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasUncountable(DMatrixSparseCSC A) {
        for (int i = 0; i < A.nz_length; ++i) {
            if (!UtilEjml.isUncountable((double)A.nz_values[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isZeros(DMatrixSparseCSC A, double tol) {
        for (int i = 0; i < A.nz_length; ++i) {
            if (!(Math.abs(A.nz_values[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentity(DMatrixSparseCSC A, double tol) {
        if (A.numCols != A.numRows) {
            return false;
        }
        if (A.nz_length != A.numCols) {
            return false;
        }
        for (int i = 1; i <= A.numCols; ++i) {
            if (A.col_idx[i] != i) {
                return false;
            }
            if (!(Math.abs(A.nz_values[i - 1] - 1.0) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerTriangle(DMatrixSparseCSC A, int hessenberg, double tol) {
        if (A.numCols != A.numRows) {
            return false;
        }
        if (A.nz_length < A.numCols - hessenberg) {
            return false;
        }
        for (int col = 0; col < A.numCols; ++col) {
            int idx0 = A.col_idx[col];
            int idx1 = A.col_idx[col + 1];
            if (col >= hessenberg) {
                if (idx0 == idx1) {
                    return false;
                }
                if (A.nz_rows[idx0] != Math.max(0, col - hessenberg)) {
                    return false;
                }
            }
            if (col - hessenberg < 0 || !(Math.abs(A.nz_values[idx0]) <= tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTranspose(DMatrixSparseCSC A, DMatrixSparseCSC B, double tol) {
        if (A.numCols != B.numRows || A.numRows != B.numCols) {
            return false;
        }
        if (A.nz_length != B.nz_length) {
            return false;
        }
        if (!A.indicesSorted) {
            throw new IllegalArgumentException("A must have sorted indicies");
        }
        DMatrixSparseCSC Btran = new DMatrixSparseCSC(B.numCols, B.numRows, B.nz_length);
        CommonOps_DSCC.transpose(B, Btran, null);
        Btran.sortIndices(null);
        for (int i = 0; i < B.nz_length; ++i) {
            if (A.nz_rows[i] != Btran.nz_rows[i]) {
                return false;
            }
            if (!(Math.abs(A.nz_values[i] - Btran.nz_values[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVector(DMatrixSparseCSC a) {
        return a.numCols == 1 && a.numRows > 1 || a.numRows == 1 && a.numCols > 1;
    }
}

