/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.block.linsol.qr;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRBlock;
import org.ejml.data.DSubmatrixD1;
import org.ejml.dense.block.MatrixOps_DDRB;
import org.ejml.dense.block.TriangularSolver_DDRB;
import org.ejml.dense.block.decomposition.qr.QRDecompositionHouseholder_DDRB;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;

public class QrHouseHolderSolver_DDRB
implements LinearSolver<DMatrixRBlock> {
    protected QRDecompositionHouseholder_DDRB decomposer = new QRDecompositionHouseholder_DDRB();
    protected DMatrixRBlock QR;

    public QrHouseHolderSolver_DDRB() {
        this.decomposer.setSaveW(false);
    }

    public boolean setA(DMatrixRBlock A) {
        if (A.numRows < A.numCols) {
            throw new IllegalArgumentException("Number of rows must be more than or equal to the number of columns.  Can't solve an underdetermined system.");
        }
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.QR = this.decomposer.getQR();
        return true;
    }

    public double quality() {
        return SpecializedOps_DDRM.qualityTriangular((DMatrixD1)this.decomposer.getQR());
    }

    public void solve(DMatrixRBlock B, DMatrixRBlock X) {
        if (B.numCols != X.numCols) {
            throw new IllegalArgumentException("Columns of B and X do not match");
        }
        if (this.QR.numCols != X.numRows) {
            throw new IllegalArgumentException("Rows in X do not match the columns in A");
        }
        if (this.QR.numRows != B.numRows) {
            throw new IllegalArgumentException("Rows in B do not match the rows in A.");
        }
        if (B.blockLength != this.QR.blockLength || X.blockLength != this.QR.blockLength) {
            throw new IllegalArgumentException("All matrices must have the same block length.");
        }
        this.decomposer.applyQTran(B);
        MatrixOps_DDRB.extractAligned(B, X);
        int M = Math.min(this.QR.numRows, this.QR.numCols);
        TriangularSolver_DDRB.solve(this.QR.blockLength, true, new DSubmatrixD1((DMatrixD1)this.QR, 0, M, 0, M), new DSubmatrixD1((DMatrixD1)X), false);
    }

    public void invert(DMatrixRBlock A_inv) {
        int M = Math.min(this.QR.numRows, this.QR.numCols);
        if (A_inv.numRows != M || A_inv.numCols != M) {
            throw new IllegalArgumentException("A_inv must be square an have dimension " + M);
        }
        MatrixOps_DDRB.setIdentity(A_inv);
        this.decomposer.applyQTran(A_inv);
        TriangularSolver_DDRB.solve(this.QR.blockLength, true, new DSubmatrixD1((DMatrixD1)this.QR, 0, M, 0, M), new DSubmatrixD1((DMatrixD1)A_inv), false);
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return true;
    }

    public QRDecomposition<DMatrixRBlock> getDecomposition() {
        return this.decomposer;
    }
}

