/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.xmlencoding;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.xml.JAXBUtil;
import com.nedap.archie.xml.adapters.DateTimeXmlAdapter;
import com.nedap.archie.xml.adapters.DateXmlAdapter;
import com.nedap.archie.xml.adapters.TimeXmlAdapter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.ehrbase.openehr.sdk.serialisation.RMDataFormat;
import org.ehrbase.openehr.sdk.serialisation.exception.MarshalException;
import org.ehrbase.openehr.sdk.serialisation.exception.UnmarshalException;
import org.ehrbase.openehr.sdk.serialisation.xmlencoding.SdkDateTimeXmlAdapter;
import org.ehrbase.openehr.sdk.serialisation.xmlencoding.SdkDateXmlAdapter;
import org.ehrbase.openehr.sdk.serialisation.xmlencoding.SdkTimeXmlAdapter;
import org.ehrbase.openehr.sdk.util.SnakeCase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class CanonicalXML
implements RMDataFormat {
    private static final String NAMESPACE = "";

    @Override
    public String marshal(RMObject rmObject) {
        return this.marshal(rmObject, true);
    }

    public String marshal(RMObject rmObject, Boolean withHeader) {
        StringWriter stringWriter = new StringWriter();
        try {
            Marshaller marshaller = JAXBUtil.getArchieJAXBContext().createMarshaller();
            marshaller.setAdapter(DateTimeXmlAdapter.class, (XmlAdapter)new SdkDateTimeXmlAdapter());
            marshaller.setAdapter(DateXmlAdapter.class, (XmlAdapter)new SdkDateXmlAdapter());
            marshaller.setAdapter(TimeXmlAdapter.class, (XmlAdapter)new SdkTimeXmlAdapter());
            marshaller.setProperty("jaxb.fragment", (Object)(withHeader == false ? 1 : 0));
            if (rmObject.getClass().getAnnotation(XmlRootElement.class) == null) {
                QName qName = new QName(null, new SnakeCase(rmObject.getClass().getSimpleName()).camelToSnake());
                JAXBElement root = new JAXBElement(qName, RMObject.class, (Object)rmObject);
                marshaller.marshal((Object)root, (Writer)stringWriter);
            } else {
                marshaller.marshal((Object)rmObject, (Writer)stringWriter);
            }
        }
        catch (JAXBException e) {
            throw new MarshalException(e.getMessage(), e);
        }
        return stringWriter.toString();
    }

    public String marshalInline(RMObject rmObject, QName qName) {
        try {
            JAXBElement root = new JAXBElement(qName, RMObject.class, (Object)rmObject);
            Marshaller marshaller = JAXBUtil.getArchieJAXBContext().createMarshaller();
            marshaller.setAdapter(DateTimeXmlAdapter.class, (XmlAdapter)new SdkDateTimeXmlAdapter());
            marshaller.setAdapter(DateXmlAdapter.class, (XmlAdapter)new SdkDateXmlAdapter());
            marshaller.setAdapter(TimeXmlAdapter.class, (XmlAdapter)new SdkTimeXmlAdapter());
            DOMResult res = new DOMResult();
            marshaller.marshal((Object)root, (Result)res);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", NAMESPACE);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", NAMESPACE);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            Node rootNode = res.getNode().getFirstChild();
            NodeList childNodes = rootNode.getChildNodes();
            StringWriter stringWriter = new StringWriter();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                transformer.transform(new DOMSource(childNodes.item(i)), new StreamResult(stringWriter));
            }
            return stringWriter.toString();
        }
        catch (JAXBException | TransformerException e) {
            throw new MarshalException(e.getMessage(), e);
        }
    }

    @Override
    public <T extends RMObject> T unmarshal(String value, Class<T> clazz) {
        RMObject composition;
        try {
            Unmarshaller unmarshaller = JAXBUtil.getArchieJAXBContext().createUnmarshaller();
            unmarshaller.setAdapter(DateTimeXmlAdapter.class, (XmlAdapter)new SdkDateTimeXmlAdapter());
            unmarshaller.setAdapter(DateXmlAdapter.class, (XmlAdapter)new SdkDateXmlAdapter());
            unmarshaller.setAdapter(TimeXmlAdapter.class, (XmlAdapter)new SdkTimeXmlAdapter());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            NamespaceFilter filter = new NamespaceFilter();
            filter.setParent(xr);
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            filter.setContentHandler((ContentHandler)unmarshallerHandler);
            filter.parse(new InputSource(IOUtils.toInputStream((String)value, (Charset)StandardCharsets.UTF_8)));
            composition = (RMObject)unmarshallerHandler.getResult();
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
        return (T)composition;
    }

    private class NamespaceFilter
    extends XMLFilterImpl {
        private NamespaceFilter() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(CanonicalXML.NAMESPACE, localName, qName);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl attributesImpl = new AttributesImpl(atts);
            super.startElement(CanonicalXML.NAMESPACE, localName, qName, attributesImpl);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!prefix.equals(CanonicalXML.NAMESPACE)) {
                super.startPrefixMapping(prefix, uri);
            }
        }
    }
}

