/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAuditDetails;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.CareEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.InstructionDetails;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datastructures.ItemList;
import com.nedap.archie.rm.datastructures.ItemSingle;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datastructures.ItemTable;
import com.nedap.archie.rm.datastructures.ItemTree;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.Walker;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.defaultinserter.DefaultValueInserter;
import org.ehrbase.openehr.sdk.util.reflection.ReflectionHelper;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.parser.NodeId;
import org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder.WebTemplateSkeletonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToCompositionWalker<T>
extends Walker<T> {
    private static final Map<Class<?>, DefaultValueInserter> DEFAULT_VALUE_INSERTER_MAP = ReflectionHelper.buildMap(DefaultValueInserter.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void postHandle(Context<T> context) {
        RMObject currentRM = context.getRmObjectDeque().peek();
        WebTemplateNode currentNode = context.getNodeDeque().peek();
        if (currentRM instanceof Locatable) {
            Locatable locatable = (Locatable)currentRM;
            NodeId nodeId = new NodeId(Objects.requireNonNull(currentNode).getNodeId());
            if (nodeId.isArchetypeId()) {
                Archetyped archetyped = new Archetyped();
                archetyped.setArchetypeId(new ArchetypeID(nodeId.getNodeId()));
                archetyped.setRmVersion("1.0.4");
                locatable.setArchetypeDetails(archetyped);
                locatable.setArchetypeNodeId(nodeId.getNodeId());
                if (currentRM instanceof Composition) {
                    Composition composition = (Composition)currentRM;
                    TemplateId templateId = new TemplateId();
                    templateId.setValue(context.getTemplateId());
                    Archetyped archetypeDetails = composition.getArchetypeDetails();
                    archetypeDetails.setTemplateId(templateId);
                }
            }
        }
        this.normalise(currentRM);
    }

    private void normalise(RMObject currentRM) {
        Cluster cluster;
        ItemTree itemTree;
        ItemTable itemTable;
        ItemList itemList;
        ItemSingle itemSingle;
        InstructionDetails instructionDetails;
        EventContext eventContext;
        AdminEntry adminEntry;
        FeederAuditDetails feederAuditDetails;
        Evaluation evaluation;
        Action action;
        CareEntry careEntry;
        if (currentRM instanceof CareEntry && Optional.of(careEntry = (CareEntry)currentRM).map(CareEntry::getProtocol).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            careEntry.setProtocol(null);
        }
        if (currentRM instanceof Observation) {
            Observation observation = (Observation)currentRM;
            if (Optional.of(observation).map(Observation::getState).map(History::getEvents).filter(this::isNotEmpty).isEmpty()) {
                observation.setState(null);
            }
            if (Optional.of(observation).map(Observation::getData).map(History::getEvents).filter(this::isNotEmpty).isEmpty()) {
                observation.setData(null);
            }
        }
        if (currentRM instanceof Action && Optional.of(action = (Action)currentRM).map(Action::getDescription).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            action.setDescription(null);
        }
        if (currentRM instanceof Evaluation && Optional.of(evaluation = (Evaluation)currentRM).map(Evaluation::getData).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            evaluation.setData(null);
        }
        if (currentRM instanceof FeederAuditDetails && Optional.of(feederAuditDetails = (FeederAuditDetails)currentRM).map(FeederAuditDetails::getOtherDetails).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            feederAuditDetails.setOtherDetails(null);
        }
        if (currentRM instanceof AdminEntry && Optional.of(adminEntry = (AdminEntry)currentRM).map(AdminEntry::getData).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            adminEntry.setData(null);
        }
        if (currentRM instanceof EventContext && Optional.of(eventContext = (EventContext)currentRM).map(EventContext::getOtherContext).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            eventContext.setOtherContext(null);
        }
        if (currentRM instanceof InstructionDetails && Optional.of(instructionDetails = (InstructionDetails)currentRM).map(InstructionDetails::getWfDetails).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
            instructionDetails.setWfDetails(null);
        }
        if (currentRM instanceof Event) {
            Event event = (Event)currentRM;
            if (Optional.of(event).map(Event::getState).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
                event.setState(null);
            }
            if (Optional.of(event).map(Event::getData).map(ItemStructure::getItems).filter(this::isNotEmpty).isEmpty()) {
                event.setData(null);
            }
        }
        if (currentRM instanceof ItemSingle && !this.isNotEmpty((Item)(itemSingle = (ItemSingle)currentRM).getItem())) {
            itemSingle.setItem(null);
        }
        if (currentRM instanceof ItemList && (itemList = (ItemList)currentRM).getItems() != null) {
            itemList.setItems(itemList.getItems().stream().filter(this::isNotEmpty).collect(Collectors.toList()));
        }
        if (currentRM instanceof ItemTable && (itemTable = (ItemTable)currentRM).getRows() != null) {
            itemTable.setRows(itemTable.getRows().stream().filter(this::isNotEmpty).collect(Collectors.toList()));
        }
        if (currentRM instanceof ItemTree && (itemTree = (ItemTree)currentRM).getItems() != null) {
            itemTree.setItems(itemTree.getItems().stream().filter(this::isNotEmpty).collect(Collectors.toList()));
        }
        if (currentRM instanceof Cluster && (cluster = (Cluster)currentRM).getItems() != null) {
            cluster.setItems(cluster.getItems().stream().filter(this::isNotEmpty).collect(Collectors.toList()));
        }
    }

    private boolean isNotEmpty(Item item) {
        if (item instanceof Element) {
            Element element = (Element)item;
            return element.getValue() != null || element.getNullFlavour() != null;
        }
        if (item instanceof Cluster) {
            Cluster cluster = (Cluster)item;
            return !CollectionUtils.isEmpty((Collection)cluster.getItems());
        }
        return true;
    }

    private boolean isNotEmpty(Collection<?> items) {
        return items != null && items.stream().anyMatch(Objects::nonNull);
    }

    @Override
    protected Object extractRMChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice, Integer count) {
        Object newChild = WebTemplateSkeletonBuilder.build((WebTemplateNode)childNode, (boolean)false, Object.class);
        WebTemplateSkeletonBuilder.insert((WebTemplateNode)currentNode, (RMObject)currentRM, (WebTemplateNode)childNode, (Object)newChild);
        return this.wrap(newChild);
    }

    @Override
    protected ImmutablePair<T, RMObject> extractPair(Context<T> context, WebTemplateNode currentNode, Map<String, List<WebTemplateNode>> choices, WebTemplateNode childNode, Integer i) {
        RMObject currentChild = null;
        Object childObject = null;
        childObject = this.extract(context, childNode, choices.containsKey(childNode.getAqlPath()), i);
        if (childObject != null) {
            boolean isChoice = choices.containsKey(childNode.getAqlPath());
            if (currentNode.getRmType().equals("ELEMENT") && childNode.getRmType().equals("DV_CODED_TEXT") && childNode.getInputs().stream().anyMatch(in -> "other".equals(in.getSuffix()))) {
                isChoice = true;
            }
            currentChild = (RMObject)this.extractRMChild(context.getRmObjectDeque().peek(), currentNode, childNode, isChoice, i);
        }
        return new ImmutablePair(childObject, currentChild);
    }

    @Override
    protected void insertDefaults(Context<T> context) {
        ArrayList<DefaultValueInserter> postprocessor = new ArrayList<DefaultValueInserter>();
        for (Class<?> currentClass = context.getRmObjectDeque().peek().getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!DEFAULT_VALUE_INSERTER_MAP.containsKey(currentClass)) continue;
            postprocessor.add(DEFAULT_VALUE_INSERTER_MAP.get(currentClass));
        }
        postprocessor.forEach(p -> p.insert(context.getRmObjectDeque().peek(), context.getDefaultValues(), context.getNodeDeque().peek()));
    }
}

