/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.jsonencoding;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTemporal;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractDvTemporalSerializer<V, T extends DvTemporal<T, ?>>
extends JsonSerializer<T> {
    protected abstract String typeName();

    protected abstract String format(V var1);

    public void serialize(T temporal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.toJson(jsonGenerator, temporal);
    }

    public void serializeWithType(T temporal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSer) throws IOException {
        this.toJson(jsonGenerator, temporal);
    }

    private void toJson(JsonGenerator jsonGenerator, T temporal) throws IOException {
        Object value = ((SingleValuedDataValue)temporal).getValue();
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("_type", this.typeName());
        if (value != null) {
            jsonGenerator.writeStringField("value", this.format(value));
        }
        this.writeDvTemporal(jsonGenerator, (DvTemporal<T, ?>)temporal, (ObjectMapper)jsonGenerator.getCodec());
        jsonGenerator.writeEndObject();
    }

    protected void writeDvTemporal(JsonGenerator jsonGenerator, DvTemporal<T, ?> dvTemporal, ObjectMapper mapper) throws IOException {
        if (dvTemporal.getNormalStatus() != null) {
            jsonGenerator.writeFieldName("normal_status");
            jsonGenerator.writeRawValue(mapper.writeValueAsString((Object)dvTemporal.getNormalStatus()));
        }
        if (dvTemporal.getNormalRange() != null) {
            jsonGenerator.writeFieldName("normal_range");
            jsonGenerator.writeRawValue(mapper.writeValueAsString((Object)dvTemporal.getNormalRange()));
        }
        if (!CollectionUtils.isEmpty((Collection)dvTemporal.getOtherReferenceRanges())) {
            jsonGenerator.writeFieldName("other_reference_ranges");
            jsonGenerator.writeRawValue(mapper.writeValueAsString((Object)dvTemporal.getOtherReferenceRanges()));
        }
        if (dvTemporal.getMagnitudeStatus() != null) {
            jsonGenerator.writeFieldName("magnitude_status");
            jsonGenerator.writeRawValue(mapper.writeValueAsString((Object)dvTemporal.getMagnitudeStatus()));
        }
        if (dvTemporal.getNormalStatus() != null) {
            jsonGenerator.writeFieldName("accuracy");
            jsonGenerator.writeRawValue(mapper.writeValueAsString((Object)dvTemporal.getAccuracy()));
        }
    }
}

