/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.jsonencoding;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTemporal;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDvTemporalDeserializer<V, T extends DvTemporal<T, ?>>
extends JsonDeserializer<T> {
    abstract T createInstance();

    abstract V parseValue(String var1);

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        T result = this.createInstance();
        JsonNode rootNode = (JsonNode)p.readValueAsTree();
        if (rootNode.isTextual()) {
            ((SingleValuedDataValue)result).setValue(this.parseValue(rootNode.textValue()));
        } else if (rootNode.isObject()) {
            Iterator fieldsIterator = rootNode.fields();
            block21: while (fieldsIterator.hasNext()) {
                Map.Entry nodeEntry = (Map.Entry)fieldsIterator.next();
                if (((JsonNode)nodeEntry.getValue()).isNull()) continue;
                try {
                    switch ((String)nodeEntry.getKey()) {
                        case "normal_status": {
                            result.setNormalStatus((CodePhrase)ctxt.readTreeAsValue((JsonNode)nodeEntry.getValue(), CodePhrase.class));
                            break;
                        }
                        case "normal_range": {
                            result.setNormalRange((DvInterval)ctxt.readTreeAsValue((JsonNode)nodeEntry.getValue(), ctxt.getTypeFactory().constructType(new TypeReference<DvInterval<T>>(){})));
                            break;
                        }
                        case "other_reference_ranges": {
                            result.setOtherReferenceRanges((List)ctxt.readTreeAsValue((JsonNode)nodeEntry.getValue(), ctxt.getTypeFactory().constructType(new TypeReference<List<ReferenceRange<T>>>(){})));
                            break;
                        }
                        case "magnitude_status": {
                            result.setMagnitudeStatus(((JsonNode)nodeEntry.getValue()).textValue());
                            break;
                        }
                        case "accuracy": {
                            result.setAccuracy((DvDuration)ctxt.readTreeAsValue((JsonNode)nodeEntry.getValue(), DvDuration.class));
                            break;
                        }
                        case "value": {
                            ((SingleValuedDataValue)result).setValue(this.parseValue(((JsonNode)nodeEntry.getValue()).textValue()));
                            break;
                        }
                        case "magnitude": 
                        case "_type": {
                            break;
                        }
                        default: {
                            if (!ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) continue block21;
                            throw new JsonMappingException("Property \"" + (String)nodeEntry.getKey() + "\" is not part of " + result.getClass().getSimpleName());
                        }
                    }
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, result, (String)((String)nodeEntry.getKey()));
                }
            }
        }
        return result;
    }
}

