/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.AbstractRMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;
import org.threeten.extra.PeriodDuration;

public class DvDurationRMUnmarshaller
extends AbstractRMUnmarshaller<DvDuration> {
    public Class<DvDuration> getAssociatedClass() {
        return DvDuration.class;
    }

    @Override
    public void handle(String currentTerm, DvDuration rmObject, Map<FlatPathDto, String> currentValues, Context<Map<FlatPathDto, String>> context, Set<String> consumedPaths) {
        this.setValue(currentTerm, null, currentValues, s -> {
            if (s != null) {
                rmObject.setValue(DateTimeParsers.parseDurationValue((String)s));
            }
        }, String.class, consumedPaths);
        if (rmObject.getValue() == null) {
            Period year = Period.ofYears(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "year"));
            Period month = Period.ofMonths(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "month"));
            Period week = Period.ofWeeks(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "week"));
            Period day = Period.ofDays(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "day"));
            Period totalPeriod = Period.from(year).plus(month).plus(week).plus(day);
            Duration hour = Duration.ofHours(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "hour").intValue());
            Duration minute = Duration.ofHours(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "minute").intValue());
            Duration second = Duration.ofHours(this.getDurationComponent(currentTerm, currentValues, consumedPaths, "second").intValue());
            Duration totalDuration = Duration.from(hour).plus(minute).plus(second);
            rmObject.setValue((TemporalAmount)PeriodDuration.of((Period)totalPeriod, (Duration)totalDuration));
        }
    }

    private Integer getDurationComponent(String currentTerm, Map<FlatPathDto, String> currentValues, Set<String> consumedPaths, String propertyName) {
        AtomicReference slot = new AtomicReference();
        this.setValue(currentTerm, propertyName, currentValues, s -> {
            if (s != null) {
                slot.set(Integer.parseInt(s));
            }
        }, String.class, consumedPaths);
        return Optional.ofNullable((Integer)slot.get()).orElse(0);
    }
}

