/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.NullFlavour;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class ElementPostprocessor
extends AbstractUnmarshalPostprocessor<Element> {
    @Override
    public void process(String term, Element rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        Map<FlatPathDto, String> reasonValues = FlatHelper.filter(values, term + "/_null_reason", false);
        if (!reasonValues.isEmpty()) {
            if (FlatHelper.isExactlyDvCodedText(reasonValues, term + "_null_reason")) {
                rmObject.setNullReason((DvText)new DvCodedText());
            } else {
                rmObject.setNullReason(new DvText());
            }
            this.handleRmAttribute(term, (RMObject)rmObject.getNullReason(), reasonValues, consumedPaths, context, "null_reason");
        }
        this.setValue(term + "/_null_flavour", "value", values, s -> {
            if (StringUtils.isNotBlank((CharSequence)s)) {
                rmObject.setNullFlavour(FlatHelper.findEnumValueOrThrow(s, NullFlavour.class).toCodedText());
            }
        }, String.class, consumedPaths);
        this.setValue(term + "/_null_flavour", "code", values, s -> {
            if (StringUtils.isNotBlank((CharSequence)s)) {
                rmObject.setNullFlavour(FlatHelper.findEnumValueOrThrow(s, NullFlavour.class).toCodedText());
            }
        }, String.class, consumedPaths);
        FlatHelper.consumeAllMatching(term + "/_null_flavour|terminology", values, consumedPaths, false);
        if (rmObject.getNullFlavour() != null) {
            rmObject.setValue(null);
            FlatHelper.consumeAllMatching(term, values, consumedPaths, false);
        }
    }

    public Class<Element> getAssociatedClass() {
        return Element.class;
    }
}

