/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.StdToCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.RMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;
import org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder.WebTemplateSkeletonBuilder;

public class DvOrderedPostprocessor
extends AbstractUnmarshalPostprocessor<DvOrdered> {
    @Override
    public void process(String term, DvOrdered rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        this.handleNormalRange(values, consumedPaths, context, term + "/_normal_range", arg_0 -> ((DvOrdered)rmObject).setNormalRange(arg_0));
        FlatHelper.extractMultiValued(term, "_other_reference_ranges", values).forEach((k, v) -> {
            ReferenceRange referenceRange = new ReferenceRange();
            rmObject.addOtherReferenceRange(referenceRange);
            Map<FlatPathDto, String> meaningValues = FlatHelper.filter(values, term + "/_other_reference_ranges:" + k + "/meaning", false);
            if (!meaningValues.isEmpty()) {
                String meaningAttributeName = "meaning";
                boolean isDvCodedText = FlatHelper.isExactlyDvCodedText(meaningValues, term + "/_other_reference_ranges:" + k + "/meaning");
                Object meaning = isDvCodedText ? new DvCodedText() : new DvText();
                referenceRange.setMeaning((DvText)meaning);
                this.callUnmarshal(term + "/_other_reference_ranges:" + k, meaningAttributeName, (RMObject)meaning, meaningValues, consumedPaths, context, context.getNodeDeque().peek().findChildById(meaningAttributeName).orElse(FlatHelper.buildDummyChild(meaningAttributeName, context.getNodeDeque().peek())));
                this.callPostProcess(term + "/_other_reference_ranges:" + k, meaningAttributeName, (RMObject)meaning, meaningValues, consumedPaths, context, context.getNodeDeque().peek().findChildById(meaningAttributeName).orElse(FlatHelper.buildDummyChild(meaningAttributeName, context.getNodeDeque().peek())));
            }
            this.handleNormalRange((Map<FlatPathDto, String>)v, consumedPaths, context, term + "/_other_reference_ranges:" + k, arg_0 -> ((ReferenceRange)referenceRange).setRange(arg_0));
        });
        this.setValue(term, "normal_status", values, s -> {
            if (s != null) {
                rmObject.setNormalStatus(new CodePhrase(new TerminologyId("openehr_normal_statuses"), s));
            }
        }, String.class, consumedPaths);
    }

    private void handleNormalRange(Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context, String term, Consumer<DvInterval> rangeConsumer) {
        Map<FlatPathDto, String> rangeValues = FlatHelper.filter(values, term, false);
        if (!rangeValues.isEmpty()) {
            DvInterval range = new DvInterval();
            rangeConsumer.accept(range);
            this.handleBorder(values, consumedPaths, context, "upper", arg_0 -> ((DvInterval)range).setUpper(arg_0), term);
            this.handleBorder(values, consumedPaths, context, "lower", arg_0 -> ((DvInterval)range).setLower(arg_0), term);
            this.callPostProcess(term, null, (RMObject)range, rangeValues, consumedPaths, context, context.getNodeDeque().peek().findChildById("range").orElse(FlatHelper.buildDummyChild("range", context.getNodeDeque().peek())));
        }
    }

    private void handleBorder(Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context, String borderName, Consumer<DvOrdered> borderConsumer, String term) {
        Map<FlatPathDto, String> borderValues = FlatHelper.filter(values, term + "/" + borderName, false);
        if (!borderValues.isEmpty()) {
            DvOrdered lower = (DvOrdered)WebTemplateSkeletonBuilder.build((WebTemplateNode)context.getNodeDeque().peek(), (boolean)false, DvOrdered.class);
            borderConsumer.accept(lower);
            RMUnmarshaller<?> rmUnmarshaller = StdToCompositionWalker.findRMUnmarshaller(lower.getClass());
            rmUnmarshaller.handle(term + "/" + borderName, lower, borderValues, context, consumedPaths);
        }
    }

    public Class<DvOrdered> getAssociatedClass() {
        return DvOrdered.class;
    }
}

