/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.openehr.sdk.serialisation.exception.UnmarshalException;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.UnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.DefaultRMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.RMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.NodeId;
import org.ehrbase.openehr.sdk.serialisation.walker.ToCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.util.reflection.ReflectionHelper;
import org.ehrbase.openehr.sdk.webtemplate.filter.Filter;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;
import org.ehrbase.openehr.sdk.webtemplate.util.WebTemplateUtils;
import org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder.WebTemplateSkeletonBuilder;

public class StdToCompositionWalker
extends ToCompositionWalker<Map<FlatPathDto, String>> {
    private static final Map<Class<?>, RMUnmarshaller> UNMARSHALLER_MAP = ReflectionHelper.buildMap(RMUnmarshaller.class);
    private static final Map<Class<?>, UnmarshalPostprocessor> POSTPROCESSOR_MAP = ReflectionHelper.buildMap(UnmarshalPostprocessor.class);
    private Set<String> consumedPaths;

    @Override
    public void walk(Composition composition, Map<FlatPathDto, String> object, WebTemplate webTemplate, DefaultValues defaultValues, String templateId) {
        this.consumedPaths = new HashSet<String>();
        if (defaultValues != null && BooleanUtils.isTrue((Boolean)defaultValues.getDefaultValue(DefaultValuePath.COMPOSER_SELF))) {
            object.put(new FlatPathDto((CharSequence)(webTemplate.getTree().getId() + "/composer|_type")), StringUtils.wrap((String)"PARTY_SELF", (char)'\"'));
        }
        super.walk(composition, object, webTemplate, defaultValues, templateId);
    }

    @Override
    protected Map<FlatPathDto, String> extract(Context<Map<FlatPathDto, String>> context, WebTemplateNode child, boolean isChoice, Integer count) {
        context.getNodeDeque().push(child);
        Integer oldCount = null;
        if (count != null) {
            oldCount = context.getCountMap().get(new NodeId(child));
            context.getCountMap().put(new NodeId(child), count);
        }
        String path = StdToCompositionWalker.buildNamePathWithElementHandling(context);
        context.getNodeDeque().remove();
        context.getCountMap().remove(new NodeId(child));
        if (oldCount != null) {
            context.getCountMap().put(new NodeId(child), oldCount);
        }
        Map<Object, String> subValues = context.getObjectDeque().peek().entrySet().stream().filter(e -> ((FlatPathDto)e.getKey()).startsWith((CharSequence)path)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (isChoice && !this.isMatchingNode(subValues, context, child, new FlatPathDto((CharSequence)path))) {
            subValues = Collections.emptyMap();
        }
        if (!subValues.isEmpty()) {
            return subValues;
        }
        return null;
    }

    public static <T> String buildNamePathWithElementHandling(Context<T> context) {
        String path;
        WebTemplateNode child = context.getNodeDeque().peek();
        if (child.getRmType().equals("ELEMENT") && context.getFlatHelper().skip(context.getNodeDeque().peek(), child)) {
            WebTemplateNode valueNode = child.getChildren().stream().filter(n -> n.getId().endsWith("value")).findAny().orElseThrow();
            context.getNodeDeque().push(valueNode);
            path = context.getFlatHelper().buildNamePath(context, true);
            context.getNodeDeque().remove();
        } else {
            path = context.getFlatHelper().buildNamePath(context, true);
        }
        return path;
    }

    @Override
    protected ImmutablePair<Map<FlatPathDto, String>, RMObject> extractPair(Context<Map<FlatPathDto, String>> context, WebTemplateNode currentNode, Map<String, List<WebTemplateNode>> choices, WebTemplateNode childNode, Integer i) {
        if (CollectionUtils.isEmpty((Collection)childNode.getChildren()) && context.getFlatHelper().skip(childNode, currentNode) || currentNode != null && context.getFlatHelper().isNonMandatoryRmAttribute(childNode, currentNode)) {
            return new ImmutablePair(null, null);
        }
        return super.extractPair(context, currentNode, choices, childNode, i);
    }

    private boolean isMatchingNode(Map<FlatPathDto, String> subValues, Context<Map<FlatPathDto, String>> context, WebTemplateNode child, FlatPathDto currentFlatPath) {
        if (child.getRmType().equals("POINT_EVENT")) {
            return !FlatHelper.isExactlyIntervalEvent(subValues, currentFlatPath.format());
        }
        if (child.getRmType().equals("INTERVAL_EVENT")) {
            return FlatHelper.isExactlyIntervalEvent(subValues, currentFlatPath.format());
        }
        if (child.getRmType().equals("PARTY_SELF")) {
            return FlatHelper.isExactlyPartySelf(subValues, currentFlatPath.format(), child);
        }
        if (child.getRmType().equals("PARTY_IDENTIFIED")) {
            return FlatHelper.isExactlyPartyIdentified(subValues, currentFlatPath.format(), child);
        }
        if (child.getRmType().equals("PARTY_RELATED")) {
            return FlatHelper.isExactlyPartyRelated(subValues, currentFlatPath.format(), child);
        }
        if (this.visitChildren(child)) {
            for (WebTemplateNode n : child.getChildren()) {
                context.getNodeDeque().push(n);
                String path = context.getFlatHelper().buildNamePath(context, true);
                context.getNodeDeque().remove();
                subValues = subValues.entrySet().stream().filter(e -> !((FlatPathDto)e.getKey()).startsWith((CharSequence)path)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return subValues.isEmpty();
        }
        if (child.getRmType().equals("DV_CODED_TEXT")) {
            return FlatHelper.isExactlyDvCodedText(subValues, currentFlatPath.format());
        }
        if (child.getRmType().equals("DV_TEXT")) {
            return !FlatHelper.isExactlyDvCodedText(subValues, currentFlatPath.format());
        }
        return true;
    }

    @Override
    protected void preHandle(Context<Map<FlatPathDto, String>> context) {
        if (!(this.isRaw(context) || this.visitChildren(context.getNodeDeque().peek()) || context.getFlatHelper().skip(context))) {
            if (context.getRmObjectDeque().peek().getClass().isAssignableFrom(DvCodedText.class) && context.getObjectDeque().peek().keySet().stream().anyMatch(k -> "other".equals(k.getLast().getAttributeName()))) {
                this.replaceRmObject(context, (RMObject)new DvText());
            }
            RMUnmarshaller<?> rmUnmarshaller = StdToCompositionWalker.findRMUnmarshaller(context.getRmObjectDeque().peek().getClass());
            String namePath = StdToCompositionWalker.buildNamePathWithElementHandling(context);
            rmUnmarshaller.handle(namePath, context.getRmObjectDeque().peek(), context.getObjectDeque().peek(), context, this.consumedPaths);
        }
    }

    public static <T extends RMObject> RMUnmarshaller<T> findRMUnmarshaller(Class<T> aClass) {
        return UNMARSHALLER_MAP.getOrDefault(aClass, new DefaultRMUnmarshaller());
    }

    private void handleRaw(Context<Map<FlatPathDto, String>> context) {
        ObjectMapper om = ArchieObjectMapperProvider.getObjectMapper();
        try {
            Map.Entry current = (Map.Entry)context.getObjectDeque().peek().entrySet().stream().findAny().orElseThrow();
            RMObject newRmObject = new CanonicalJson().unmarshal(((String)om.readValue((String)current.getValue(), String.class)).replace("\"@class\"", "\"_type\""), RMObject.class);
            this.replaceRmObject(context, newRmObject);
            this.consumedPaths.add(((FlatPathDto)current.getKey()).format());
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e.getMessage());
        }
    }

    private void replaceRmObject(Context<Map<FlatPathDto, String>> context, RMObject newRmObject) {
        RMObject oldRM = context.getRmObjectDeque().poll();
        RMObject parentRM = context.getRmObjectDeque().peek();
        WebTemplateNode currentNode = context.getNodeDeque().poll();
        WebTemplateNode parentNode = context.getNodeDeque().peek();
        if (oldRM instanceof Element && !(newRmObject instanceof Element)) {
            WebTemplateNode valueNode = currentNode.getChildren().stream().filter(n -> n.getId().contains("value")).findAny().orElseThrow();
            WebTemplateSkeletonBuilder.insert((WebTemplateNode)currentNode, (RMObject)oldRM, (WebTemplateNode)valueNode, (Object)newRmObject);
            context.getRmObjectDeque().push(oldRM);
        } else {
            WebTemplateSkeletonBuilder.remove((WebTemplateNode)parentNode, (RMObject)parentRM, (WebTemplateNode)currentNode, (Object)oldRM);
            WebTemplateSkeletonBuilder.insert((WebTemplateNode)parentNode, (RMObject)parentRM, (WebTemplateNode)currentNode, (Object)newRmObject);
            context.getRmObjectDeque().push(newRmObject);
        }
        context.getNodeDeque().push(currentNode);
    }

    private boolean isRaw(Context<Map<FlatPathDto, String>> context) {
        if (context.getObjectDeque().peek().size() != 1) {
            return false;
        }
        Map.Entry current = (Map.Entry)context.getObjectDeque().peek().entrySet().stream().findAny().orElseThrow();
        return Objects.equals(((FlatPathDto)current.getKey()).getLast().getAttributeName(), "raw") && Objects.equals(StringUtils.removeStart((String)context.getNodeDeque().peek().getId(false), (String)"_"), StringUtils.removeStart((String)((FlatPathDto)current.getKey()).getLast().getName(), (String)"_"));
    }

    @Override
    protected void postHandle(Context<Map<FlatPathDto, String>> context) {
        super.postHandle(context);
        if (this.isRaw(context)) {
            this.handleRaw(context);
        }
        WebTemplateNode currentNode = context.getNodeDeque().peek();
        currentNode.getChildren().forEach(childNode -> {
            if (context.getFlatHelper().skip((WebTemplateNode)childNode, currentNode)) {
                context.getNodeDeque().push((WebTemplateNode)childNode);
                context.getRmObjectDeque().push(new RMObject(){});
                String path = context.getFlatHelper().buildNamePath(context, true);
                Map<FlatPathDto, String> subValues = ((Map)context.getObjectDeque().peek()).entrySet().stream().filter(e -> ((FlatPathDto)e.getKey()).startsWith((CharSequence)(path + "/_" + childNode.getId()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                context.getObjectDeque().push(subValues);
                if (this.isRaw(context)) {
                    this.handleRaw(context);
                }
                context.getNodeDeque().poll();
                context.getRmObjectDeque().poll();
                context.getObjectDeque().poll();
            }
        });
        List<UnmarshalPostprocessor<?>> postprocessor = StdToCompositionWalker.findUnmarshalPostprocessors(context.getRmObjectDeque().peek().getClass());
        String namePath = StdToCompositionWalker.buildNamePathWithElementHandling(context);
        if (Entry.class.isAssignableFrom(context.getRmObjectDeque().peek().getClass()) && ((Entry)context.getRmObjectDeque().peek()).getSubject() instanceof PartyRelated) {
            Optional.ofNullable(context.getNodeDeque().peek()).flatMap(c -> c.findChildById("subject")).flatMap(c -> c.findChildById("relationship")).stream().map(WebTemplateNode::getInputs).flatMap(Collection::stream).filter(i -> "code".equals(i.getSuffix())).map(WebTemplateInput::getList).map(l -> l.size() == 1 ? (WebTemplateInputValue)l.get(0) : null).filter(Objects::nonNull).findAny().ifPresent(v -> ((PartyRelated)((Entry)context.getRmObjectDeque().peek()).getSubject()).setRelationship(new DvCodedText(v.getLabel(), new CodePhrase(new TerminologyId("openehr"), v.getValue()))));
        }
        postprocessor.forEach(p -> p.process(namePath, context.getRmObjectDeque().peek(), (Map)context.getObjectDeque().peek(), this.consumedPaths, context));
    }

    public static <T extends RMObject> List<UnmarshalPostprocessor<T>> findUnmarshalPostprocessors(Class<T> aClass) {
        ArrayList<UnmarshalPostprocessor<T>> postprocessor = new ArrayList<UnmarshalPostprocessor<T>>();
        for (Class<T> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!POSTPROCESSOR_MAP.containsKey(currentClass)) continue;
            postprocessor.add(POSTPROCESSOR_MAP.get(currentClass));
        }
        return postprocessor;
    }

    @Override
    protected void handleInheritance(WebTemplateNode currentNode) {
        if (currentNode.getRmType().equals("ELEMENT") && WebTemplateUtils.isChoiceDvCodedTextAndDvText((WebTemplateNode)currentNode)) {
            StdToCompositionWalker.handleDVTextInternal(currentNode);
        } else {
            super.handleInheritance(currentNode);
        }
    }

    public static void handleDVTextInternal(WebTemplateNode node) {
        WebTemplateNode merged = Filter.mergeDVText((WebTemplateNode)node);
        node.getChildren().removeIf(childNode -> List.of("coded_text_value", "text_value").contains(childNode.getId()));
        node.getChildren().add(merged);
    }

    @Override
    protected int calculateSize(Context<Map<FlatPathDto, String>> context, WebTemplateNode childNode) {
        String namePath;
        Integer oldCount = context.getCountMap().get(new NodeId(childNode));
        String finalNamePath = namePath = context.getFlatHelper().buildNamePath(context, true);
        Integer count = context.getObjectDeque().peek().keySet().stream().filter(s -> s.startsWith((CharSequence)finalNamePath)).map(s -> FlatPathDto.removeStart((FlatPathDto)s, (FlatPathDto)new FlatPathDto((CharSequence)finalNamePath))).filter(n -> n != null && n.getName().equals(childNode.getId())).map(n -> Optional.ofNullable(n.getCount()).orElse(0)).sorted().reduce((first, second) -> second).map(i -> i + 1).orElse(0);
        if (oldCount != null) {
            context.getCountMap().put(new NodeId(childNode), oldCount);
        }
        return count;
    }

    public Set<String> getConsumedPaths() {
        return this.consumedPaths;
    }
}

