/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.marshal.postprocessor;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.DvURI;
import com.nedap.archie.rm.support.identification.ObjectId;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.marshal.postprocessor.AbstractMarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;

public class LocatableMarshalPostprocessor
extends AbstractMarshalPostprocessor<Locatable> {
    @Override
    public void process(String term, Locatable rmObject, Map<String, Object> values, Context<Map<String, Object>> context) {
        if ("ELEMENT".equals(context.getNodeDeque().peek().getRmType()) || !context.getFlatHelper().skip(context)) {
            this.addValue(values, term + "/_uid", null, Optional.of(rmObject).map(Locatable::getUid).map(ObjectId::getValue).orElse(null));
            if (rmObject.getLinks() != null) {
                IntStream.range(0, rmObject.getLinks().size()).forEach(i -> {
                    Link link = (Link)rmObject.getLinks().get(i);
                    String termLoop = term + "/_link:" + i;
                    this.addValue(values, termLoop, "meaning", Optional.of(link).map(Link::getMeaning).map(DvText::getValue).orElse(null));
                    this.addValue(values, termLoop, "type", Optional.of(link).map(Link::getType).map(DvText::getValue).orElse(null));
                    this.addValue(values, termLoop, "target", Optional.of(link).map(Link::getTarget).map(DvURI::getValue).orElse(null));
                });
            }
            if (rmObject.getFeederAudit() != null) {
                this.callMarshal(term, "_feeder_audit", (RMObject)rmObject.getFeederAudit(), values, context, FlatHelper.findOrBuildSubNode(context, "feeder_audit"));
                this.callPostprocess(term, "_feeder_audit", (RMObject)rmObject.getFeederAudit(), values, context, FlatHelper.findOrBuildSubNode(context, "feeder_audit"));
            }
            if (Optional.ofNullable(rmObject.getName()).map(DvText::getValue).filter(n -> !Objects.equals(context.getNodeDeque().peek().getName(), n)).isPresent()) {
                this.handleRmAttribute(term, (RMObject)rmObject.getName(), values, context, "name");
            }
        }
    }

    public Class<Locatable> getAssociatedClass() {
        return Locatable.class;
    }
}

