/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.dto;

import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Entity;
import org.ehrbase.openehr.sdk.generator.commons.annotations.OptionFor;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Path;
import org.ehrbase.openehr.sdk.generator.commons.interfaces.EnumValueSet;
import org.ehrbase.openehr.sdk.serialisation.dto.PathMatcher;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.ToCompositionWalker;
import org.ehrbase.openehr.sdk.util.exception.ClientException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoToCompositionWalker
extends ToCompositionWalker<Map<AqlPath, Object>> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private static final RMObjectCreator RM_OBJECT_CREATOR = new RMObjectCreator((ModelInfoLookup)ARCHIE_RM_INFO_LOOKUP);
    private static final PathMatcher PATH_MATCHER = new PathMatcher();
    public static final AqlPath.AqlNode ACTION_ARCHETYPE_ID = AqlPath.parse((String)"action_archetype_id").getLastNode();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected Map<AqlPath, Object> extract(Context<Map<AqlPath, Object>> context, WebTemplateNode child, boolean isChoice, Integer i) {
        Map<AqlPath, Object> subValues = this.filterValues(context, child);
        if (subValues.isEmpty()) {
            return null;
        }
        if (subValues.size() > 1) {
            if (isChoice && child.getRmType().equals("INTERVAL_EVENT")) {
                this.logger.warn("Path {} is choice but missing OptionFor", (Object)child.getAqlPath());
                return null;
            }
            return subValues;
        }
        Object value = subValues.values().stream().findAny().orElseThrow();
        if (value instanceof List && i != null) {
            value = Optional.of(value).map(List.class::cast).filter(l -> l.size() > i).map(l -> l.get(i)).orElse(null);
        }
        if (isChoice && value != null) {
            Optional<String> optionFor = Optional.of(value).map(Object::getClass).map(c -> c.getAnnotation(OptionFor.class)).map(OptionFor::value);
            if (optionFor.isEmpty()) {
                switch (child.getRmType()) {
                    case "INTERVAL_EVENT": 
                    case "DV_CODED_TEXT": {
                        value = null;
                        break;
                    }
                    case "POINT_EVENT": 
                    case "DV_TEXT": {
                        break;
                    }
                    default: {
                        this.logger.warn("Path {} is choice but {} is missing OptionFor", (Object)child.getAqlPath(), (Object)value.getClass().getSimpleName());
                        break;
                    }
                }
            } else if (optionFor.filter(s -> s.equals(child.getRmType())).isEmpty()) {
                value = null;
            }
        }
        if (value == null) {
            return null;
        }
        AqlPath path = (AqlPath)subValues.keySet().stream().findAny().orElseThrow();
        if (value.getClass().isAnnotationPresent(Entity.class) && !path.hasPath()) {
            Map<AqlPath, Object> newValues = DtoToCompositionWalker.findEntity(value).entrySet().stream().collect(Collectors.toMap(e -> path.addEnd((AqlPath)e.getKey()), Map.Entry::getValue));
            return newValues.isEmpty() ? null : newValues;
        }
        return Map.of(path, value);
    }

    private Map<AqlPath, Object> filterValues(Context<Map<AqlPath, Object>> context, WebTemplateNode child) {
        return context.getObjectDeque().peek().entrySet().stream().map(e -> new ImmutablePair((Object)PATH_MATCHER.matchesPath(context, child, (Map.Entry<AqlPath, ?>)e), e.getValue())).filter(p -> p.getLeft() != null).collect(Collectors.toMap(ImmutablePair::getLeft, ImmutablePair::getRight));
    }

    @Override
    protected void preHandle(Context<Map<AqlPath, Object>> context) {
        Map<AqlPath, Object> values = context.getObjectDeque().peek();
        for (Map.Entry<AqlPath, Object> objectEntry : values.entrySet()) {
            AqlPath aqlPath = objectEntry.getKey();
            if (aqlPath.hasPath() || "uuid".equals(aqlPath.getAttributeName())) continue;
            if (StringUtils.isNotBlank((CharSequence)aqlPath.getAttributeName())) {
                this.handleSingleValue(objectEntry.getValue(), aqlPath.getAttributeName(), null, context.getRmObjectDeque().peek());
                continue;
            }
            RMObject child = context.getRmObjectDeque().poll();
            this.handleSingleValue(objectEntry.getValue(), context.getNodeDeque().peek().getAqlPathDto().getLastNode().getName(), child, context.getRmObjectDeque().peek());
            context.getRmObjectDeque().push(child);
        }
    }

    @Override
    protected void postHandle(Context<Map<AqlPath, Object>> context) {
        super.postHandle(context);
        RMObject rmObject = context.getRmObjectDeque().peek();
        if (rmObject instanceof Activity) {
            context.getObjectDeque().peek().entrySet().stream().filter(e -> ((AqlPath)e.getKey()).getLastNode().equals((Object)ACTION_ARCHETYPE_ID)).map(Map.Entry::getValue).map(String.class::cast).findAny().ifPresent(arg_0 -> ((Activity)((Activity)rmObject)).setActionArchetypeId(arg_0));
        }
    }

    @Override
    protected int calculateSize(Context<Map<AqlPath, Object>> context, WebTemplateNode childNode) {
        Map<AqlPath, Object> values = this.filterValues(context, childNode);
        if (values.size() == 1) {
            Object value = values.values().stream().findAny().orElseThrow();
            if (value instanceof List) {
                return ((List)value).size();
            }
            return 1;
        }
        return 0;
    }

    static Map<AqlPath, Object> findEntity(Object dto) {
        return Arrays.stream(FieldUtils.getAllFields(dto.getClass())).filter(m -> m.isAnnotationPresent(Path.class)).filter(m -> DtoToCompositionWalker.readField(m, dto) != null).collect(Collectors.toMap(m -> AqlPath.parse((String)m.getAnnotation(Path.class).value()), m -> DtoToCompositionWalker.readField(m, dto)));
    }

    private static Object readField(Field field, Object dto) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), dto.getClass());
            return propertyDescriptor.getReadMethod().invoke(dto, new Object[0]);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private void handleSingleValue(Object value, String childName, Object child, Object parent) {
        if (value != null) {
            if (EnumValueSet.class.isAssignableFrom(value.getClass()) && DvCodedText.class.isAssignableFrom(parent.getClass())) {
                EnumValueSet valueSet = (EnumValueSet)value;
                DvCodedText dvCodedText = (DvCodedText)parent;
                dvCodedText.setValue(valueSet.getValue());
                dvCodedText.setDefiningCode(new CodePhrase(new TerminologyId(valueSet.getTerminologyId()), valueSet.getCode()));
            } else if (EnumValueSet.class.isAssignableFrom(value.getClass()) && DvCodedText.class.isAssignableFrom(ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getClass(), childName).getType())) {
                EnumValueSet valueSet = (EnumValueSet)value;
                DvCodedText dvCodedText = new DvCodedText();
                dvCodedText.setValue(valueSet.getValue());
                dvCodedText.setDefiningCode(new CodePhrase(new TerminologyId(valueSet.getTerminologyId()), valueSet.getCode()));
                RM_OBJECT_CREATOR.set(parent, childName, Collections.singletonList(dvCodedText));
            } else if (EnumValueSet.class.isAssignableFrom(value.getClass())) {
                EnumValueSet valueSet = (EnumValueSet)value;
                CodePhrase codePhrase = new CodePhrase(new TerminologyId(valueSet.getTerminologyId()), valueSet.getCode());
                RM_OBJECT_CREATOR.set(parent, childName, Collections.singletonList(codePhrase));
            } else {
                RMAttributeInfo attributeInfo = ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getClass(), childName);
                Class type = attributeInfo.getTypeInCollection();
                if (type.isAssignableFrom(value.getClass()) || type.equals(Boolean.TYPE) && value instanceof Boolean) {
                    if (attributeInfo.isMultipleValued()) {
                        try {
                            Object invoke = attributeInfo.getGetMethod().invoke(parent, new Object[0]);
                            if (child != null && invoke instanceof Collection) {
                                ((Collection)invoke).remove(child);
                            }
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            this.logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    RM_OBJECT_CREATOR.addElementToListOrSetSingleValues(parent, childName, Collections.singletonList(value));
                } else {
                    this.logger.warn("Unhandled child {} in {}", (Object)childName, parent);
                }
            }
        }
    }
}

