/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator.commons.aql.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.Condition;
import org.ehrbase.openehr.sdk.generator.commons.aql.containment.Containment;
import org.ehrbase.openehr.sdk.generator.commons.aql.containment.ContainmentExpression;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.AqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.AqlFieldImp;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.SelectAqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.funtion.Function;
import org.ehrbase.openehr.sdk.generator.commons.aql.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.generator.commons.aql.parameter.Parameter;
import org.ehrbase.openehr.sdk.generator.commons.aql.query.Query;
import org.ehrbase.openehr.sdk.generator.commons.aql.record.Record;
import org.ehrbase.openehr.sdk.generator.commons.aql.top.TopExpresion;

public class EntityQuery<T extends Record>
implements Query<T> {
    private final SelectAqlField<Object>[] fields;
    private final ContainmentExpression containmentExpression;
    private int variabelCount = 0;
    private int parameterCount = 0;
    private int selectCount = 0;
    private Map<Containment, String> variablesMap;
    private Condition where;
    private OrderByExpression orderByExpression;
    private TopExpresion topExpresion;
    private final Containment ehrContainment;
    private Integer limit;
    private Integer offset;
    private boolean isDistinct = false;

    protected EntityQuery(ContainmentExpression containmentExpression, SelectAqlField<?> ... fields) {
        this(containmentExpression, new HashMap<Containment, String>(), fields);
    }

    protected EntityQuery(ContainmentExpression containmentExpression, Map<Containment, String> variablesMap, SelectAqlField<?> ... fields) {
        this.variablesMap = variablesMap;
        this.ehrContainment = new Containment("EHR");
        String ehrVariableName = variablesMap.entrySet().stream().filter(e -> ((Containment)e.getKey()).getTypeName().equals("EHR")).map(Map.Entry::getValue).findAny().orElseGet(() -> this.variablesMap.values().contains("e") ? "e1" : "e");
        variablesMap.put(this.ehrContainment, ehrVariableName);
        this.ehrContainment.bindQuery(this);
        this.fields = (SelectAqlField[])Arrays.stream(fields).map(this::replace).toArray(SelectAqlField[]::new);
        this.containmentExpression = containmentExpression;
        if (containmentExpression != null) {
            containmentExpression.bindQuery(this);
        }
    }

    private SelectAqlField<Object> replace(SelectAqlField<?> selectAqlField) {
        if (selectAqlField instanceof Function) {
            List<SelectAqlField<?>> parameters = ((Function)((Object)selectAqlField)).getParameters();
            List replaceList = parameters.stream().map(this::replace).collect(Collectors.toList());
            parameters.clear();
            parameters.addAll(replaceList);
            return selectAqlField;
        }
        if (selectAqlField.getContainment().getTypeName().equals("EHR")) {
            return new AqlFieldImp<Object>(selectAqlField.getEntityClass(), selectAqlField.getPath(), selectAqlField.getName(), selectAqlField.getValueClass(), this.ehrContainment);
        }
        return selectAqlField;
    }

    @Override
    public String buildAql() {
        StringBuilder sb = new StringBuilder();
        sb.append("Select ");
        if (this.isDistinct) {
            sb.append("DISTINCT").append(" ");
        }
        if (this.topExpresion != null) {
            sb.append(this.topExpresion.buildAql()).append(" ");
        }
        ArrayList usedNames = new ArrayList();
        sb.append(Arrays.stream(this.fields).map(field -> this.buildFieldAql((SelectAqlField<?>)field, usedNames)).collect(Collectors.joining(", ")));
        sb.append(" from ");
        if (this.ehrContainment.getVariableName() != null) {
            sb.append("EHR ").append(this.buildVariabelName(this.ehrContainment));
            if (this.containmentExpression != null) {
                sb.append(" contains ");
            }
        }
        if (this.containmentExpression != null) {
            sb.append(this.containmentExpression.buildAQL());
        }
        if (this.where != null) {
            sb.append(" where ").append(this.where.buildAql(this.ehrContainment));
        }
        if (this.limit != null) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.offset != null) {
            sb.append(" OFFSET ").append(this.offset);
        }
        if (this.orderByExpression != null) {
            sb.append(" order by ").append(this.orderByExpression.buildAql(this.ehrContainment));
        }
        return sb.toString();
    }

    private String buildFieldAql(SelectAqlField<?> field, List<String> usedNames) {
        String name;
        ++this.selectCount;
        String string = name = StringUtils.isNotBlank((CharSequence)field.getName()) ? field.getName().replaceAll("[^A-Za-z0-9]", "_") : "F" + this.selectCount;
        while (usedNames.contains(name)) {
            name = name + "_F" + this.selectCount;
        }
        usedNames.add(name);
        return field.buildAQL(this.ehrContainment) + " as " + name;
    }

    @Override
    public AqlField<Object>[] fields() {
        return this.fields;
    }

    public String buildVariabelName(Containment containment) {
        return this.variablesMap.computeIfAbsent(containment, this::buildVariablesNameIntern);
    }

    private String buildVariablesNameIntern(Containment containment) {
        String name = containment.getType().getSimpleName().substring(0, 1).toLowerCase() + this.variabelCount;
        ++this.variabelCount;
        return name;
    }

    public EntityQuery<T> where(Condition where) {
        this.where = where;
        return this;
    }

    public EntityQuery<T> orderBy(OrderByExpression orderByExpression) {
        this.orderByExpression = orderByExpression;
        return this;
    }

    public EntityQuery<T> top(TopExpresion topExpresion) {
        this.topExpresion = topExpresion;
        return this;
    }

    public EntityQuery<T> distinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
        return this;
    }

    public EntityQuery<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public EntityQuery<T> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public String buildParameterName() {
        String name = "parm" + this.parameterCount;
        ++this.parameterCount;
        return name;
    }

    public <V> Parameter<V> buildParameter() {
        return new Parameter(this);
    }
}

