/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.operand;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeParseUtils;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeSerializationUtils;

public final class TemporalPrimitive
extends StringPrimitive {
    private TemporalAccessor temporal;

    public TemporalPrimitive() {
    }

    public TemporalPrimitive(String value) {
        this.setValue(value);
    }

    @Override
    @JsonProperty
    public void setValue(String value) {
        this.temporal = TemporalPrimitive.parseTemporal(value);
        super.setValue(value);
    }

    static TemporalAccessor parseTemporal(String value) {
        if (value == null) {
            return null;
        }
        if (StringUtils.containsAny((CharSequence)value, (char[])new char[]{'T', '-'})) {
            return OpenEHRDateTimeParseUtils.parseDateTime((String)value);
        }
        if (StringUtils.containsAny((CharSequence)value, (char[])new char[]{':', '.', '+', '-', 'Z'}) || value.length() == 6) {
            return OpenEHRDateTimeParseUtils.parseTime((String)value);
        }
        return OpenEHRDateTimeParseUtils.parseDateTime((String)value);
    }

    @JsonIgnore
    public TemporalAccessor getTemporal() {
        return this.temporal;
    }

    public void setTemporal(TemporalAccessor temporal) {
        this.temporal = temporal;
        if (temporal == null) {
            this.setValue((String)null);
        } else {
            this.setValue(temporal.isSupported(ChronoField.YEAR) ? OpenEHRDateTimeSerializationUtils.formatDateTime((TemporalAccessor)temporal) : OpenEHRDateTimeSerializationUtils.formatTime((TemporalAccessor)temporal));
        }
    }

    @Override
    public TemporalPrimitive frozen() {
        return (TemporalPrimitive)super.frozen();
    }
}

