/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.service;

import java.util.Collection;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CoreServiceConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.service.SimpleCoreServiceConfigurationParser;

public class DefaultSerializerConfigurationParser
implements CoreServiceConfigurationParser {
    @Override
    public <K, V> CacheConfigurationBuilder<K, V> parseServiceConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        if (cacheDefinition.keySerializer() != null) {
            Class<?> keySerializer = XmlConfiguration.getClassForName(cacheDefinition.keySerializer(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, DefaultSerializerConfiguration.Type.KEY));
        }
        if (cacheDefinition.valueSerializer() != null) {
            Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheDefinition.valueSerializer(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
        }
        return cacheBuilder;
    }

    @Override
    public CacheType unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        Collection serializerConfigs = ServiceUtils.findAmongst(DefaultSerializerConfiguration.class, (Collection)cacheConfiguration.getServiceConfigurations());
        for (DefaultSerializerConfiguration serializerConfig : serializerConfigs) {
            SimpleCoreServiceConfigurationParser.checkNoConcreteInstance(serializerConfig);
            if (serializerConfig.getType() == DefaultSerializerConfiguration.Type.KEY) {
                cacheType.getKeyType().setSerializer(serializerConfig.getClazz().getName());
                continue;
            }
            cacheType.getValueType().setSerializer(serializerConfig.getClazz().getName());
        }
        return cacheType;
    }
}

