/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.math.BigInteger;
import java.time.Duration;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.Expiry;
import org.ehcache.xml.model.ExpiryType;
import org.ehcache.xml.model.TimeType;

public class CoreCacheConfigurationParser {
    public <K, V> CacheConfigurationBuilder<K, V> parseConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Expiry parsedExpiry = cacheDefinition.expiry();
        if (parsedExpiry != null) {
            cacheBuilder = cacheBuilder.withExpiry(CoreCacheConfigurationParser.getExpiry(cacheClassLoader, parsedExpiry));
        }
        EvictionAdvisor evictionAdvisor = CoreCacheConfigurationParser.getInstanceOfName(cacheDefinition.evictionAdvisor(), cacheClassLoader, EvictionAdvisor.class);
        cacheBuilder = cacheBuilder.withEvictionAdvisor(evictionAdvisor);
        return cacheBuilder;
    }

    private static ExpiryPolicy<? super Object, ? super Object> getExpiry(ClassLoader cacheClassLoader, Expiry parsedExpiry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExpiryPolicy expiry;
        if (parsedExpiry.isUserDef()) {
            ExpiryPolicy tmpExpiry;
            try {
                tmpExpiry = CoreCacheConfigurationParser.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, ExpiryPolicy.class);
            }
            catch (ClassCastException e) {
                tmpExpiry = ExpiryUtils.convertToExpiryPolicy((org.ehcache.expiry.Expiry)CoreCacheConfigurationParser.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, org.ehcache.expiry.Expiry.class));
            }
            expiry = tmpExpiry;
        } else {
            expiry = parsedExpiry.isTTL() ? ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(parsedExpiry.value(), parsedExpiry.unit())) : (parsedExpiry.isTTI() ? ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.of(parsedExpiry.value(), parsedExpiry.unit())) : ExpiryPolicyBuilder.noExpiration());
        }
        return expiry;
    }

    static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (name == null) {
            return null;
        }
        Class<?> klazz = XmlConfiguration.getClassForName(name, classLoader);
        return klazz.asSubclass(type).newInstance();
    }

    public CacheType unparseConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        EvictionAdvisor evictionAdvisor;
        ExpiryPolicy expiryPolicy = cacheConfiguration.getExpiryPolicy();
        if (expiryPolicy != null) {
            Duration expiry = expiryPolicy.getExpiryForCreation(null, null);
            ExpiryType expiryType = new ExpiryType();
            if (expiryPolicy.equals(ExpiryPolicy.NO_EXPIRY)) {
                expiryType.withNone(new ExpiryType.None());
            } else if (expiryPolicy.equals(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)expiry))) {
                expiryType.withTtl(CoreCacheConfigurationParser.convertToTimeType(expiry));
            } else if (expiryPolicy.equals(ExpiryPolicyBuilder.timeToIdleExpiration((Duration)expiry))) {
                expiryType.withTti(CoreCacheConfigurationParser.convertToTimeType(expiry));
            } else {
                throw new XmlConfigurationException("XML translation of custom expiry policy is not supported");
            }
            cacheType.withExpiry(expiryType);
        }
        if ((evictionAdvisor = cacheConfiguration.getEvictionAdvisor()) != null) {
            throw new XmlConfigurationException("XML translation of eviction advisor is not supported");
        }
        return cacheType;
    }

    private static TimeType convertToTimeType(Duration duration) {
        return Stream.of(TimeUnit.values()).sorted(Comparator.comparing(unit -> unit.convert(duration.toNanos(), TimeUnit.NANOSECONDS))).filter(unit -> duration.equals(Duration.of(unit.convert(duration.toNanos(), TimeUnit.NANOSECONDS), ExpiryUtils.jucTimeUnitToTemporalUnit((TimeUnit)((Object)unit))))).findFirst().map(unit -> new TimeType().withValue(BigInteger.valueOf(unit.convert(duration.toNanos(), TimeUnit.NANOSECONDS))).withUnit(XmlModel.convertToXmlTimeUnit(unit))).orElseThrow(AssertionError::new);
    }
}

