/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.Unmarshaller;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.SizedResourcePoolImpl;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.CoreResourceConfigurationParser;
import org.ehcache.xml.JaxbHelper;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheEntryType;
import org.ehcache.xml.model.CacheLoaderWriterType;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.DiskStoreSettingsType;
import org.ehcache.xml.model.Expiry;
import org.ehcache.xml.model.Heap;
import org.ehcache.xml.model.ListenersConfig;
import org.ehcache.xml.model.ListenersType;
import org.ehcache.xml.model.ResourceType;
import org.ehcache.xml.model.ResourcesType;
import org.ehcache.xml.model.SizeOfEngineLimits;
import org.ehcache.xml.resource.DefaultResourceConfigurationParser;
import org.w3c.dom.Element;

public class CacheSpec
implements CacheTemplate {
    protected final List<BaseCacheType> sources;
    private final Map<URI, CacheServiceConfigurationParser<?>> serviceConfigParsers;
    CoreResourceConfigurationParser coreResourceConfigurationParser;

    public CacheSpec(Map<URI, CacheServiceConfigurationParser<?>> serviceConfigParsers, Map<URI, CacheResourceConfigurationParser> resourceConfigParsers, Unmarshaller unmarshaller, BaseCacheType ... sources) {
        this.serviceConfigParsers = serviceConfigParsers;
        this.coreResourceConfigurationParser = new DefaultResourceConfigurationParser(resourceConfigParsers, unmarshaller);
        this.sources = Arrays.asList(sources);
    }

    @Override
    public String keyType() {
        return this.key().map(CacheEntryType::getValue).orElseGet(() -> this.extract(source -> JaxbHelper.findDefaultValue(source, "keyType")).orElse(null));
    }

    @Override
    public String keySerializer() {
        return this.key().map(CacheEntryType::getSerializer).orElse(null);
    }

    @Override
    public String keyCopier() {
        return this.key().map(CacheEntryType::getCopier).orElse(null);
    }

    private Optional<CacheEntryType> key() {
        return this.extract(BaseCacheType::getKeyType);
    }

    @Override
    public String valueType() {
        return this.value().map(CacheEntryType::getValue).orElseGet(() -> this.extract(source -> JaxbHelper.findDefaultValue(source, "keyType")).orElse(null));
    }

    @Override
    public String valueSerializer() {
        return this.value().map(CacheEntryType::getSerializer).orElse(null);
    }

    @Override
    public String valueCopier() {
        return this.value().map(CacheEntryType::getCopier).orElse(null);
    }

    private Optional<CacheEntryType> value() {
        return this.extract(BaseCacheType::getValueType);
    }

    @Override
    public String evictionAdvisor() {
        return this.extract(BaseCacheType::getEvictionAdvisor).orElse(null);
    }

    @Override
    public Expiry expiry() {
        return this.extract(BaseCacheType::getExpiry).map(Expiry::new).orElse(null);
    }

    @Override
    public String loaderWriter() {
        return this.extract(BaseCacheType::getLoaderWriter).map(CacheLoaderWriterType::getClazz).orElse(null);
    }

    @Override
    public String resilienceStrategy() {
        return this.extract(BaseCacheType::getResilience).orElse(null);
    }

    @Override
    public ListenersConfig listenersConfig() {
        ListenersType base = null;
        ArrayList<ListenersType> additionals = new ArrayList<ListenersType>();
        for (BaseCacheType source : this.sources) {
            if (source.getListeners() == null) continue;
            if (base == null) {
                base = source.getListeners();
                continue;
            }
            additionals.add(source.getListeners());
        }
        return base != null ? new ListenersConfig(base, additionals.toArray(new ListenersType[0])) : null;
    }

    @Override
    public Iterable<? extends ServiceConfiguration<?>> serviceConfigs() {
        return this.sources.stream().flatMap(s -> s.getServiceConfiguration().stream()).map(this::parseCacheExtension).collect(Collectors.toMap(Object::getClass, Function.identity(), (a, b) -> a)).values();
    }

    ServiceConfiguration<?> parseCacheExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheServiceConfigurationParser<?> xmlConfigurationParser = this.serviceConfigParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parseServiceConfiguration(element);
    }

    @Override
    public Collection<ResourcePool> resourcePools() {
        return this.extract(s -> Optional.ofNullable(s.getHeap()).map(h -> Collections.singleton(this.parseResource((Heap)((Object)((Object)h))))).orElseGet(() -> Optional.ofNullable(s.getResources()).map(this::parseResources).orElse(null))).orElse(Collections.emptySet());
    }

    private Collection<ResourcePool> parseResources(ResourcesType resources) {
        ArrayList<ResourcePool> resourcePools = new ArrayList<ResourcePool>();
        for (Element resource : resources.getResource()) {
            resourcePools.add(this.parseResource(resource));
        }
        return resourcePools;
    }

    private ResourcePool parseResource(Heap resource) {
        ResourceType heapResource = (ResourceType)resource.getValue();
        return new SizedResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, heapResource.getValue().longValue(), CacheSpec.parseUnit(heapResource), false);
    }

    private static ResourceUnit parseUnit(ResourceType resourceType) {
        if (resourceType.getUnit().value().equalsIgnoreCase("entries")) {
            return EntryUnit.ENTRIES;
        }
        return MemoryUnit.valueOf((String)resourceType.getUnit().value().toUpperCase());
    }

    private ResourcePool parseResource(Element element) {
        return this.coreResourceConfigurationParser.parseResourceConfiguration(element);
    }

    @Override
    public CacheLoaderWriterType.WriteBehind writeBehind() {
        return this.extract(BaseCacheType::getLoaderWriter).map(CacheLoaderWriterType::getWriteBehind).orElse(null);
    }

    @Override
    public DiskStoreSettingsType diskStoreSettings() {
        return this.extract(BaseCacheType::getDiskStoreSettings).orElse(null);
    }

    @Override
    public SizeOfEngineLimits heapStoreSettings() {
        return this.extract(BaseCacheType::getHeapStoreSettings).map(SizeOfEngineLimits::new).orElse(null);
    }

    private <T> Optional<T> extract(Function<BaseCacheType, T> extractor) {
        return this.sources.stream().map(s -> Optional.ofNullable(extractor.apply((BaseCacheType)s))).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

