/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.ehcache.xml.DomUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class BaseConfigParser<T> {
    private final Class<T> typeParameterClass;

    public BaseConfigParser() {
        this.typeParameterClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public BaseConfigParser(Class type) {
        this.typeParameterClass = type;
    }

    private T validateConfig(Object config) {
        Objects.requireNonNull(config, "Configuration must not be null.");
        if (!this.typeParameterClass.isAssignableFrom(config.getClass())) {
            throw new IllegalArgumentException("Invalid configuration parameter passed.");
        }
        return (T)config;
    }

    private Document createDocument() {
        try {
            return DomUtil.createDocumentRoot(this.getXmlSchema());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlConfigurationException(e);
        }
    }

    protected Element unparseConfig(Object config) {
        T mainConfig = this.validateConfig(config);
        Document doc = this.createDocument();
        Element rootElement = this.createRootElement(doc, mainConfig);
        return rootElement;
    }

    protected abstract Element createRootElement(Document var1, T var2);

    protected abstract Source getXmlSchema() throws IOException;
}

