/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.DestroyInProgressException;
import org.ehcache.clustered.common.internal.exceptions.InvalidServerSideConfigurationException;
import org.ehcache.clustered.common.internal.exceptions.InvalidStoreException;
import org.ehcache.clustered.common.internal.exceptions.LifecycleException;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.ServerStoreImpl;
import org.ehcache.clustered.server.repo.StateRepositoryManager;
import org.ehcache.clustered.server.state.EhcacheStateContext;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.ehcache.clustered.server.state.EhcacheStateServiceProvider;
import org.ehcache.clustered.server.state.InvalidationTracker;
import org.ehcache.clustered.server.state.InvalidationTrackerImpl;
import org.ehcache.clustered.server.state.ResourcePageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.TreeNode;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.offheapresource.OffHeapResource;
import org.terracotta.offheapresource.OffHeapResourceIdentifier;
import org.terracotta.offheapresource.OffHeapResources;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.ValueStatistics;

public class EhcacheStateServiceImpl
implements EhcacheStateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheStateServiceImpl.class);
    private static final String STATISTICS_STORE_TAG = "Store";
    private static final String STATISTICS_POOL_TAG = "Pool";
    private static final String PROPERTY_STORE_KEY = "storeName";
    private static final String PROPERTY_POOL_KEY = "poolName";
    private static final Map<String, Function<ServerStoreImpl, ValueStatistic<Number>>> STAT_STORE_METHOD_REFERENCES = new HashMap<String, Function<ServerStoreImpl, ValueStatistic<Number>>>(11);
    private static final Map<String, Function<ResourcePageSource, ValueStatistic<Number>>> STAT_POOL_METHOD_REFERENCES = new HashMap<String, Function<ResourcePageSource, ValueStatistic<Number>>>(1);
    private final OffHeapResources offHeapResources;
    private volatile boolean configured = false;
    private volatile boolean destroyInProgress = false;
    private volatile String defaultServerResource;
    private final Map<String, ResourcePageSource> sharedResourcePools = new ConcurrentHashMap<String, ResourcePageSource>();
    private final Map<String, ResourcePageSource> dedicatedResourcePools = new ConcurrentHashMap<String, ResourcePageSource>();
    private final Map<String, ServerStoreImpl> stores = new ConcurrentHashMap<String, ServerStoreImpl>();
    private final ConcurrentMap<String, InvalidationTracker> invalidationTrackers = new ConcurrentHashMap<String, InvalidationTracker>();
    private final StateRepositoryManager stateRepositoryManager;
    private final ServerSideConfiguration configuration;
    private final KeySegmentMapper mapper;
    private final EhcacheStateServiceProvider.DestroyCallback destroyCallback;

    public EhcacheStateServiceImpl(OffHeapResources offHeapResources, ServerSideConfiguration configuration, KeySegmentMapper mapper, EhcacheStateServiceProvider.DestroyCallback destroyCallback) {
        this.offHeapResources = offHeapResources;
        this.configuration = configuration;
        this.mapper = mapper;
        this.destroyCallback = destroyCallback;
        this.stateRepositoryManager = new StateRepositoryManager();
    }

    @Override
    public ServerStoreImpl getStore(String name) {
        return this.stores.get(name);
    }

    @Override
    public ServerSideServerStore loadStore(String name, ServerStoreConfiguration serverStoreConfiguration) {
        ServerStoreImpl store = this.getStore(name);
        if (store == null) {
            LOGGER.warn("Cluster tier {} not properly recovered on fail over.", (Object)name);
        }
        this.invalidationTrackers.remove(name);
        return store;
    }

    @Override
    public Set<String> getStores() {
        return Collections.unmodifiableSet(this.stores.keySet());
    }

    public Set<String> getSharedResourcePoolIds() {
        return Collections.unmodifiableSet(this.sharedResourcePools.keySet());
    }

    public Set<String> getDedicatedResourcePoolIds() {
        return Collections.unmodifiableSet(this.dedicatedResourcePools.keySet());
    }

    @Override
    public String getDefaultServerResource() {
        return this.defaultServerResource;
    }

    @Override
    public Map<String, ServerSideConfiguration.Pool> getSharedResourcePools() {
        return this.sharedResourcePools.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResourcePageSource)e.getValue()).getPool()));
    }

    @Override
    public ResourcePageSource getSharedResourcePageSource(String name) {
        return this.sharedResourcePools.get(name);
    }

    @Override
    public ServerSideConfiguration.Pool getDedicatedResourcePool(String name) {
        ResourcePageSource resourcePageSource = this.dedicatedResourcePools.get(name);
        return resourcePageSource == null ? null : resourcePageSource.getPool();
    }

    @Override
    public ResourcePageSource getDedicatedResourcePageSource(String name) {
        return this.dedicatedResourcePools.get(name);
    }

    @Override
    public void validate(ServerSideConfiguration configuration) throws ClusterException {
        if (this.destroyInProgress) {
            throw new DestroyInProgressException("Cluster Tier Manager marked in progress for destroy - clean up by destroying or re-creating");
        }
        if (!this.isConfigured()) {
            throw new LifecycleException("Cluster tier manager is not configured");
        }
        if (configuration != null) {
            this.checkConfigurationCompatibility(configuration);
        }
    }

    private void checkConfigurationCompatibility(ServerSideConfiguration incomingConfig) throws InvalidServerSideConfigurationException {
        if (!EhcacheStateServiceImpl.nullSafeEquals(this.defaultServerResource, incomingConfig.getDefaultServerResource())) {
            throw new InvalidServerSideConfigurationException("Default resource not aligned. Client: " + incomingConfig.getDefaultServerResource() + " Server: " + this.defaultServerResource);
        }
        if (!this.sharedResourcePools.keySet().equals(incomingConfig.getResourcePools().keySet())) {
            throw new InvalidServerSideConfigurationException("Pool names not equal. Client: " + incomingConfig.getResourcePools().keySet() + " Server: " + this.sharedResourcePools.keySet().toString());
        }
        try {
            for (Map.Entry<String, ServerSideConfiguration.Pool> pool : EhcacheStateServiceImpl.resolveResourcePools(incomingConfig).entrySet()) {
                ServerSideConfiguration.Pool serverPool = this.sharedResourcePools.get(pool.getKey()).getPool();
                if (serverPool.equals((Object)pool.getValue())) continue;
                throw new InvalidServerSideConfigurationException("Pool '" + pool.getKey() + "' not equal. Client: " + pool.getValue() + " Server: " + serverPool);
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidServerSideConfigurationException(e.getMessage());
        }
    }

    private static Map<String, ServerSideConfiguration.Pool> resolveResourcePools(ServerSideConfiguration configuration) throws ConfigurationException {
        HashMap pools = new HashMap();
        for (Map.Entry e : configuration.getResourcePools().entrySet()) {
            ServerSideConfiguration.Pool pool = (ServerSideConfiguration.Pool)e.getValue();
            if (pool.getServerResource() == null) {
                if (configuration.getDefaultServerResource() == null) {
                    throw new ConfigurationException("Pool '" + (String)e.getKey() + "' has no defined server resource, and no default value was available");
                }
                pools.put(e.getKey(), new ServerSideConfiguration.Pool(pool.getSize(), configuration.getDefaultServerResource()));
                continue;
            }
            pools.put(e.getKey(), pool);
        }
        return Collections.unmodifiableMap(pools);
    }

    @Override
    public void configure() throws ConfigurationException {
        if (this.isConfigured()) {
            return;
        }
        if (this.offHeapResources == null || this.offHeapResources.getAllIdentifiers().isEmpty()) {
            throw new ConfigurationException("No offheap-resources defined - Unable to work with cluster tiers");
        }
        LOGGER.info("Configuring server-side cluster tier manager");
        this.defaultServerResource = this.configuration.getDefaultServerResource();
        if (this.defaultServerResource != null && !this.offHeapResources.getAllIdentifiers().contains(OffHeapResourceIdentifier.identifier((String)this.defaultServerResource))) {
            throw new ConfigurationException("Default server resource '" + this.defaultServerResource + "' is not defined. Available resources are: " + this.offHeapResources.getAllIdentifiers());
        }
        this.sharedResourcePools.putAll(this.createPools(EhcacheStateServiceImpl.resolveResourcePools(this.configuration)));
        this.configured = true;
    }

    private Map<String, ResourcePageSource> createPools(Map<String, ServerSideConfiguration.Pool> resourcePools) throws ConfigurationException {
        HashMap<String, ResourcePageSource> pools = new HashMap<String, ResourcePageSource>();
        try {
            for (Map.Entry<String, ServerSideConfiguration.Pool> e : resourcePools.entrySet()) {
                pools.put(e.getKey(), this.createPageSource(e.getKey(), e.getValue()));
            }
        }
        catch (RuntimeException | ConfigurationException e) {
            if (!pools.isEmpty()) {
                LOGGER.warn("Failed to create shared resource pools; reversing reservations", e);
                this.releasePools("shared", pools);
            }
            throw e;
        }
        return pools;
    }

    private ResourcePageSource createPageSource(String poolName, ServerSideConfiguration.Pool pool) throws ConfigurationException {
        ResourcePageSource pageSource;
        OffHeapResource source = this.offHeapResources.getOffHeapResource(OffHeapResourceIdentifier.identifier((String)pool.getServerResource()));
        if (source == null) {
            throw new ConfigurationException("Non-existent server side resource '" + pool.getServerResource() + "'. Available resources are: " + this.offHeapResources.getAllIdentifiers());
        }
        if (source.reserve(pool.getSize())) {
            try {
                pageSource = new ResourcePageSource(pool);
                this.registerPoolStatistics(poolName, pageSource);
            }
            catch (RuntimeException t) {
                source.release(pool.getSize());
                throw new ConfigurationException("Failure allocating pool " + pool, (Throwable)t);
            }
        } else {
            throw new ConfigurationException("Insufficient defined resources to allocate pool " + poolName + "=" + pool);
        }
        LOGGER.info("Reserved {} bytes from resource '{}' for pool '{}'", new Object[]{pool.getSize(), pool.getServerResource(), poolName});
        return pageSource;
    }

    private void registerStoreStatistics(ServerStoreImpl store, String storeName) {
        STAT_STORE_METHOD_REFERENCES.forEach((key, value) -> this.registerStatistic(store, storeName, (String)key, STATISTICS_STORE_TAG, PROPERTY_STORE_KEY, (ValueStatistic<Number>)((ValueStatistic)value.apply(store))));
    }

    private void registerPoolStatistics(String poolName, ResourcePageSource pageSource) {
        STAT_POOL_METHOD_REFERENCES.forEach((key, value) -> this.registerStatistic(pageSource, poolName, (String)key, STATISTICS_POOL_TAG, PROPERTY_POOL_KEY, (ValueStatistic<Number>)((ValueStatistic)value.apply(pageSource))));
    }

    private void unRegisterStoreStatistics(ServerStoreImpl store) {
        TreeNode node = StatisticsManager.nodeFor((Object)store);
        if (node != null) {
            node.clean();
        }
    }

    private void unRegisterPoolStatistics(ResourcePageSource pageSource) {
        TreeNode node = StatisticsManager.nodeFor((Object)pageSource);
        if (node != null) {
            node.clean();
        }
    }

    private void registerStatistic(Object context, String name, String observerName, String tag, String propertyKey, ValueStatistic<Number> source) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("discriminator", tag);
        properties.put(propertyKey, name);
        StatisticsManager.createPassThroughStatistic((Object)context, (String)observerName, (Set)StatisticsManager.tags((String[])new String[]{tag, "tier"}), properties, source);
    }

    private void releaseDedicatedPool(String name, PageSource pageSource) {
        ResourcePageSource expectedPageSource = this.dedicatedResourcePools.get(name);
        if (expectedPageSource != null) {
            if (pageSource == expectedPageSource) {
                this.dedicatedResourcePools.remove(name);
                this.releasePool("dedicated", name, expectedPageSource);
            } else {
                LOGGER.error("Client {} attempting to destroy cluster tier '{}' with unmatched page source", (Object)name);
            }
        }
    }

    @Override
    public void prepareForDestroy() {
        this.destroyInProgress = true;
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, ServerStoreImpl> storeEntry : this.stores.entrySet()) {
            this.unRegisterStoreStatistics(storeEntry.getValue());
            storeEntry.getValue().close();
        }
        this.stores.clear();
        this.defaultServerResource = null;
        this.releasePools("shared", this.sharedResourcePools);
        this.releasePools("dedicated", this.dedicatedResourcePools);
        this.sharedResourcePools.clear();
        this.configured = false;
        this.destroyCallback.destroy(this);
    }

    private void releasePools(String poolType, Map<String, ResourcePageSource> resourcePools) {
        if (resourcePools == null) {
            return;
        }
        Iterator<Map.Entry<String, ResourcePageSource>> dedicatedPoolIterator = resourcePools.entrySet().iterator();
        while (dedicatedPoolIterator.hasNext()) {
            Map.Entry<String, ResourcePageSource> poolEntry = dedicatedPoolIterator.next();
            this.releasePool(poolType, poolEntry.getKey(), poolEntry.getValue());
            dedicatedPoolIterator.remove();
        }
    }

    private void releasePool(String poolType, String poolName, ResourcePageSource resourcePageSource) {
        ServerSideConfiguration.Pool pool = resourcePageSource.getPool();
        OffHeapResource source = this.offHeapResources.getOffHeapResource(OffHeapResourceIdentifier.identifier((String)pool.getServerResource()));
        if (source != null) {
            this.unRegisterPoolStatistics(resourcePageSource);
            source.release(pool.getSize());
            LOGGER.info("Released {} bytes from resource '{}' for {} pool '{}'", new Object[]{pool.getSize(), pool.getServerResource(), poolType, poolName});
        }
    }

    @Override
    public ServerStoreImpl createStore(String name, ServerStoreConfiguration serverStoreConfiguration, boolean forActive) throws ConfigurationException {
        ServerStoreImpl serverStore;
        if (this.stores.containsKey(name)) {
            throw new ConfigurationException("cluster tier '" + name + "' already exists");
        }
        ResourcePageSource resourcePageSource = this.getPageSource(name, serverStoreConfiguration.getPoolAllocation());
        try {
            serverStore = new ServerStoreImpl(serverStoreConfiguration, resourcePageSource, this.mapper, serverStoreConfiguration.isWriteBehindConfigured());
        }
        catch (RuntimeException rte) {
            this.releaseDedicatedPool(name, resourcePageSource);
            throw new ConfigurationException("Failed to create ServerStore.", (Throwable)rte);
        }
        this.stores.put(name, serverStore);
        if (!forActive && serverStoreConfiguration.getConsistency() == Consistency.EVENTUAL) {
            this.invalidationTrackers.put(name, new InvalidationTrackerImpl());
        }
        this.registerStoreStatistics(serverStore, name);
        return serverStore;
    }

    @Override
    public void destroyServerStore(String name) throws ClusterException {
        ServerStoreImpl store = this.stores.remove(name);
        this.unRegisterStoreStatistics(store);
        if (store == null) {
            throw new InvalidStoreException("cluster tier '" + name + "' does not exist");
        }
        this.releaseDedicatedPool(name, store.getPageSource());
        store.close();
        this.stateRepositoryManager.destroyStateRepository(name);
        this.invalidationTrackers.remove(name);
    }

    private ResourcePageSource getPageSource(String name, PoolAllocation allocation) throws ConfigurationException {
        ResourcePageSource resourcePageSource;
        if (allocation instanceof PoolAllocation.Dedicated) {
            if (this.dedicatedResourcePools.containsKey(name)) {
                throw new ConfigurationException("Fixed resource pool for cluster tier '" + name + "' already exists");
            }
            PoolAllocation.Dedicated dedicatedAllocation = (PoolAllocation.Dedicated)allocation;
            String resourceName = dedicatedAllocation.getResourceName();
            if (resourceName == null) {
                if (this.defaultServerResource == null) {
                    throw new ConfigurationException("Fixed pool for cluster tier '" + name + "' not defined; default server resource not configured");
                }
                resourceName = this.defaultServerResource;
            }
            resourcePageSource = this.createPageSource(name, new ServerSideConfiguration.Pool(dedicatedAllocation.getSize(), resourceName));
            this.dedicatedResourcePools.put(name, resourcePageSource);
        } else if (allocation instanceof PoolAllocation.Shared) {
            PoolAllocation.Shared sharedAllocation = (PoolAllocation.Shared)allocation;
            resourcePageSource = this.sharedResourcePools.get(sharedAllocation.getResourcePoolName());
            if (resourcePageSource == null) {
                throw new ConfigurationException("Shared pool named '" + sharedAllocation.getResourcePoolName() + "' undefined.");
            }
        } else {
            throw new ConfigurationException("Unexpected PoolAllocation type: " + allocation.getClass().getName());
        }
        return resourcePageSource;
    }

    @Override
    public void loadExisting(ServerSideConfiguration configuration) {
        try {
            this.validate(configuration);
        }
        catch (ClusterException e) {
            throw new AssertionError((Object)("Mismatch between entity configuration and the know configuration of the service.\nEntity configuration:" + configuration + "\nExisting: defaultResource: " + this.getDefaultServerResource() + "\n\tsharedPools: " + this.sharedResourcePools));
        }
    }

    @Override
    public EhcacheStateContext beginProcessing(EhcacheOperationMessage message, String name) {
        return () -> {};
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    @Override
    public StateRepositoryManager getStateRepositoryManager() {
        return this.stateRepositoryManager;
    }

    private static boolean nullSafeEquals(Object s1, Object s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    @Override
    public InvalidationTracker getInvalidationTracker(String name) {
        return (InvalidationTracker)this.invalidationTrackers.get(name);
    }

    static {
        STAT_STORE_METHOD_REFERENCES.put("allocatedMemory", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getAllocatedMemory));
        STAT_STORE_METHOD_REFERENCES.put("dataAllocatedMemory", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getDataAllocatedMemory));
        STAT_STORE_METHOD_REFERENCES.put("occupiedMemory", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getOccupiedMemory));
        STAT_STORE_METHOD_REFERENCES.put("dataOccupiedMemory", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getDataOccupiedMemory));
        STAT_STORE_METHOD_REFERENCES.put("entries", store -> ValueStatistics.supply((StatisticType)StatisticType.COUNTER, store::getSize));
        STAT_STORE_METHOD_REFERENCES.put("usedSlotCount", store -> ValueStatistics.supply((StatisticType)StatisticType.COUNTER, store::getUsedSlotCount));
        STAT_STORE_METHOD_REFERENCES.put("dataVitalMemory", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getDataVitalMemory));
        STAT_STORE_METHOD_REFERENCES.put("vitalMemory", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getVitalMemory));
        STAT_STORE_METHOD_REFERENCES.put("removedSlotCount", store -> ValueStatistics.supply((StatisticType)StatisticType.COUNTER, store::getRemovedSlotCount));
        STAT_STORE_METHOD_REFERENCES.put("dataSize", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getDataSize));
        STAT_STORE_METHOD_REFERENCES.put("tableCapacity", store -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, store::getTableCapacity));
        STAT_POOL_METHOD_REFERENCES.put("allocatedSize", pool -> ValueStatistics.supply((StatisticType)StatisticType.GAUGE, pool::getAllocatedSize));
    }
}

