/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Collection;
import java.util.EnumSet;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.ehcache.management.providers.statistics.LatencyHistogramConfiguration;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.registry.collect.StatisticRegistry;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.derived.latency.DefaultLatencyHistogramStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;
import org.terracotta.statistics.observer.ChainedOperationObserver;

public class StandardEhcacheStatistics
extends ExposedCacheBinding {
    private final StatisticRegistry statisticRegistry;

    StandardEhcacheStatistics(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding, StatisticsService statisticsService, TimeSource timeSource) {
        super(registryConfiguration, cacheBinding);
        this.statisticRegistry = new StatisticRegistry(cacheBinding.getCache(), () -> ((TimeSource)timeSource).getTimeMillis());
        String cacheName = cacheBinding.getAlias();
        CacheStatistics cacheStatistics = statisticsService.getCacheStatistics(cacheName);
        cacheStatistics.getKnownStatistics().forEach((arg_0, arg_1) -> ((StatisticRegistry)this.statisticRegistry).registerStatistic(arg_0, arg_1));
        LatencyHistogramConfiguration latencyHistogramConfiguration = registryConfiguration.getLatencyHistogramConfiguration();
        this.registerDerivedStatistics(cacheStatistics, "get", CacheOperationOutcomes.GetOutcome.HIT, "Cache:GetHitLatency", latencyHistogramConfiguration);
        this.registerDerivedStatistics(cacheStatistics, "get", CacheOperationOutcomes.GetOutcome.MISS, "Cache:GetMissLatency", latencyHistogramConfiguration);
        this.registerDerivedStatistics(cacheStatistics, "put", CacheOperationOutcomes.PutOutcome.PUT, "Cache:PutLatency", latencyHistogramConfiguration);
        this.registerDerivedStatistics(cacheStatistics, "remove", CacheOperationOutcomes.RemoveOutcome.SUCCESS, "Cache:RemoveLatency", latencyHistogramConfiguration);
    }

    private <T extends Enum<T>> void registerDerivedStatistics(CacheStatistics cacheStatistics, String statName, T outcome, String derivedName, LatencyHistogramConfiguration configuration) {
        Class<?> outcomeClass = outcome.getClass();
        DefaultLatencyHistogramStatistic histogram = new DefaultLatencyHistogramStatistic(configuration.getPhi(), configuration.getBucketCount(), configuration.getWindow());
        cacheStatistics.registerDerivedStatistic(outcomeClass, statName, (ChainedOperationObserver)new OperationResultFilter(EnumSet.of(outcome), new ChainedEventObserver[]{histogram}));
        this.statisticRegistry.registerStatistic(derivedName + "#50", histogram.medianStatistic());
        this.statisticRegistry.registerStatistic(derivedName + "#95", histogram.percentileStatistic(0.95));
        this.statisticRegistry.registerStatistic(derivedName + "#99", histogram.percentileStatistic(0.99));
        this.statisticRegistry.registerStatistic(derivedName + "#100", histogram.maximumStatistic());
    }

    public Collection<StatisticDescriptor> getDescriptors() {
        return this.statisticRegistry.getDescriptors();
    }

    StatisticRegistry getStatisticRegistry() {
        return this.statisticRegistry;
    }
}

