/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.terracotta.management.model.context.Context;

public class DefaultManagementRegistryConfiguration
implements ManagementRegistryServiceConfiguration {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Collection<String> tags = new TreeSet<String>();
    private Context context = Context.empty();
    private String collectorExecutorAlias = "collectorExecutor";

    public DefaultManagementRegistryConfiguration() {
        this.setCacheManagerAlias("cache-manager-" + COUNTER.getAndIncrement());
    }

    public DefaultManagementRegistryConfiguration setCacheManagerAlias(String alias) {
        return this.setContext(Context.create((String)"cacheManagerName", (String)alias));
    }

    public DefaultManagementRegistryConfiguration setContext(Context context) {
        if (!this.context.contains("cacheManagerName") && !context.contains("cacheManagerName")) {
            throw new IllegalArgumentException("'cacheManagerName' is missing from context");
        }
        this.context = this.context.with((Map)context);
        return this;
    }

    public DefaultManagementRegistryConfiguration setCollectorExecutorAlias(String collectorExecutorAlias) {
        this.collectorExecutorAlias = collectorExecutorAlias;
        return this;
    }

    public DefaultManagementRegistryConfiguration addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public DefaultManagementRegistryConfiguration addTag(String tag) {
        return this.addTags(tag);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public String getCacheManagerAlias() {
        return this.getContext().get("cacheManagerName");
    }

    @Override
    public String getCollectorExecutorAlias() {
        return this.collectorExecutorAlias;
    }

    @Override
    public Collection<String> getTags() {
        return this.tags;
    }

    public Class<ManagementRegistryService> getServiceType() {
        return ManagementRegistryService.class;
    }

    public String toString() {
        return "DefaultManagementRegistryConfiguration{context=" + this.context + ", tags=" + this.tags + ", collectorExecutorAlias='" + this.collectorExecutorAlias + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultManagementRegistryConfiguration that = (DefaultManagementRegistryConfiguration)o;
        if (!((Object)this.tags).equals(that.tags)) {
            return false;
        }
        if (!this.context.equals((Object)that.context)) {
            return false;
        }
        return this.collectorExecutorAlias != null ? this.collectorExecutorAlias.equals(that.collectorExecutorAlias) : that.collectorExecutorAlias == null;
    }

    public int hashCode() {
        int result = ((Object)this.tags).hashCode();
        result = 31 * result + this.context.hashCode();
        result = 31 * result + (this.collectorExecutorAlias != null ? this.collectorExecutorAlias.hashCode() : 0);
        return result;
    }
}

