/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.cluster;

import java.util.concurrent.Executor;
import org.slf4j.Logger;

class LoggingExecutor
implements Executor {
    private final Logger logger;
    private final Executor delegate;

    public LoggingExecutor(Executor delegate, Logger logger) {
        this.delegate = delegate;
        this.logger = logger;
    }

    @Override
    public void execute(final Runnable command) {
        this.delegate.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    command.run();
                }
                catch (RuntimeException e) {
                    LoggingExecutor.this.logger.error("ERR: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

