/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.TierOperationStatistic;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.terracotta.context.extended.OperationStatisticDescriptor;
import org.terracotta.context.extended.RegisteredCompoundStatistic;
import org.terracotta.context.extended.RegisteredCounterStatistic;
import org.terracotta.context.extended.RegisteredRatioStatistic;
import org.terracotta.context.extended.RegisteredSizeStatistic;
import org.terracotta.context.extended.RegisteredStatistic;
import org.terracotta.context.extended.StatisticsRegistry;
import org.terracotta.context.extended.ValueStatisticDescriptor;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.stats.MemoryUnit;
import org.terracotta.management.model.stats.NumberUnit;
import org.terracotta.management.model.stats.Sample;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.StatisticType;
import org.terracotta.management.model.stats.history.AverageHistory;
import org.terracotta.management.model.stats.history.CounterHistory;
import org.terracotta.management.model.stats.history.DurationHistory;
import org.terracotta.management.model.stats.history.RateHistory;
import org.terracotta.management.model.stats.history.RatioHistory;
import org.terracotta.management.model.stats.history.SizeHistory;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.ExpiringSampledStatistic;
import org.terracotta.statistics.extended.SampledStatistic;

class StandardEhcacheStatistics
extends ExposedCacheBinding {
    private final StatisticsRegistry statisticsRegistry;

    StandardEhcacheStatistics(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding, StatisticsProviderConfiguration statisticsProviderConfiguration, ScheduledExecutorService executor) {
        super(registryConfiguration, cacheBinding);
        this.statisticsRegistry = new StatisticsRegistry((Object)cacheBinding.getCache(), executor, statisticsProviderConfiguration.averageWindowDuration(), statisticsProviderConfiguration.averageWindowUnit(), statisticsProviderConfiguration.historySize(), statisticsProviderConfiguration.historyInterval(), statisticsProviderConfiguration.historyIntervalUnit(), statisticsProviderConfiguration.timeToDisable(), statisticsProviderConfiguration.timeToDisableUnit());
        EnumSet<CacheOperationOutcomes.GetOutcome> hit = EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER, CacheOperationOutcomes.GetOutcome.HIT_WITH_LOADER);
        EnumSet<CacheOperationOutcomes.GetOutcome> miss = EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER);
        OperationStatisticDescriptor getCacheStatisticDescriptor = OperationStatisticDescriptor.descriptor((String)"get", Collections.singleton("cache"), CacheOperationOutcomes.GetOutcome.class);
        this.statisticsRegistry.registerCompoundOperations("Cache:Hit", getCacheStatisticDescriptor, hit);
        this.statisticsRegistry.registerCompoundOperations("Cache:Miss", getCacheStatisticDescriptor, miss);
        this.statisticsRegistry.registerCompoundOperations("Cache:Clear", OperationStatisticDescriptor.descriptor((String)"clear", Collections.singleton("cache"), CacheOperationOutcomes.ClearOutcome.class), EnumSet.allOf(CacheOperationOutcomes.ClearOutcome.class));
        this.statisticsRegistry.registerRatios("Cache:HitRatio", getCacheStatisticDescriptor, hit, EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        this.statisticsRegistry.registerRatios("Cache:MissRatio", getCacheStatisticDescriptor, miss, EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        Class<TierOperationStatistic.TierOperationOutcomes.GetOutcome> tierOperationGetOucomeClass = TierOperationStatistic.TierOperationOutcomes.GetOutcome.class;
        OperationStatisticDescriptor getTierStatisticDescriptor = OperationStatisticDescriptor.descriptor((String)"get", Collections.singleton("tier"), tierOperationGetOucomeClass);
        this.statisticsRegistry.registerCompoundOperations("Hit", getTierStatisticDescriptor, EnumSet.of(TierOperationStatistic.TierOperationOutcomes.GetOutcome.HIT));
        this.statisticsRegistry.registerCompoundOperations("Miss", getTierStatisticDescriptor, EnumSet.of(TierOperationStatistic.TierOperationOutcomes.GetOutcome.MISS));
        this.statisticsRegistry.registerCompoundOperations("Eviction", OperationStatisticDescriptor.descriptor((String)"eviction", Collections.singleton("tier"), TierOperationStatistic.TierOperationOutcomes.EvictionOutcome.class), EnumSet.allOf(TierOperationStatistic.TierOperationOutcomes.EvictionOutcome.class));
        this.statisticsRegistry.registerRatios("HitRatio", getTierStatisticDescriptor, EnumSet.of(TierOperationStatistic.TierOperationOutcomes.GetOutcome.HIT), EnumSet.allOf(tierOperationGetOucomeClass));
        this.statisticsRegistry.registerRatios("MissRatio", getTierStatisticDescriptor, EnumSet.of(TierOperationStatistic.TierOperationOutcomes.GetOutcome.MISS), EnumSet.allOf(tierOperationGetOucomeClass));
        this.statisticsRegistry.registerCounter("MappingCount", ValueStatisticDescriptor.descriptor((String)"mappings", Collections.singleton("tier")));
        this.statisticsRegistry.registerCounter("MaxMappingCount", ValueStatisticDescriptor.descriptor((String)"maxMappings", Collections.singleton("tier")));
        this.statisticsRegistry.registerSize("AllocatedByteSize", ValueStatisticDescriptor.descriptor((String)"allocatedMemory", Collections.singleton("tier")));
        this.statisticsRegistry.registerSize("OccupiedByteSize", ValueStatisticDescriptor.descriptor((String)"occupiedMemory", Collections.singleton("tier")));
        Map registrations = this.statisticsRegistry.getRegistrations();
        for (RegisteredStatistic registeredStatistic : registrations.values()) {
            registeredStatistic.getSupport().setAlwaysOn(true);
        }
    }

    public Statistic<?, ?> queryStatistic(String statisticName, long since) {
        Map registrations = this.statisticsRegistry.getRegistrations();
        for (Map.Entry entry : registrations.entrySet()) {
            ExpiringSampledStatistic count;
            CompoundOperation compoundOperation;
            String name = (String)entry.getKey();
            RegisteredStatistic registeredStatistic = (RegisteredStatistic)entry.getValue();
            if (registeredStatistic instanceof RegisteredCompoundStatistic) {
                RegisteredCompoundStatistic registeredCompoundStatistic = (RegisteredCompoundStatistic)registeredStatistic;
                compoundOperation = registeredCompoundStatistic.getCompoundOperation();
                if ((name + "Count").equals(statisticName)) {
                    SampledStatistic count2 = compoundOperation.compound((Set)registeredCompoundStatistic.getCompound()).count();
                    return new CounterHistory(this.buildHistory(count2, since), NumberUnit.COUNT);
                }
                if ((name + "Rate").equals(statisticName)) {
                    SampledStatistic rate = compoundOperation.compound((Set)registeredCompoundStatistic.getCompound()).rate();
                    return new RateHistory(this.buildHistory(rate, since), TimeUnit.SECONDS);
                }
                if ((name + "LatencyMinimum").equals(statisticName)) {
                    SampledStatistic minimum = compoundOperation.compound((Set)registeredCompoundStatistic.getCompound()).latency().minimum();
                    return new DurationHistory(this.buildHistory(minimum, since), TimeUnit.NANOSECONDS);
                }
                if ((name + "LatencyMaximum").equals(statisticName)) {
                    SampledStatistic maximum = compoundOperation.compound((Set)registeredCompoundStatistic.getCompound()).latency().maximum();
                    return new DurationHistory(this.buildHistory(maximum, since), TimeUnit.NANOSECONDS);
                }
                if (!(name + "LatencyAverage").equals(statisticName)) continue;
                SampledStatistic average = compoundOperation.compound((Set)registeredCompoundStatistic.getCompound()).latency().average();
                return new AverageHistory(this.buildHistory(average, since), TimeUnit.NANOSECONDS);
            }
            if (registeredStatistic instanceof RegisteredRatioStatistic) {
                RegisteredRatioStatistic registeredRatioStatistic = (RegisteredRatioStatistic)registeredStatistic;
                compoundOperation = registeredRatioStatistic.getCompoundOperation();
                if (!name.equals(statisticName)) continue;
                SampledStatistic ratio = compoundOperation.ratioOf((Set)registeredRatioStatistic.getNumerator(), (Set)registeredRatioStatistic.getDenominator());
                return new RatioHistory(this.buildHistory(ratio, since), NumberUnit.RATIO);
            }
            if (registeredStatistic instanceof RegisteredSizeStatistic) {
                RegisteredSizeStatistic registeredSizeStatistic = (RegisteredSizeStatistic)registeredStatistic;
                if (!name.equals(statisticName)) continue;
                count = registeredSizeStatistic.getSampledStatistic();
                return new SizeHistory(this.buildHistory((SampledStatistic)count, since), MemoryUnit.B);
            }
            if (registeredStatistic instanceof RegisteredCounterStatistic) {
                RegisteredCounterStatistic registeredCounterStatistic = (RegisteredCounterStatistic)registeredStatistic;
                if (!name.equals(statisticName)) continue;
                count = registeredCounterStatistic.getSampledStatistic();
                return new CounterHistory(this.buildHistory((SampledStatistic)count, since), NumberUnit.COUNT);
            }
            throw new UnsupportedOperationException("Cannot handle registered statistic type : " + registeredStatistic);
        }
        throw new IllegalArgumentException("No registered statistic named '" + statisticName + "'");
    }

    private <T extends Number> List<Sample<T>> buildHistory(SampledStatistic<T> sampledStatistic, long since) {
        ArrayList<Sample<T>> result = new ArrayList<Sample<T>>();
        List history = sampledStatistic.history();
        for (Timestamped timestamped : history) {
            if (timestamped.getTimestamp() < since) continue;
            result.add(new Sample(timestamped.getTimestamp(), timestamped.getSample()));
        }
        return result;
    }

    public Collection<Descriptor> getDescriptors() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        capabilities.addAll(this.queryStatisticsRegistry());
        return capabilities;
    }

    private Set<Descriptor> queryStatisticsRegistry() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        Map registrations = this.statisticsRegistry.getRegistrations();
        for (Map.Entry entry : registrations.entrySet()) {
            String statisticName = entry.getKey().toString();
            RegisteredStatistic registeredStatistic = (RegisteredStatistic)registrations.get(statisticName);
            if (registeredStatistic instanceof RegisteredCompoundStatistic) {
                ArrayList<StatisticDescriptor> statistics = new ArrayList<StatisticDescriptor>();
                statistics.add(new StatisticDescriptor(entry.getKey() + "Count", StatisticType.COUNTER_HISTORY));
                statistics.add(new StatisticDescriptor(entry.getKey() + "Rate", StatisticType.RATE_HISTORY));
                statistics.add(new StatisticDescriptor(entry.getKey() + "LatencyMinimum", StatisticType.DURATION_HISTORY));
                statistics.add(new StatisticDescriptor(entry.getKey() + "LatencyMaximum", StatisticType.DURATION_HISTORY));
                statistics.add(new StatisticDescriptor(entry.getKey() + "LatencyAverage", StatisticType.AVERAGE_HISTORY));
                capabilities.addAll(statistics);
                continue;
            }
            if (registeredStatistic instanceof RegisteredRatioStatistic) {
                capabilities.add((Descriptor)new StatisticDescriptor(entry.getKey() + "Ratio", StatisticType.RATIO_HISTORY));
                continue;
            }
            if (registeredStatistic instanceof RegisteredCounterStatistic) {
                capabilities.add((Descriptor)new StatisticDescriptor(statisticName, StatisticType.COUNTER_HISTORY));
                continue;
            }
            if (!(registeredStatistic instanceof RegisteredSizeStatistic)) continue;
            capabilities.add((Descriptor)new StatisticDescriptor(statisticName, StatisticType.SIZE_HISTORY));
        }
        return capabilities;
    }

    public void dispose() {
        this.statisticsRegistry.clearRegistrations();
    }
}

