/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.CacheBindingManagementProvider;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.ehcache.management.providers.statistics.StandardEhcacheStatistics;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.capabilities.StatisticsCapability;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.action.Named;

@Named(value="StatisticsCapability")
public class EhcacheStatisticsProvider
extends CacheBindingManagementProvider {
    private final StatisticsProviderConfiguration statisticsProviderConfiguration;
    private final ScheduledExecutorService executor;

    public EhcacheStatisticsProvider(ManagementRegistryServiceConfiguration configuration, ScheduledExecutorService executor) {
        super(configuration);
        this.statisticsProviderConfiguration = configuration.getConfigurationFor(EhcacheStatisticsProvider.class);
        this.executor = executor;
    }

    @Override
    protected ExposedCacheBinding wrap(CacheBinding cacheBinding) {
        return new StandardEhcacheStatistics(this.registryConfiguration, cacheBinding, this.statisticsProviderConfiguration, this.executor);
    }

    protected void dispose(ExposedObject<CacheBinding> exposedObject) {
        ((StandardEhcacheStatistics)exposedObject).dispose();
    }

    public Capability getCapability() {
        StatisticsCapability.Properties properties = new StatisticsCapability.Properties(this.statisticsProviderConfiguration.averageWindowDuration(), this.statisticsProviderConfiguration.averageWindowUnit(), this.statisticsProviderConfiguration.historySize(), this.statisticsProviderConfiguration.historyInterval(), this.statisticsProviderConfiguration.historyIntervalUnit(), this.statisticsProviderConfiguration.timeToDisable(), this.statisticsProviderConfiguration.timeToDisableUnit());
        return new StatisticsCapability(this.getCapabilityName(), properties, this.getDescriptors(), this.getCapabilityContext());
    }

    public Map<String, Statistic<?, ?>> collectStatistics(Context context, Collection<String> statisticNames, long since) {
        HashMap statistics = new HashMap(statisticNames.size());
        StandardEhcacheStatistics ehcacheStatistics = (StandardEhcacheStatistics)this.findExposedObject(context);
        if (ehcacheStatistics != null) {
            for (String statisticName : statisticNames) {
                try {
                    statistics.put(statisticName, ehcacheStatistics.queryStatistic(statisticName, since));
                }
                catch (IllegalArgumentException ignored) {}
            }
        }
        return statistics;
    }
}

