/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.terracotta.context.extended.OperationStatisticDescriptor;
import org.terracotta.context.extended.RegisteredStatistic;
import org.terracotta.context.extended.StatisticsRegistry;
import org.terracotta.context.extended.ValueStatisticDescriptor;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.stats.MemoryUnit;
import org.terracotta.management.model.stats.NumberUnit;
import org.terracotta.management.model.stats.Sample;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.StatisticType;
import org.terracotta.management.model.stats.history.AverageHistory;
import org.terracotta.management.model.stats.history.CounterHistory;
import org.terracotta.management.model.stats.history.DurationHistory;
import org.terracotta.management.model.stats.history.RateHistory;
import org.terracotta.management.model.stats.history.RatioHistory;
import org.terracotta.management.model.stats.history.SizeHistory;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.SampleType;
import org.terracotta.statistics.extended.SampledStatistic;

class StandardEhcacheStatistics
extends ExposedCacheBinding {
    private static final Map<String, SampleType> COMPOUND_SUFFIXES = new HashMap<String, SampleType>();
    private final StatisticsRegistry statisticsRegistry;

    StandardEhcacheStatistics(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding, StatisticsProviderConfiguration statisticsProviderConfiguration, ScheduledExecutorService executor) {
        super(registryConfiguration, cacheBinding);
        this.statisticsRegistry = new StatisticsRegistry((Object)cacheBinding.getCache(), executor, statisticsProviderConfiguration.averageWindowDuration(), statisticsProviderConfiguration.averageWindowUnit(), statisticsProviderConfiguration.historySize(), statisticsProviderConfiguration.historyInterval(), statisticsProviderConfiguration.historyIntervalUnit(), statisticsProviderConfiguration.timeToDisable(), statisticsProviderConfiguration.timeToDisableUnit());
        EnumSet<CacheOperationOutcomes.GetOutcome> hit = EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER, CacheOperationOutcomes.GetOutcome.HIT_WITH_LOADER);
        EnumSet<CacheOperationOutcomes.GetOutcome> miss = EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER);
        OperationStatisticDescriptor getCacheStatisticDescriptor = OperationStatisticDescriptor.descriptor((String)"get", Collections.singleton("cache"), CacheOperationOutcomes.GetOutcome.class);
        this.statisticsRegistry.registerCompoundOperations("Cache:Hit", getCacheStatisticDescriptor, hit);
        this.statisticsRegistry.registerCompoundOperations("Cache:Miss", getCacheStatisticDescriptor, miss);
        this.statisticsRegistry.registerCompoundOperations("Cache:Clear", OperationStatisticDescriptor.descriptor((String)"clear", Collections.singleton("cache"), CacheOperationOutcomes.ClearOutcome.class), EnumSet.allOf(CacheOperationOutcomes.ClearOutcome.class));
        this.statisticsRegistry.registerRatios("Cache:HitRatio", getCacheStatisticDescriptor, hit, EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        this.statisticsRegistry.registerRatios("Cache:MissRatio", getCacheStatisticDescriptor, miss, EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        Class<TierOperationOutcomes.GetOutcome> tierOperationGetOucomeClass = TierOperationOutcomes.GetOutcome.class;
        OperationStatisticDescriptor getTierStatisticDescriptor = OperationStatisticDescriptor.descriptor((String)"get", Collections.singleton("tier"), tierOperationGetOucomeClass);
        this.statisticsRegistry.registerCompoundOperations("Hit", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.HIT));
        this.statisticsRegistry.registerCompoundOperations("Miss", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.MISS));
        this.statisticsRegistry.registerCompoundOperations("Eviction", OperationStatisticDescriptor.descriptor((String)"eviction", Collections.singleton("tier"), TierOperationOutcomes.EvictionOutcome.class), EnumSet.allOf(TierOperationOutcomes.EvictionOutcome.class));
        this.statisticsRegistry.registerRatios("HitRatio", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.HIT), EnumSet.allOf(tierOperationGetOucomeClass));
        this.statisticsRegistry.registerRatios("MissRatio", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.MISS), EnumSet.allOf(tierOperationGetOucomeClass));
        this.statisticsRegistry.registerCounter("MappingCount", ValueStatisticDescriptor.descriptor((String)"mappings", Collections.singleton("tier")));
        this.statisticsRegistry.registerCounter("MaxMappingCount", ValueStatisticDescriptor.descriptor((String)"maxMappings", Collections.singleton("tier")));
        this.statisticsRegistry.registerSize("AllocatedByteSize", ValueStatisticDescriptor.descriptor((String)"allocatedMemory", Collections.singleton("tier")));
        this.statisticsRegistry.registerSize("OccupiedByteSize", ValueStatisticDescriptor.descriptor((String)"occupiedMemory", Collections.singleton("tier")));
    }

    Statistic<?, ?> queryStatistic(String statisticName, long since) {
        SampledStatistic statistic = this.statisticsRegistry.findSampledStatistic(statisticName);
        if (statistic == null) {
            Iterator<Map.Entry<String, SampleType>> it = COMPOUND_SUFFIXES.entrySet().iterator();
            while (it.hasNext() && statistic == null) {
                Map.Entry<String, SampleType> entry = it.next();
                statistic = this.statisticsRegistry.findSampledCompoundStatistic(statisticName.substring(0, Math.max(0, statisticName.length() - entry.getKey().length())), entry.getValue());
            }
        }
        if (statistic != null) {
            List history = statistic.history(since);
            ArrayList<Sample> samples = new ArrayList<Sample>(history.size());
            for (Timestamped timestamped : history) {
                Sample sample = new Sample(timestamped.getTimestamp(), timestamped.getSample());
                samples.add(sample);
            }
            switch (statistic.type()) {
                case COUNTER: {
                    return new CounterHistory(samples, NumberUnit.COUNT);
                }
                case RATE: {
                    return new RateHistory(samples, TimeUnit.SECONDS);
                }
                case LATENCY_MIN: {
                    return new DurationHistory(samples, TimeUnit.NANOSECONDS);
                }
                case LATENCY_MAX: {
                    return new DurationHistory(samples, TimeUnit.NANOSECONDS);
                }
                case LATENCY_AVG: {
                    return new AverageHistory(samples, TimeUnit.NANOSECONDS);
                }
                case RATIO: {
                    return new RatioHistory(samples, NumberUnit.RATIO);
                }
                case SIZE: {
                    return new SizeHistory(samples, MemoryUnit.B);
                }
            }
            throw new UnsupportedOperationException(statistic.type().name());
        }
        throw new IllegalArgumentException("No registered statistic named '" + statisticName + "'");
    }

    public Collection<Descriptor> getDescriptors() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        Map registrations = this.statisticsRegistry.getRegistrations();
        block6: for (Map.Entry entry : registrations.entrySet()) {
            String statisticName = (String)entry.getKey();
            RegisteredStatistic registeredStatistic = (RegisteredStatistic)registrations.get(statisticName);
            switch (registeredStatistic.getType()) {
                case COUNTER: {
                    capabilities.add((Descriptor)new StatisticDescriptor(statisticName, StatisticType.COUNTER_HISTORY));
                    continue block6;
                }
                case RATIO: {
                    capabilities.add((Descriptor)new StatisticDescriptor((String)entry.getKey() + "Ratio", StatisticType.RATIO_HISTORY));
                    continue block6;
                }
                case SIZE: {
                    capabilities.add((Descriptor)new StatisticDescriptor(statisticName, StatisticType.SIZE_HISTORY));
                    continue block6;
                }
                case COMPOUND: {
                    capabilities.add((Descriptor)new StatisticDescriptor((String)entry.getKey() + "Count", StatisticType.COUNTER_HISTORY));
                    capabilities.add((Descriptor)new StatisticDescriptor((String)entry.getKey() + "Rate", StatisticType.RATE_HISTORY));
                    capabilities.add((Descriptor)new StatisticDescriptor((String)entry.getKey() + "LatencyMinimum", StatisticType.DURATION_HISTORY));
                    capabilities.add((Descriptor)new StatisticDescriptor((String)entry.getKey() + "LatencyMaximum", StatisticType.DURATION_HISTORY));
                    capabilities.add((Descriptor)new StatisticDescriptor((String)entry.getKey() + "LatencyAverage", StatisticType.AVERAGE_HISTORY));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(registeredStatistic.getType().name());
        }
        return capabilities;
    }

    void dispose() {
        this.statisticsRegistry.clearRegistrations();
    }

    static {
        COMPOUND_SUFFIXES.put("Count", SampleType.COUNTER);
        COMPOUND_SUFFIXES.put("Rate", SampleType.RATE);
        COMPOUND_SUFFIXES.put("LatencyMinimum", SampleType.LATENCY_MIN);
        COMPOUND_SUFFIXES.put("LatencyMaximum", SampleType.LATENCY_MAX);
        COMPOUND_SUFFIXES.put("LatencyAverage", SampleType.LATENCY_AVG);
    }
}

